/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.core.view.ViewCompat;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.widget.SnackBarView;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\tH\u0002J\u0016\u0010\"\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/nguyenhoanglam/imagepicker/widget/SnackBarView;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "actionButton", "Landroid/widget/Button;", "<set-?>", "", "isShowing", "()Z", "messageText", "Landroid/widget/TextView;", "convertDpToPixels", "dp", "", "hide", "", "runnable", "Ljava/lang/Runnable;", "init", "setOnActionClickListener", "actionText", "", "onClickListener", "Landroid/view/View$OnClickListener;", "setText", "textResId", "show", "Companion", "imagepicker_release"})
public final class SnackBarView
extends RelativeLayout {
    private TextView messageText;
    private Button actionButton;
    private boolean isShowing;
    private static final int ANIM_DURATION = 200;
    private static final Interpolator INTERPOLATOR;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    public final boolean isShowing() {
        return this.isShowing;
    }

    private final void init(Context context) {
        View.inflate((Context)context, (int)R.layout.imagepicker_snackbar, (ViewGroup)((ViewGroup)this));
        if (this.isInEditMode()) {
            return;
        }
        this.setBackgroundColor(Color.parseColor((String)"#323232"));
        this.setTranslationY(this.getHeight());
        this.setAlpha(0.0f);
        this.isShowing = false;
        int horizontalPadding = this.convertDpToPixels(context, 24.0f);
        int verticalPadding = this.convertDpToPixels(context, 14.0f);
        this.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        View view = this.findViewById(R.id.text_snackbar_message);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.text_snackbar_message)");
        this.messageText = (TextView)view;
        View view2 = this.findViewById(R.id.button_snackbar_action);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.button_snackbar_action)");
        this.actionButton = (Button)view2;
    }

    private final void setText(int textResId) {
        TextView textView = this.messageText;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageText");
        }
        textView.setText(textResId);
    }

    private final void setOnActionClickListener(String actionText, View.OnClickListener onClickListener) {
        Button button = this.actionButton;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"actionButton");
        }
        button.setText((CharSequence)actionText);
        Button button2 = this.actionButton;
        if (button2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"actionButton");
        }
        button2.setOnClickListener(new View.OnClickListener(this, onClickListener){
            final /* synthetic */ SnackBarView this$0;
            final /* synthetic */ View.OnClickListener $onClickListener;

            public final void onClick(View view) {
                SnackBarView.access$hide(this.this$0, new Runnable(this, view){
                    final /* synthetic */ setOnActionClickListener.1 this$0;
                    final /* synthetic */ View $view;

                    public final void run() {
                        this.this$0.$onClickListener.onClick(this.$view);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$view = view;
                    }
                });
            }
            {
                this.this$0 = snackBarView;
                this.$onClickListener = onClickListener;
            }
        });
    }

    public final void show(int textResId, @NotNull View.OnClickListener onClickListener) {
        Intrinsics.checkParameterIsNotNull((Object)onClickListener, (String)"onClickListener");
        this.setText(textResId);
        String string2 = this.getContext().getString(R.string.imagepicker_action_ok);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.string.imagepicker_action_ok)");
        this.setOnActionClickListener(string2, onClickListener);
        ViewCompat.animate((View)((View)this)).translationY(0.0f).setDuration((long)200).setInterpolator(INTERPOLATOR).alpha(1.0f);
        this.isShowing = true;
    }

    private final void hide(Runnable runnable) {
        ViewCompat.animate((View)((View)this)).translationY((float)this.getHeight()).setDuration((long)200).alpha(0.5f).withEndAction(runnable);
        this.isShowing = false;
    }

    private final int convertDpToPixels(Context context, float dp) {
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public SnackBarView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.init(context);
    }

    public SnackBarView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.init(context);
    }

    public SnackBarView(@NotNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    static {
        Companion = new Companion(null);
        INTERPOLATOR = (Interpolator)new FastOutLinearInInterpolator();
    }

    public static final /* synthetic */ void access$hide(SnackBarView $this, Runnable runnable) {
        $this.hide(runnable);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/nguyenhoanglam/imagepicker/widget/SnackBarView$Companion;", "", "()V", "ANIM_DURATION", "", "INTERPOLATOR", "Landroid/view/animation/Interpolator;", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

