/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.camera;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import androidx.core.content.FileProvider;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.helper.LogHelper;
import com.nguyenhoanglam.imagepicker.model.Config;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.OnImageReadyListener;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u001aR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/camera/DefaultCameraModule;", "Lcom/nguyenhoanglam/imagepicker/ui/camera/CameraModule;", "Ljava/io/Serializable;", "()V", "imageFilePath", "", "imageUri", "Landroid/net/Uri;", "createImageFileUri", "context", "Landroid/content/Context;", "rootDirectory", "directory", "getCameraIntent", "Landroid/content/Intent;", "config", "Lcom/nguyenhoanglam/imagepicker/model/Config;", "getImage", "", "isRequireId", "", "imageReadyListener", "Lcom/nguyenhoanglam/imagepicker/ui/camera/OnImageReadyListener;", "getImageIdFromURI", "", "uri", "(Landroid/content/Context;Landroid/net/Uri;)Ljava/lang/Long;", "imagepicker_release"})
public final class DefaultCameraModule
implements CameraModule,
Serializable {
    private String imageFilePath;
    private Uri imageUri;

    @Override
    @Nullable
    public Intent getCameraIntent(@NotNull Context context, @NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        Uri uri = this.createImageFileUri(context, config.getRootDirectoryName(), config.getDirectoryName());
        LogHelper logHelper = LogHelper.Companion.getInstance();
        if (logHelper != null) {
            logHelper.d("Created image URI " + uri);
        }
        if (uri != null) {
            this.imageUri = uri;
            intent.putExtra("output", (Parcelable)uri);
            ImageHelper.INSTANCE.grantAppPermission(context, intent, uri);
            return intent;
        }
        return null;
    }

    private final Uri createImageFileUri(Context context, String rootDirectory, String directory) {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String fileName = "IMG_" + timeStamp + ".jpg";
        Uri uri = null;
        if (Build.VERSION.SDK_INT >= 29) {
            String filePath = rootDirectory + '/' + directory;
            ContentValues contentValues = new ContentValues();
            boolean bl = false;
            boolean bl2 = false;
            ContentValues $this$apply = contentValues;
            boolean bl3 = false;
            $this$apply.put("relative_path", filePath);
            $this$apply.put("_display_name", fileName);
            $this$apply.put("mime_type", "image/jpeg");
            ContentValues contentValues2 = contentValues;
            if (Intrinsics.areEqual((Object)rootDirectory, (Object)Config.CREATOR.getROOT_DIR_DCIM()) || Intrinsics.areEqual((Object)rootDirectory, (Object)Config.CREATOR.getROOT_DIR_PICTURES())) {
                uri = context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues2);
            } else if (Intrinsics.areEqual((Object)rootDirectory, (Object)Config.CREATOR.getROOT_DIR_DOWNLOAD())) {
                uri = context.getContentResolver().insert(MediaStore.Downloads.EXTERNAL_CONTENT_URI, contentValues2);
            }
            Uri uri2 = uri;
            this.imageFilePath = uri2 != null ? uri2.getPath() : null;
        } else {
            File dir = Environment.getExternalStoragePublicDirectory((String)rootDirectory);
            File imageFile = new File(dir, '/' + directory + '/' + fileName);
            File parentFile = imageFile.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            Context appContext = context.getApplicationContext();
            StringBuilder stringBuilder = new StringBuilder();
            Context context2 = appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"appContext");
            String providerName = stringBuilder.append(context2.getPackageName()).append(".fileprovider").toString();
            try {
                uri = FileProvider.getUriForFile((Context)appContext, (String)providerName, (File)imageFile);
            }
            catch (Exception e) {
                return null;
            }
            this.imageFilePath = imageFile.getAbsolutePath();
        }
        return uri;
    }

    @Override
    public void getImage(@NotNull Context context, boolean isRequireId, @Nullable OnImageReadyListener imageReadyListener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean bl = false;
        boolean bl2 = false;
        if (imageReadyListener == null) {
            boolean bl3 = false;
            String string2 = "OnImageReadyListener must not be null";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (this.imageFilePath == null) {
            imageReadyListener.onImageNotReady();
            return;
        }
        if (this.imageFilePath != null) {
            Context context2 = context.getApplicationContext();
            String[] stringArray = new String[1];
            String string3 = this.imageFilePath;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            stringArray[0] = string3;
            MediaScannerConnection.scanFile((Context)context2, (String[])stringArray, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(this, isRequireId, context, imageReadyListener){
                final /* synthetic */ DefaultCameraModule this$0;
                final /* synthetic */ boolean $isRequireId;
                final /* synthetic */ Context $context;
                final /* synthetic */ OnImageReadyListener $imageReadyListener;

                public final void onScanCompleted(String path, Uri uri) {
                    if (path != null) {
                        long l;
                        if (this.$isRequireId && DefaultCameraModule.access$getImageUri$p(this.this$0) != null) {
                            Uri uri2 = DefaultCameraModule.access$getImageUri$p(this.this$0);
                            if (uri2 == null) {
                                Intrinsics.throwNpe();
                            }
                            Long l2 = DefaultCameraModule.access$getImageIdFromURI(this.this$0, this.$context, uri2);
                            l = l2 != null ? l2 : 0L;
                        } else {
                            l = 0L;
                        }
                        long id2 = l;
                        this.$imageReadyListener.onImageReady(ImageHelper.INSTANCE.singleListFromPath(id2, path));
                    } else {
                        this.$imageReadyListener.onImageNotReady();
                    }
                    Uri uri3 = uri;
                    Intrinsics.checkExpressionValueIsNotNull((Object)uri3, (String)"uri");
                    ImageHelper.INSTANCE.revokeAppPermission(this.$context, uri3);
                    DefaultCameraModule.access$setImageFilePath$p(this.this$0, null);
                    DefaultCameraModule.access$setImageUri$p(this.this$0, null);
                }
                {
                    this.this$0 = defaultCameraModule;
                    this.$isRequireId = bl;
                    this.$context = context;
                    this.$imageReadyListener = onImageReadyListener;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Long getImageIdFromURI(Context context, Uri uri) {
        Long l;
        Cursor cursor = null;
        try {
            String[] projection = new String[]{"_id"};
            Cursor cursor2 = cursor = context.getContentResolver().query(uri, projection, null, null, null);
            if (cursor2 != null) {
                cursor2.moveToFirst();
            }
            Cursor cursor3 = cursor;
            l = cursor3 != null ? Long.valueOf(cursor3.getLong(cursor.getColumnIndex("_id"))) : null;
        }
        catch (Exception e) {
            l = null;
        }
        finally {
            Cursor cursor4 = cursor;
            if (cursor4 != null) {
                cursor4.close();
            }
        }
        return l;
    }

    public static final /* synthetic */ Uri access$getImageUri$p(DefaultCameraModule $this) {
        return $this.imageUri;
    }

    public static final /* synthetic */ void access$setImageUri$p(DefaultCameraModule $this, Uri uri) {
        $this.imageUri = uri;
    }

    public static final /* synthetic */ Long access$getImageIdFromURI(DefaultCameraModule $this, Context context, Uri uri) {
        return $this.getImageIdFromURI(context, uri);
    }

    public static final /* synthetic */ String access$getImageFilePath$p(DefaultCameraModule $this) {
        return $this.imageFilePath;
    }

    public static final /* synthetic */ void access$setImageFilePath$p(DefaultCameraModule $this, String string2) {
        $this.imageFilePath = string2;
    }
}

