/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.extension.ExtensionsKt;
import com.nguyenhoanglam.imagepicker.helper.CameraHelper;
import com.nguyenhoanglam.imagepicker.helper.LogHelper;
import com.nguyenhoanglam.imagepicker.helper.PermissionHelper;
import com.nguyenhoanglam.imagepicker.helper.PreferenceHelper;
import com.nguyenhoanglam.imagepicker.model.Config;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.DefaultCameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.OnImageReadyListener;
import com.nguyenhoanglam.imagepicker.widget.SnackBarView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\"\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\u0012\u0010\u001b\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J+\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0010H\u0014J\b\u0010#\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/camera/CameraActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "cameraModule", "Lcom/nguyenhoanglam/imagepicker/ui/camera/CameraModule;", "config", "Lcom/nguyenhoanglam/imagepicker/model/Config;", "isOpeningCamera", "", "logger", "Lcom/nguyenhoanglam/imagepicker/helper/LogHelper;", "permissions", "", "", "[Ljava/lang/String;", "captureImage", "", "captureImageWithPermission", "finish", "finishCaptureImage", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onRequestPermissionsResult", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResume", "requestCameraPermission", "imagepicker_release"})
public final class CameraActivity
extends AppCompatActivity {
    private final String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"};
    private Config config;
    private final CameraModule cameraModule = new DefaultCameraModule();
    private final LogHelper logger = LogHelper.Companion.getInstance();
    private boolean isOpeningCamera;
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getIntent() == null) {
            this.finish();
            return;
        }
        this.config = (Config)this.getIntent().getParcelableExtra("ImagePickerConfig");
        this.setContentView(R.layout.imagepicker_activity_camera);
    }

    protected void onResume() {
        super.onResume();
        if (PermissionHelper.INSTANCE.hasSelfPermissions((Context)this, this.permissions) && this.isOpeningCamera) {
            this.isOpeningCamera = false;
        } else if (!((SnackBarView)this._$_findCachedViewById(R.id.snackbar)).isShowing()) {
            this.captureImageWithPermission();
        }
    }

    private final void captureImageWithPermission() {
        if (PermissionHelper.INSTANCE.hasSelfPermissions((Context)this, this.permissions)) {
            this.captureImage();
        } else {
            LogHelper logHelper = this.logger;
            if (logHelper != null) {
                logHelper.w("Camera permission is not granted. Requesting permission");
            }
            this.requestCameraPermission();
        }
    }

    private final void captureImage() {
        Intent intent;
        if (!CameraHelper.INSTANCE.checkCameraAvailability((Context)this)) {
            this.finish();
            return;
        }
        Context context = (Context)this;
        Config config = this.config;
        if (config == null) {
            Intrinsics.throwNpe();
        }
        if ((intent = this.cameraModule.getCameraIntent(context, config)) == null) {
            String string2 = this.getString(R.string.imagepicker_error_create_image_file);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(R.string.image\u2026_error_create_image_file)");
            ExtensionsKt.showToast$default((Context)this, string2, 0, 2, null);
            return;
        }
        this.startActivityForResult(intent, 101);
        this.isOpeningCamera = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void requestCameraPermission() {
        LogHelper logHelper = this.logger;
        if (logHelper != null) {
            logHelper.w("Write External permission is not granted. Requesting permission...");
        }
        boolean hasPermissionDisabled = false;
        boolean wesGranted = PermissionHelper.INSTANCE.hasSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE");
        boolean cameraGranted = PermissionHelper.INSTANCE.hasSelfPermission((Context)this, "android.permission.CAMERA");
        if (!(wesGranted || PermissionHelper.INSTANCE.shouldShowRequestPermissionRationale((Activity)this, "android.permission.WRITE_EXTERNAL_STORAGE") || PreferenceHelper.isFirstTimeAskingPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE"))) {
            hasPermissionDisabled = true;
        }
        if (!(cameraGranted || PermissionHelper.INSTANCE.shouldShowRequestPermissionRationale((Activity)this, "android.permission.CAMERA") || PreferenceHelper.isFirstTimeAskingPermission((Context)this, "android.permission.CAMERA"))) {
            hasPermissionDisabled = true;
        }
        List permissions = new ArrayList();
        if (!hasPermissionDisabled) {
            void $this$toTypedArray$iv;
            if (!wesGranted) {
                permissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
                PreferenceHelper.firstTimeAskingPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE", false);
            }
            if (!cameraGranted) {
                permissions.add("android.permission.CAMERA");
                PreferenceHelper.firstTimeAskingPermission((Context)this, "android.permission.CAMERA", false);
            }
            Collection collection = permissions;
            Activity activity = (Activity)this;
            PermissionHelper permissionHelper = PermissionHelper.INSTANCE;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            permissionHelper.requestAllPermissions(activity, stringArray2, 103);
        } else {
            ((SnackBarView)this._$_findCachedViewById(R.id.snackbar)).show(R.string.imagepicker_msg_no_write_external_storage_camera_permission, new View.OnClickListener(this){
                final /* synthetic */ CameraActivity this$0;

                public final void onClick(View it) {
                    PermissionHelper.INSTANCE.openAppSettings((Activity)this.this$0);
                }
                {
                    this.this$0 = cameraActivity;
                }
            });
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        switch (requestCode) {
            case 103: {
                if (PermissionHelper.INSTANCE.hasGranted(grantResults)) {
                    LogHelper logHelper = this.logger;
                    if (logHelper != null) {
                        logHelper.d("Camera permission granted");
                    }
                    this.captureImage();
                    return;
                }
                LogHelper logHelper = this.logger;
                if (logHelper != null) {
                    logHelper.e("Permission not granted: results len = " + grantResults.length + " Result code = " + (grantResults.length > 0 ? Integer.valueOf(grantResults[0]) : "(empty)"));
                }
                boolean shouldShowSnackBar = false;
                for (int grantResult : grantResults) {
                    if (!PermissionHelper.INSTANCE.hasGranted(grantResult)) continue;
                    shouldShowSnackBar = true;
                    break;
                }
                if (shouldShowSnackBar) {
                    ((SnackBarView)this._$_findCachedViewById(R.id.snackbar)).show(R.string.imagepicker_msg_no_write_external_storage_camera_permission, new View.OnClickListener(this){
                        final /* synthetic */ CameraActivity this$0;

                        public final void onClick(View it) {
                            PermissionHelper.INSTANCE.openAppSettings((Activity)this.this$0);
                        }
                        {
                            this.this$0 = cameraActivity;
                        }
                    });
                    break;
                }
                this.finish();
                break;
            }
            default: {
                LogHelper logHelper = this.logger;
                if (logHelper != null) {
                    logHelper.d("Got unexpected permission result: " + requestCode);
                }
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
                this.finish();
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 101) {
            if (resultCode == -1) {
                this.finishCaptureImage();
            } else {
                this.setResult(0, new Intent());
                this.finish();
            }
        }
    }

    private final void finishCaptureImage() {
        Context context = (Context)this;
        Config config = this.config;
        if (config == null) {
            Intrinsics.throwNpe();
        }
        this.cameraModule.getImage(context, config.isCameraOnly(), new OnImageReadyListener(this){
            final /* synthetic */ CameraActivity this$0;

            public void onImageReady(@NotNull ArrayList<Image> images) {
                Intrinsics.checkParameterIsNotNull(images, (String)"images");
                Intent data = new Intent();
                data.putParcelableArrayListExtra("ImagePickerImages", images);
                this.this$0.setResult(-1, data);
                this.this$0.finish();
            }

            public void onImageNotReady() {
                Intent data = new Intent();
                String string2 = "ImagePickerImages";
                Intent intent = data;
                boolean bl = false;
                ArrayList<E> arrayList = new ArrayList<E>();
                intent.putParcelableArrayListExtra(string2, arrayList);
                this.this$0.setResult(-1, data);
                this.this$0.finish();
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public void onBackPressed() {
        this.setResult(0);
        this.finish();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

