/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.content.Context;
import android.database.Cursor;
import android.provider.MediaStore;
import com.nguyenhoanglam.imagepicker.listener.OnImageLoaderListener;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ImageFileLoader {
    private final String[] projection = new String[]{"_id", "_display_name", "_data", "bucket_display_name"};
    private Context context;
    private ExecutorService executorService;

    public ImageFileLoader(Context context) {
        this.context = context;
    }

    private static File makeSafeFile(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        try {
            return new File(path);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public void loadDeviceImages(boolean isFolderMode, OnImageLoaderListener listener) {
        this.getExecutorService().execute(new ImageLoadRunnable(isFolderMode, listener));
    }

    public void abortLoadImages() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
        return this.executorService;
    }

    private class ImageLoadRunnable
    implements Runnable {
        private boolean isFolderMode;
        private OnImageLoaderListener listener;

        public ImageLoadRunnable(boolean isFolderMode, OnImageLoaderListener listener) {
            this.isFolderMode = isFolderMode;
            this.listener = listener;
        }

        @Override
        public void run() {
            LinkedHashMap<String, Folder> folderMap;
            Cursor cursor = ImageFileLoader.this.context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, ImageFileLoader.this.projection, null, null, "date_added");
            if (cursor == null) {
                this.listener.onFailed(new NullPointerException());
                return;
            }
            ArrayList<Image> images = new ArrayList<Image>(cursor.getCount());
            LinkedHashMap<String, Folder> linkedHashMap = folderMap = this.isFolderMode ? new LinkedHashMap<String, Folder>() : null;
            if (cursor.moveToLast()) {
                do {
                    long id = cursor.getLong(cursor.getColumnIndex(ImageFileLoader.this.projection[0]));
                    String name = cursor.getString(cursor.getColumnIndex(ImageFileLoader.this.projection[1]));
                    String path = cursor.getString(cursor.getColumnIndex(ImageFileLoader.this.projection[2]));
                    String bucket = cursor.getString(cursor.getColumnIndex(ImageFileLoader.this.projection[3]));
                    File file = ImageFileLoader.makeSafeFile(path);
                    if (file == null || !file.exists()) continue;
                    Image image = new Image(id, name, path);
                    images.add(image);
                    if (folderMap == null) continue;
                    Folder folder = (Folder)folderMap.get(bucket);
                    if (folder == null) {
                        folder = new Folder(bucket);
                        folderMap.put(bucket, folder);
                    }
                    folder.getImages().add(image);
                } while (cursor.moveToPrevious());
            }
            cursor.close();
            ArrayList folders = null;
            if (folderMap != null) {
                folders = new ArrayList(folderMap.values());
            }
            this.listener.onImageLoaded(images, folders);
        }
    }
}

