/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.widget;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.animation.FastOutLinearInInterpolator;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nguyenhoanglam.imagepicker.R;

public class SnackBarView
extends RelativeLayout {
    private static final int ANIM_DURATION = 200;
    private static final Interpolator INTERPOLATOR = new FastOutLinearInInterpolator();
    private TextView messageText;
    private Button actionButton;
    private boolean isShowing;

    public SnackBarView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public SnackBarView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SnackBarView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        View.inflate((Context)context, (int)R.layout.imagepicker_snackbar, (ViewGroup)this);
        if (this.isInEditMode()) {
            return;
        }
        this.setBackgroundColor(Color.parseColor((String)"#323232"));
        this.setTranslationY(this.getHeight());
        this.setAlpha(0.0f);
        this.isShowing = false;
        int horizontalPadding = this.convertDpToPixels(context, 24.0f);
        int verticalPadding = this.convertDpToPixels(context, 14.0f);
        this.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        this.messageText = (TextView)this.findViewById(R.id.text_snackbar_message);
        this.actionButton = (Button)this.findViewById(R.id.button_snackbar_action);
    }

    private void setText(int textResId) {
        this.messageText.setText(textResId);
    }

    private void setOnActionClickListener(String actionText, final View.OnClickListener onClickListener) {
        this.actionButton.setText((CharSequence)actionText);
        this.actionButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(final View view) {
                SnackBarView.this.hide(new Runnable(){

                    @Override
                    public void run() {
                        onClickListener.onClick(view);
                    }
                });
            }
        });
    }

    public void show(int textResId, View.OnClickListener onClickListener) {
        this.setText(textResId);
        this.setOnActionClickListener(this.getContext().getString(R.string.imagepicker_action_ok), onClickListener);
        ViewCompat.animate((View)this).translationY(0.0f).setDuration(200L).setInterpolator(INTERPOLATOR).alpha(1.0f);
        this.isShowing = true;
    }

    private void hide(Runnable runnable) {
        ViewCompat.animate((View)this).translationY((float)this.getHeight()).setDuration(200L).alpha(0.5f).withEndAction(runnable);
        this.isShowing = false;
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    private int convertDpToPixels(Context context, float dp) {
        int px = (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
        return px;
    }
}

