/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.listener.OnImageLoaderListener;
import com.nguyenhoanglam.imagepicker.model.Config;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.DefaultCameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.OnImageReadyListener;
import com.nguyenhoanglam.imagepicker.ui.common.BasePresenter;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImageFileLoader;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerView;
import java.io.File;
import java.util.List;

public class ImagePickerPresenter
extends BasePresenter<ImagePickerView> {
    private ImageFileLoader imageLoader;
    private CameraModule cameraModule = new DefaultCameraModule();
    private Handler handler = new Handler(Looper.getMainLooper());

    public ImagePickerPresenter(ImageFileLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    public void abortLoading() {
        this.imageLoader.abortLoadImages();
    }

    public void loadImages(boolean isFolderMode) {
        if (!this.isViewAttached()) {
            return;
        }
        ((ImagePickerView)this.getView()).showLoading(true);
        this.imageLoader.loadDeviceImages(isFolderMode, new OnImageLoaderListener(){

            @Override
            public void onImageLoaded(final List<Image> images, final List<Folder> folders) {
                ImagePickerPresenter.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (ImagePickerPresenter.this.isViewAttached()) {
                            boolean isEmpty;
                            ((ImagePickerView)ImagePickerPresenter.this.getView()).showFetchCompleted(images, folders);
                            boolean bl = isEmpty = folders != null ? folders.isEmpty() : images.isEmpty();
                            if (isEmpty) {
                                ((ImagePickerView)ImagePickerPresenter.this.getView()).showEmpty();
                            } else {
                                ((ImagePickerView)ImagePickerPresenter.this.getView()).showLoading(false);
                            }
                        }
                    }
                });
            }

            @Override
            public void onFailed(final Throwable throwable) {
                ImagePickerPresenter.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (ImagePickerPresenter.this.isViewAttached()) {
                            ((ImagePickerView)ImagePickerPresenter.this.getView()).showError(throwable);
                        }
                    }
                });
            }
        });
    }

    void captureImage(Activity activity, Config config, int requestCode) {
        Context context = activity.getApplicationContext();
        Intent intent = this.cameraModule.getCameraIntent((Context)activity, config);
        if (intent == null) {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.imagepicker_error_create_image_file), (int)1).show();
            return;
        }
        activity.startActivityForResult(intent, requestCode);
    }

    public void finishCaptureImage(Context context, Intent data, final Config config) {
        this.cameraModule.getImage(context, data, new OnImageReadyListener(){

            @Override
            public void onImageReady(List<Image> images) {
                if (!config.isMultipleMode()) {
                    ((ImagePickerView)ImagePickerPresenter.this.getView()).finishPickImages(images);
                } else {
                    ((ImagePickerView)ImagePickerPresenter.this.getView()).showCapturedImage();
                }
            }
        });
    }

    public void onDoneSelectImages(List<Image> selectedImages) {
        if (selectedImages != null && !selectedImages.isEmpty()) {
            for (int i = 0; i < selectedImages.size(); ++i) {
                Image image = selectedImages.get(i);
                File file = new File(image.getPath());
                if (file.exists()) continue;
                selectedImages.remove(i);
                --i;
            }
        }
        ((ImagePickerView)this.getView()).finishPickImages(selectedImages);
    }
}

