/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ImageUtils {
    private static final String TAG = "ImageUtils";

    public static File createImageFile(String directory) {
        File mediaStorageDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), directory);
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            Log.d((String)TAG, (String)("Oops! Failed create " + directory + " directory"));
            return null;
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "IMG_" + timeStamp;
        File imageFile = null;
        try {
            imageFile = File.createTempFile(imageFileName, ".jpg", mediaStorageDir);
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)("Oops! Failed create " + imageFileName + " file"));
        }
        return imageFile;
    }
}

