/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.adapter;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.listeners.OnImageClickListener;
import com.nguyenhoanglam.imagepicker.model.Image;
import java.util.List;

public class ImagePickerAdapter
extends RecyclerView.Adapter<ImageViewHolder> {
    private Context context;
    private LayoutInflater inflater;
    private List<Image> images;
    private List<Image> selectedImages;
    private OnImageClickListener itemClickListener;

    public ImagePickerAdapter(Context context, List<Image> images, List<Image> selectedImages, OnImageClickListener itemClickListener) {
        this.context = context;
        this.images = images;
        this.selectedImages = selectedImages;
        this.itemClickListener = itemClickListener;
        this.inflater = LayoutInflater.from((Context)this.context);
    }

    public ImageViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = this.inflater.inflate(R.layout.item_image, parent, false);
        return new ImageViewHolder(itemView, this.itemClickListener);
    }

    public void onBindViewHolder(ImageViewHolder viewHolder, int position) {
        Image image = this.images.get(position);
        Glide.with((Context)this.context).load(image.getPath()).placeholder(R.drawable.image_placeholder).error(R.drawable.image_placeholder).into(viewHolder.imageView);
        if (this.isSelected(image)) {
            viewHolder.alphaView.setAlpha(0.5f);
            ((FrameLayout)viewHolder.itemView).setForeground(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_done_white));
        } else {
            viewHolder.alphaView.setAlpha(0.0f);
            ((FrameLayout)viewHolder.itemView).setForeground(null);
        }
    }

    private boolean isSelected(Image image) {
        for (Image selectedImage : this.selectedImages) {
            if (!selectedImage.getPath().equals(image.getPath())) continue;
            return true;
        }
        return false;
    }

    public int getItemCount() {
        return this.images.size();
    }

    public void setData(List<Image> images) {
        this.images.clear();
        this.images.addAll(images);
    }

    public void addAll(List<Image> images) {
        int startIndex = this.images.size();
        this.images.addAll(startIndex, images);
        this.notifyItemRangeInserted(startIndex, images.size());
    }

    public void addSelected(Image image) {
        this.selectedImages.add(image);
        this.notifyItemChanged(this.images.indexOf(image));
    }

    public void removeSelectedImage(Image image) {
        this.selectedImages.remove(image);
        this.notifyItemChanged(this.images.indexOf(image));
    }

    public void removeSelectedPosition(int position, int clickPosition) {
        this.selectedImages.remove(position);
        this.notifyItemChanged(clickPosition);
    }

    public void removeAllSelectedSingleClick() {
        this.selectedImages.clear();
        this.notifyDataSetChanged();
    }

    public static class ImageViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private ImageView imageView;
        private View alphaView;
        private final OnImageClickListener itemClickListener;

        public ImageViewHolder(View itemView, OnImageClickListener itemClickListener) {
            super(itemView);
            this.imageView = (ImageView)itemView.findViewById(R.id.image_view);
            this.alphaView = itemView.findViewById(R.id.view_alpha);
            this.itemClickListener = itemClickListener;
            itemView.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View view) {
            view.setSelected(true);
            this.itemClickListener.onClick(view, this.getAdapterPosition());
        }
    }
}

