/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.database.Cursor;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.os.Process;
import android.preference.PreferenceManager;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.FileProvider;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.adapter.FolderPickerAdapter;
import com.nguyenhoanglam.imagepicker.adapter.ImagePickerAdapter;
import com.nguyenhoanglam.imagepicker.helper.ImageUtils;
import com.nguyenhoanglam.imagepicker.listeners.OnFolderClickListener;
import com.nguyenhoanglam.imagepicker.listeners.OnImageClickListener;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.view.GridSpacingItemDecoration;
import com.nguyenhoanglam.imagepicker.view.ProgressWheel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImagePickerActivity
extends AppCompatActivity
implements OnImageClickListener {
    private static final String TAG = "ImagePickerActivity";
    public static final int MODE_SINGLE = 1;
    public static final int MODE_MULTIPLE = 2;
    public static final String INTENT_EXTRA_SELECTED_IMAGES = "selectedImages";
    public static final String INTENT_EXTRA_LIMIT = "limit";
    public static final String INTENT_EXTRA_SHOW_CAMERA = "showCamera";
    public static final String INTENT_EXTRA_MODE = "mode";
    public static final String INTENT_EXTRA_FOLDER_MODE = "folderMode";
    public static final String INTENT_EXTRA_FOLDER_TITLE = "folderTitle";
    public static final String INTENT_EXTRA_IMAGE_TITLE = "imageTitle";
    public static final String INTENT_EXTRA_IMAGE_DIRECTORY = "imageDirectory";
    private List<Folder> folders;
    private ArrayList<Image> images;
    private String currentImagePath;
    private String imageDirectory;
    private ArrayList<Image> selectedImages;
    private boolean showCamera;
    private int mode;
    private boolean folderMode;
    private int limit;
    private String folderTitle;
    private String imageTitle;
    private ActionBar actionBar;
    private MenuItem menuDone;
    private MenuItem menuCamera;
    private final int menuDoneId = 100;
    private final int menuCameraId = 101;
    private RelativeLayout mainLayout;
    private ProgressWheel progressBar;
    private TextView emptyTextView;
    private RecyclerView recyclerView;
    private GridLayoutManager layoutManager;
    private GridSpacingItemDecoration itemOffsetDecoration;
    private int imageColumns;
    private int folderColumns;
    private ImagePickerAdapter imageAdapter;
    private FolderPickerAdapter folderAdapter;
    private ContentObserver observer;
    private Handler handler;
    private Thread thread;
    private final String[] projection = new String[]{"_id", "_display_name", "_data", "bucket_display_name"};
    private Parcelable foldersState;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_picker);
        Intent intent = this.getIntent();
        if (intent == null) {
            this.finish();
        }
        this.mainLayout = (RelativeLayout)this.findViewById(R.id.main);
        this.progressBar = (ProgressWheel)this.findViewById(R.id.progress_bar);
        this.emptyTextView = (TextView)this.findViewById(R.id.tv_empty_images);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.actionBar = this.getSupportActionBar();
        if (this.actionBar != null) {
            this.actionBar.setDisplayHomeAsUpEnabled(true);
            this.actionBar.setHomeAsUpIndicator(R.drawable.ic_arrow_back);
            this.actionBar.setDisplayShowTitleEnabled(true);
        }
        this.limit = intent.getIntExtra(INTENT_EXTRA_LIMIT, 999);
        this.mode = intent.getIntExtra(INTENT_EXTRA_MODE, 2);
        this.folderMode = intent.getBooleanExtra(INTENT_EXTRA_FOLDER_MODE, false);
        this.folderTitle = intent.hasExtra(INTENT_EXTRA_FOLDER_TITLE) ? intent.getStringExtra(INTENT_EXTRA_FOLDER_TITLE) : this.getString(R.string.title_folder);
        this.imageTitle = intent.hasExtra(INTENT_EXTRA_IMAGE_TITLE) ? intent.getStringExtra(INTENT_EXTRA_IMAGE_TITLE) : this.getString(R.string.title_select_image);
        this.imageDirectory = intent.getStringExtra(INTENT_EXTRA_IMAGE_DIRECTORY);
        if (this.imageDirectory == null || TextUtils.isEmpty((CharSequence)this.imageDirectory)) {
            this.imageDirectory = this.getString(R.string.image_directory);
        }
        this.showCamera = intent.getBooleanExtra(INTENT_EXTRA_SHOW_CAMERA, true);
        if (this.mode == 2 && intent.hasExtra(INTENT_EXTRA_SELECTED_IMAGES)) {
            this.selectedImages = intent.getParcelableArrayListExtra(INTENT_EXTRA_SELECTED_IMAGES);
        }
        if (this.selectedImages == null) {
            this.selectedImages = new ArrayList();
        }
        this.images = new ArrayList();
        if (this.actionBar != null) {
            this.actionBar.setTitle((CharSequence)(this.folderMode ? this.folderTitle : this.imageTitle));
        }
        this.imageAdapter = new ImagePickerAdapter((Context)this, this.images, this.selectedImages, this);
        this.folderAdapter = new FolderPickerAdapter((Context)this, new OnFolderClickListener(){

            @Override
            public void onFolderClick(Folder bucket) {
                ImagePickerActivity.this.foldersState = ImagePickerActivity.this.recyclerView.getLayoutManager().onSaveInstanceState();
                ImagePickerActivity.this.setImageAdapter(bucket.getImages());
            }
        });
        this.orientationBasedUI(this.getResources().getConfiguration().orientation);
    }

    protected void onResume() {
        super.onResume();
        this.getDataWithPermission();
    }

    private void setImageAdapter(ArrayList<Image> images) {
        this.imageAdapter.setData(images);
        this.setItemDecoration(this.imageColumns);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.imageAdapter);
        this.updateTitle();
    }

    private void setFolderAdapter() {
        this.folderAdapter.setData(this.folders);
        this.setItemDecoration(this.folderColumns);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.folderAdapter);
        if (this.foldersState != null) {
            this.layoutManager.setSpanCount(this.folderColumns);
            this.recyclerView.getLayoutManager().onRestoreInstanceState(this.foldersState);
        }
        this.updateTitle();
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        if (menu.findItem(101) == null) {
            this.menuCamera = menu.add(0, 101, 1, (CharSequence)this.getString(R.string.camera));
            this.menuCamera.setIcon(R.drawable.ic_camera_white);
            this.menuCamera.setShowAsAction(2);
            this.menuCamera.setVisible(this.showCamera);
        }
        if (menu.findItem(100) == null) {
            this.menuDone = menu.add(0, 100, 2, (CharSequence)this.getString(R.string.done));
            this.menuDone.setShowAsAction(2);
        }
        this.updateTitle();
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (id2 == 100) {
            if (this.selectedImages != null && this.selectedImages.size() > 0) {
                for (int i = 0; i < this.selectedImages.size(); ++i) {
                    Image image = this.selectedImages.get(i);
                    File file = new File(image.getPath());
                    if (file.exists()) continue;
                    this.selectedImages.remove(i);
                    --i;
                }
                Intent data = new Intent();
                data.putParcelableArrayListExtra(INTENT_EXTRA_SELECTED_IMAGES, this.selectedImages);
                this.setResult(-1, data);
                this.finish();
            }
            return true;
        }
        if (id2 == 101) {
            this.captureImageWithPermission();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.orientationBasedUI(newConfig.orientation);
    }

    private void orientationBasedUI(int orientation) {
        this.imageColumns = orientation == 1 ? 3 : 5;
        this.folderColumns = orientation == 1 ? 2 : 4;
        int columns = this.isDisplayingFolderView() ? this.folderColumns : this.imageColumns;
        this.layoutManager = new GridLayoutManager((Context)this, columns);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerView.setHasFixedSize(true);
        this.setItemDecoration(columns);
    }

    private void setItemDecoration(int columns) {
        this.layoutManager.setSpanCount(columns);
        if (this.itemOffsetDecoration != null) {
            this.recyclerView.removeItemDecoration((RecyclerView.ItemDecoration)this.itemOffsetDecoration);
        }
        this.itemOffsetDecoration = new GridSpacingItemDecoration(columns, this.getResources().getDimensionPixelSize(R.dimen.item_padding), false);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.itemOffsetDecoration);
    }

    private void getDataWithPermission() {
        int rc = ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        if (rc == 0) {
            this.getData();
        } else {
            this.requestWriteExternalPermission();
        }
    }

    private void getData() {
        this.abortLoading();
        ImageLoaderRunnable runnable = new ImageLoaderRunnable();
        this.thread = new Thread(runnable);
        this.thread.start();
    }

    private void requestWriteExternalPermission() {
        Log.w((String)TAG, (String)"Write External permission is not granted. Requesting permission");
        String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE")) {
            ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)23);
        } else if (!this.isPermissionRequested("writeExternalRequested")) {
            ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)23);
            this.setPermissionRequested("writeExternalRequested");
        } else {
            Snackbar snackbar = Snackbar.make((View)this.mainLayout, (int)R.string.msg_no_write_external_permission, (int)-2);
            snackbar.setAction(R.string.ok, new View.OnClickListener(){

                public void onClick(View view) {
                    ImagePickerActivity.this.openAppSettings();
                }
            });
            snackbar.show();
        }
    }

    private void requestCameraPermission() {
        Log.w((String)TAG, (String)"Write External permission is not granted. Requesting permission");
        String[] permissions = new String[]{"android.permission.CAMERA"};
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.CAMERA")) {
            ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)24);
        } else if (!this.isPermissionRequested("cameraRequested")) {
            ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)24);
            this.setPermissionRequested("cameraRequested");
        } else {
            Snackbar snackbar = Snackbar.make((View)this.mainLayout, (int)R.string.msg_no_camera_permission, (int)-2);
            snackbar.setAction(R.string.ok, new View.OnClickListener(){

                public void onClick(View view) {
                    ImagePickerActivity.this.openAppSettings();
                }
            });
            snackbar.show();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 23: {
                if (grantResults.length != 0 && grantResults[0] == 0) {
                    Log.d((String)TAG, (String)"Write External permission granted");
                    this.getData();
                    return;
                }
                Log.e((String)TAG, (String)("Permission not granted: results len = " + grantResults.length + " Result code = " + (grantResults.length > 0 ? Integer.valueOf(grantResults[0]) : "(empty)")));
                this.finish();
            }
            case 24: {
                if (grantResults.length != 0 && grantResults[0] == 0) {
                    Log.d((String)TAG, (String)"Camera permission granted");
                    this.captureImage();
                    return;
                }
                Log.e((String)TAG, (String)("Permission not granted: results len = " + grantResults.length + " Result code = " + (grantResults.length > 0 ? Integer.valueOf(grantResults[0]) : "(empty)")));
                break;
            }
            default: {
                Log.d((String)TAG, (String)("Got unexpected permission result: " + requestCode));
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }

    private void openAppSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)this.getPackageName(), null));
        intent.addFlags(0x10000000);
        this.startActivity(intent);
    }

    private void setPermissionRequested(String permission2) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(permission2, true);
        editor.apply();
    }

    private boolean isPermissionRequested(String permission2) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this);
        return preferences.getBoolean(permission2, false);
    }

    @Override
    public void onClick(View view, int position) {
        this.clickImage(position);
    }

    private void clickImage(int position) {
        int selectedItemPosition = this.selectedImagePosition(this.images.get(position));
        if (this.mode == 2) {
            if (selectedItemPosition == -1) {
                if (this.selectedImages.size() < this.limit) {
                    this.imageAdapter.addSelected(this.images.get(position));
                } else {
                    Toast.makeText((Context)this, (int)R.string.msg_limit_images, (int)0).show();
                }
            } else {
                this.imageAdapter.removeSelectedPosition(selectedItemPosition, position);
            }
        } else if (selectedItemPosition != -1) {
            this.imageAdapter.removeSelectedPosition(selectedItemPosition, position);
        } else {
            if (this.selectedImages.size() > 0) {
                this.imageAdapter.removeAllSelectedSingleClick();
            }
            this.imageAdapter.addSelected(this.images.get(position));
        }
        this.updateTitle();
    }

    private int selectedImagePosition(Image image) {
        for (int i = 0; i < this.selectedImages.size(); ++i) {
            if (!this.selectedImages.get(i).getPath().equals(image.getPath())) continue;
            return i;
        }
        return -1;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Uri imageUri;
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 2000 && resultCode == -1 && this.currentImagePath != null && (imageUri = Uri.parse((String)this.currentImagePath)) != null) {
            MediaScannerConnection.scanFile((Context)this, (String[])new String[]{imageUri.getPath()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                public void onScanCompleted(String path, Uri uri) {
                    Log.v((String)ImagePickerActivity.TAG, (String)("File " + path + " was scanned successfully: " + uri));
                    ImagePickerActivity.this.getDataWithPermission();
                }
            });
        }
    }

    private void captureImageWithPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            int rc = ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA");
            if (rc == 0) {
                this.captureImage();
            } else {
                Log.w((String)TAG, (String)"Camera permission is not granted. Requesting permission");
                this.requestCameraPermission();
            }
        } else {
            this.captureImage();
        }
    }

    private void captureImage() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (intent.resolveActivity(this.getPackageManager()) != null) {
            File imageFile = ImageUtils.createImageFile(this.imageDirectory);
            if (imageFile != null) {
                String authority = this.getPackageName() + ".fileprovider";
                Uri uri = FileProvider.getUriForFile((Context)this, (String)authority, (File)imageFile);
                this.currentImagePath = "file:" + imageFile.getAbsolutePath();
                intent.putExtra("output", (Parcelable)uri);
                this.startActivityForResult(intent, 2000);
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.error_create_image_file), (int)1).show();
            }
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.error_no_camera), (int)1).show();
        }
    }

    protected void onStart() {
        super.onStart();
        this.handler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 2001: {
                        ImagePickerActivity.this.showLoading();
                        break;
                    }
                    case 2002: {
                        ArrayList temps = new ArrayList();
                        temps.addAll(ImagePickerActivity.this.selectedImages);
                        ArrayList newImages = new ArrayList();
                        newImages.addAll(ImagePickerActivity.this.images);
                        if (ImagePickerActivity.this.folderMode) {
                            ImagePickerActivity.this.setFolderAdapter();
                            if (ImagePickerActivity.this.folders.size() != 0) {
                                ImagePickerActivity.this.hideLoading();
                                break;
                            }
                            ImagePickerActivity.this.showEmpty();
                            break;
                        }
                        ImagePickerActivity.this.setImageAdapter(newImages);
                        if (ImagePickerActivity.this.images.size() != 0) {
                            ImagePickerActivity.this.hideLoading();
                            break;
                        }
                        ImagePickerActivity.this.showEmpty();
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        };
        this.observer = new ContentObserver(this.handler){

            public void onChange(boolean selfChange) {
                ImagePickerActivity.this.getData();
            }
        };
        this.getContentResolver().registerContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, false, this.observer);
    }

    private void abortLoading() {
        if (this.thread == null) {
            return;
        }
        if (this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isDisplayingFolderView() {
        return this.folderMode && (this.recyclerView.getAdapter() == null || this.recyclerView.getAdapter() instanceof FolderPickerAdapter);
    }

    private void updateTitle() {
        if (this.menuDone != null && this.menuCamera != null) {
            if (this.isDisplayingFolderView()) {
                this.actionBar.setTitle((CharSequence)this.folderTitle);
                this.menuDone.setVisible(false);
            } else if (this.selectedImages.size() == 0) {
                this.actionBar.setTitle((CharSequence)this.imageTitle);
                if (this.menuDone != null) {
                    this.menuDone.setVisible(false);
                }
            } else {
                if (this.mode == 2) {
                    if (this.limit == 999) {
                        this.actionBar.setTitle((CharSequence)String.format(this.getString(R.string.selected), this.selectedImages.size()));
                    } else {
                        this.actionBar.setTitle((CharSequence)String.format(this.getString(R.string.selected_with_limit), this.selectedImages.size(), this.limit));
                    }
                }
                if (this.menuDone != null) {
                    this.menuDone.setVisible(true);
                }
            }
        }
    }

    private void showLoading() {
        this.progressBar.setVisibility(0);
        this.recyclerView.setVisibility(8);
        this.emptyTextView.setVisibility(8);
    }

    private void hideLoading() {
        this.progressBar.setVisibility(8);
        this.recyclerView.setVisibility(0);
        this.emptyTextView.setVisibility(8);
    }

    private void showEmpty() {
        this.progressBar.setVisibility(8);
        this.recyclerView.setVisibility(8);
        this.emptyTextView.setVisibility(0);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.abortLoading();
        this.getContentResolver().unregisterContentObserver(this.observer);
        this.observer = null;
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
    }

    public Folder getFolder(String name) {
        for (Folder folder : this.folders) {
            if (!folder.getFolderName().equals(name)) continue;
            return folder;
        }
        return null;
    }

    public void onBackPressed() {
        if (this.folderMode && !this.isDisplayingFolderView()) {
            this.setFolderAdapter();
            return;
        }
        this.setResult(0);
        super.onBackPressed();
    }

    private class ImageLoaderRunnable
    implements Runnable {
        private ImageLoaderRunnable() {
        }

        @Override
        public void run() {
            Message message;
            Process.setThreadPriority((int)10);
            if (ImagePickerActivity.this.recyclerView.getAdapter() == null) {
                message = ImagePickerActivity.this.handler.obtainMessage();
                message.what = 2001;
                message.sendToTarget();
            }
            if (Thread.interrupted()) {
                return;
            }
            Cursor cursor = ImagePickerActivity.this.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, ImagePickerActivity.this.projection, null, null, "date_added");
            if (cursor == null) {
                message = ImagePickerActivity.this.handler.obtainMessage();
                message.what = 2003;
                message.sendToTarget();
                return;
            }
            ArrayList<Image> temp = new ArrayList<Image>(cursor.getCount());
            ImagePickerActivity.this.folders = new ArrayList();
            if (cursor.moveToLast()) {
                do {
                    if (Thread.interrupted()) {
                        return;
                    }
                    long id2 = cursor.getLong(cursor.getColumnIndex(ImagePickerActivity.this.projection[0]));
                    String name = cursor.getString(cursor.getColumnIndex(ImagePickerActivity.this.projection[1]));
                    String path = cursor.getString(cursor.getColumnIndex(ImagePickerActivity.this.projection[2]));
                    String bucket = cursor.getString(cursor.getColumnIndex(ImagePickerActivity.this.projection[3]));
                    File file = new File(path);
                    if (!file.exists()) continue;
                    Image image = new Image(id2, name, path, false);
                    temp.add(image);
                    if (!ImagePickerActivity.this.folderMode) continue;
                    Folder folder = ImagePickerActivity.this.getFolder(bucket);
                    if (folder == null) {
                        folder = new Folder(bucket);
                        ImagePickerActivity.this.folders.add(folder);
                    }
                    folder.getImages().add(image);
                } while (cursor.moveToPrevious());
            }
            cursor.close();
            if (ImagePickerActivity.this.images == null) {
                ImagePickerActivity.this.images = new ArrayList();
            }
            ImagePickerActivity.this.images.clear();
            ImagePickerActivity.this.images.addAll(temp);
            if (ImagePickerActivity.this.handler != null) {
                message = ImagePickerActivity.this.handler.obtainMessage();
                message.what = 2002;
                message.sendToTarget();
            }
            Thread.interrupted();
        }
    }
}

