/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.activity.ImagePickerActivity;
import com.nguyenhoanglam.imagepicker.model.Image;
import java.util.ArrayList;

public abstract class ImagePicker {
    private int mode;
    private int limit;
    private boolean showCamera;
    private String folderTitle;
    private String imageTitle;
    private ArrayList<Image> selectedImages;
    private boolean folderMode;
    private String imageDirectory;

    public abstract void start(int var1);

    public void init(Activity activity) {
        this.mode = 2;
        this.limit = 999;
        this.showCamera = true;
        this.folderTitle = activity.getString(R.string.title_folder);
        this.imageTitle = activity.getString(R.string.title_select_image);
        this.selectedImages = new ArrayList();
        this.folderMode = false;
        this.imageDirectory = activity.getString(R.string.image_directory);
    }

    public static ImagePickerWithActivity create(Activity activity) {
        return new ImagePickerWithActivity(activity);
    }

    public static ImagePickerWithFragment create(Fragment fragment) {
        return new ImagePickerWithFragment(fragment);
    }

    public ImagePicker single() {
        this.mode = 1;
        return this;
    }

    public ImagePicker multi() {
        this.mode = 2;
        return this;
    }

    public ImagePicker limit(int count) {
        this.limit = count;
        return this;
    }

    public ImagePicker showCamera(boolean show) {
        this.showCamera = show;
        return this;
    }

    public ImagePicker folderTitle(String title) {
        this.folderTitle = title;
        return this;
    }

    public ImagePicker imageTitle(String title) {
        this.imageTitle = title;
        return this;
    }

    public ImagePicker origin(ArrayList<Image> images) {
        this.selectedImages = images;
        return this;
    }

    public ImagePicker folderMode(boolean folderMode) {
        this.folderMode = folderMode;
        return this;
    }

    public ImagePicker imageDirectory(String directory) {
        this.imageDirectory = directory;
        return this;
    }

    public Intent getIntent(Activity activity) {
        Intent intent = new Intent((Context)activity, ImagePickerActivity.class);
        intent.putExtra("mode", this.mode);
        intent.putExtra("limit", this.limit);
        intent.putExtra("showCamera", this.showCamera);
        intent.putExtra("folderTitle", this.folderTitle);
        intent.putExtra("imageTitle", this.imageTitle);
        intent.putExtra("selectedImages", this.selectedImages);
        intent.putExtra("folderMode", this.folderMode);
        intent.putExtra("imageDirectory", this.imageDirectory);
        return intent;
    }

    public static class ImagePickerWithFragment
    extends ImagePicker {
        private Fragment fragment;

        public ImagePickerWithFragment(Fragment fragment) {
            this.fragment = fragment;
            this.init((Activity)fragment.getActivity());
        }

        @Override
        public void start(int requestCode) {
            Intent intent = this.getIntent((Activity)this.fragment.getActivity());
            this.fragment.startActivityForResult(intent, requestCode);
        }
    }

    public static class ImagePickerWithActivity
    extends ImagePicker {
        private Activity activity;

        public ImagePickerWithActivity(Activity activity) {
            this.activity = activity;
            this.init(activity);
        }

        @Override
        public void start(int requestCode) {
            Intent intent = this.getIntent(this.activity);
            this.activity.startActivityForResult(intent, requestCode);
        }
    }
}

