/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk.internal;

import android.content.Context;
import android.webkit.JavascriptInterface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.herewhite.sdk.JsBridgeInterface;
import com.herewhite.sdk.domain.WhiteObject;
import com.herewhite.sdk.internal.Logger;
import io.agora.fpa.proxy.FailedReason;
import io.agora.fpa.proxy.FpaHttpProxyChainConfig;
import io.agora.fpa.proxy.FpaProxyConnectionInfo;
import io.agora.fpa.proxy.FpaProxyService;
import io.agora.fpa.proxy.FpaProxyServiceConfig;
import io.agora.fpa.proxy.IFpaServiceListener;
import io.agora.fpa.proxy.LogLevel;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.json.JSONException;
import org.json.JSONObject;

public class WsJsInterfaceImpl {
    private static final String KEY_TYPE_BYTE_BUTTER = "arraybuffer";
    private static final String KEY_TYPE_STRING = "string";
    private static OkHttpClient client;
    private final JsBridgeInterface bridge;
    private final Context context;
    private WebSocket webSocket;

    public WsJsInterfaceImpl(JsBridgeInterface bridge, Context context) {
        this.bridge = bridge;
        this.context = context;
    }

    @JavascriptInterface
    public void setup(Object args) {
        Logger.info("ws interface setup " + args.toString());
        this.ensureSetupFpa();
        if (args instanceof JSONObject) {
            try {
                JSONObject jsonObject = (JSONObject)args;
                String url = jsonObject.getString("url");
                int key = jsonObject.getInt("key");
                this.webSocket = new WebSocketWrapper(url, key);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            Logger.error("ws send args error !!!", null);
        }
    }

    private void ensureSetupFpa() {
        if (client == null) {
            try {
                this.setupFpaService();
                this.setupChainConfig();
            }
            catch (Exception e) {
                Logger.error("ws create fpa service error ", e);
            }
            client = new OkHttpClient.Builder().readTimeout(300L, TimeUnit.SECONDS).writeTimeout(300L, TimeUnit.SECONDS).proxy(this.createProxy()).build();
        }
    }

    private void setupFpaService() throws Exception {
        File logFile = new File(this.context.getCacheDir().getAbsoluteFile() + "/whiteboard/fpa_log_sdk.log");
        FpaProxyService.getInstance().setListener(new IFpaServiceListener(){

            public void onConnected(@Nullable FpaProxyConnectionInfo info) {
                Logger.info("[Fpa] onConnected. info=" + info);
            }

            public void onAccelerationSuccess(@Nullable FpaProxyConnectionInfo info) {
                Logger.info("[Fpa] onAccelerationSuccess. info=" + info);
            }

            public void onConnectionFailed(@Nullable FpaProxyConnectionInfo info, FailedReason reason) {
                Logger.info("[Fpa] onConnectionFailed. info=" + info + " reason=" + reason);
            }

            public void onDisconnectedAndFallback(@Nullable FpaProxyConnectionInfo info, FailedReason reason) {
                Logger.info("[Fpa] onDisconnectedAndFallback. info=" + info + " reason=" + reason);
            }
        });
        FpaProxyServiceConfig config = new FpaProxyServiceConfig.Builder(logFile.getAbsolutePath()).setAppId("81ae40d666ed4fdc9b883962e9873a0b").setLogFileSizeKb(1024).setLogLevel(LogLevel.LOG_ERROR).build();
        FpaProxyService.getInstance().start(config);
    }

    private void setupChainConfig() {
        FpaHttpProxyChainConfig chainConfig = new FpaHttpProxyChainConfig.Builder().addChainInfo(285, "gateway.netless.link", 443, true).fallbackWhenNoChainAvailable(true).build();
        FpaProxyService.getInstance().setOrUpdateHttpProxyChainConfig(chainConfig);
    }

    private Proxy createProxy() {
        int port = FpaProxyService.getInstance().getHttpProxyPort();
        return port > 0 ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress("127.0.0.1", port)) : null;
    }

    @JavascriptInterface
    public void send(Object args) {
        block7: {
            if (args instanceof JSONObject) {
                try {
                    JSONObject jsonObject = (JSONObject)args;
                    String type = jsonObject.getString("type");
                    String data = jsonObject.getString("data");
                    if (KEY_TYPE_BYTE_BUTTER.equals(type)) {
                        ByteString bs = ByteString.decodeBase64((String)data);
                        if (bs != null) {
                            this.webSocket.send(bs);
                        }
                        break block7;
                    }
                    if (KEY_TYPE_STRING.equals(type)) {
                        this.webSocket.send(data);
                        break block7;
                    }
                    Logger.error("ws send not support type " + args, null);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                Logger.error("ws send args error !!!", null);
            }
        }
    }

    @JavascriptInterface
    public void close(Object args) {
        Logger.info("ws interface close " + args.toString());
        if (args instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)args;
            try {
                int code = jsonObject.getInt("code");
                String reason = jsonObject.optString("reason", "");
                this.webSocket.close(code, reason);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            Logger.error("ws close args error !!!", null);
        }
    }

    private class WebSocketWrapper
    implements WebSocket {
        private final int key;
        private final WebSocket realWebSocket;

        WebSocketWrapper(String url, int key) {
            Request request = new Request.Builder().url(url).build();
            this.realWebSocket = client.newWebSocket(request, new WebSocketListener(){

                public void onOpen(@NonNull WebSocket webSocket, @NonNull Response response) {
                    WebSocketWrapper.this.notifyJsOpen();
                }

                public void onMessage(@NonNull WebSocket webSocket, @NonNull String text) {
                    WebSocketWrapper.this.notifyJsMessage(text, true);
                }

                public void onMessage(@NonNull WebSocket webSocket, @NonNull ByteString bytes) {
                    WebSocketWrapper.this.notifyJsMessage(bytes.base64(), false);
                }

                public void onClosing(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
                }

                public void onClosed(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
                    WebSocketWrapper.this.notifyJsClosed(code, reason);
                }

                public void onFailure(@NonNull WebSocket webSocket, @NonNull Throwable t, Response response) {
                    WebSocketWrapper.this.notifyJsClosed(1006, "ws native onFailure called");
                }
            });
            this.key = key;
        }

        @NonNull
        public Request request() {
            return this.realWebSocket.request();
        }

        public long queueSize() {
            return this.realWebSocket.queueSize();
        }

        public boolean send(@NonNull String text) {
            return this.realWebSocket.send(text);
        }

        public boolean send(@NonNull ByteString byteString) {
            return this.realWebSocket.send(byteString);
        }

        public boolean close(int code, String reason) {
            return this.realWebSocket.close(code, reason);
        }

        public void cancel() {
            this.realWebSocket.cancel();
        }

        private void notifyJsOpen() {
            WsJsInterfaceImpl.this.bridge.callHandler("ws.onOpen", new Object[]{new BaseMessage(this.key)});
        }

        private void notifyJsClosed(int code, String reason) {
            WsJsInterfaceImpl.this.bridge.callHandler("ws.onClose", new Object[]{new WsClose(code, reason, this.key)});
        }

        private void notifyJsMessage(String data, boolean isText) {
            String type = isText ? WsJsInterfaceImpl.KEY_TYPE_STRING : WsJsInterfaceImpl.KEY_TYPE_BYTE_BUTTER;
            WsJsInterfaceImpl.this.bridge.callHandler("ws.onMessage", new Object[]{new WsMessage(type, data, this.key)});
        }

        private void notifyJsError(String message) {
            WsJsInterfaceImpl.this.bridge.callHandler("ws.onError", new Object[]{new WsError(message, this.key)});
        }

        class WsMessage
        extends BaseMessage {
            private final String type;
            private final String data;

            WsMessage(String type, String data, int key) {
                super(key);
                this.type = type;
                this.data = data;
            }
        }

        class WsError
        extends BaseMessage {
            private final String message;

            WsError(String message, int key) {
                super(key);
                this.message = message;
            }
        }

        class WsClose
        extends BaseMessage {
            private final int code;
            private final String reason;

            WsClose(int code, String reason, int key) {
                super(key);
                this.code = code;
                this.reason = reason;
            }
        }

        class BaseMessage
        extends WhiteObject {
            private final int key;

            BaseMessage(int key) {
                this.key = key;
            }
        }
    }
}

