/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk.internal;

import android.webkit.JavascriptInterface;
import com.herewhite.sdk.AudioEffectBridge;
import com.herewhite.sdk.AudioMixerBridge;
import org.json.JSONException;
import org.json.JSONObject;
import wendu.dsbridge.special.CompletionHandler;

public class RtcJsInterfaceImpl {
    private AudioMixerBridge mixerBridge;
    private AudioEffectBridge audioEffectBridge;

    public RtcJsInterfaceImpl(AudioMixerBridge mixerBridge, AudioEffectBridge audioEffectBridge) {
        this.mixerBridge = mixerBridge;
        this.audioEffectBridge = audioEffectBridge;
    }

    @JavascriptInterface
    public void startAudioMixing(Object args) {
        if (this.mixerBridge != null && args instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)args;
            try {
                String filePath = jsonObject.getString("filePath");
                boolean loopback = jsonObject.getBoolean("loopback");
                boolean replace = jsonObject.getBoolean("replace");
                int cycle = jsonObject.getInt("cycle");
                this.mixerBridge.startAudioMixing(filePath, loopback, replace, cycle);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @JavascriptInterface
    public void stopAudioMixing(Object args) {
        if (this.mixerBridge != null) {
            this.mixerBridge.stopAudioMixing();
        }
    }

    @JavascriptInterface
    public void pauseAudioMixing(Object args) {
        if (this.mixerBridge != null) {
            this.mixerBridge.pauseAudioMixing();
        }
    }

    @JavascriptInterface
    public void resumeAudioMixing(Object args) {
        if (this.mixerBridge != null) {
            this.mixerBridge.resumeAudioMixing();
        }
    }

    @JavascriptInterface
    public void setAudioMixingPosition(Object args) {
        if (this.mixerBridge != null) {
            int pos = (Integer)args;
            this.mixerBridge.setAudioMixingPosition(pos);
        }
    }

    @JavascriptInterface
    public void getEffectsVolume(Object args, CompletionHandler<Double> handler) {
        if (this.audioEffectBridge != null) {
            handler.complete((Object)this.audioEffectBridge.getEffectsVolume());
        }
    }

    @JavascriptInterface
    public void setEffectsVolume(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null) {
            int code = this.audioEffectBridge.setEffectsVolume(Double.parseDouble(args.toString()));
            handler.complete((Object)code);
        }
    }

    @JavascriptInterface
    public void setVolumeOfEffect(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null && args instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)args;
            try {
                int soundId = jsonObject.getInt("soundId");
                double volume = jsonObject.getDouble("volume");
                int code = this.audioEffectBridge.setVolumeOfEffect(soundId, volume);
                handler.complete((Object)code);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @JavascriptInterface
    public void playEffect(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null && args instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)args;
            try {
                int soundId = jsonObject.getInt("soundId");
                String filePath = jsonObject.getString("filePath");
                int loopCount = jsonObject.optInt("loopCount", 0);
                double pitch = jsonObject.optDouble("pitch", 1.0);
                double pan = jsonObject.optDouble("pan", 0.0);
                double gain = jsonObject.optDouble("gain", 100.0);
                boolean publish = jsonObject.optBoolean("publish", false);
                int startPos = jsonObject.optInt("startPos", 0);
                int code = this.audioEffectBridge.playEffect(soundId, filePath, loopCount, pitch, pan, gain, publish, startPos);
                handler.complete((Object)code);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @JavascriptInterface
    public void stopEffect(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null) {
            int code = this.audioEffectBridge.stopEffect(Integer.parseInt(args.toString()));
            handler.complete((Object)code);
        }
    }

    @JavascriptInterface
    public void stopAllEffects(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null) {
            int code = this.audioEffectBridge.stopAllEffects();
            handler.complete((Object)code);
        }
    }

    @JavascriptInterface
    public void preloadEffect(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null && args instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)args;
            try {
                int soundId = jsonObject.getInt("soundId");
                String filePath = jsonObject.getString("filePath");
                int startPos = jsonObject.optInt("startPos", 0);
                int code = this.audioEffectBridge.preloadEffect(soundId, filePath, startPos);
                handler.complete((Object)code);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @JavascriptInterface
    public void unloadEffect(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null) {
            int code = this.audioEffectBridge.unloadEffect(Integer.parseInt(args.toString()));
            handler.complete((Object)code);
        }
    }

    @JavascriptInterface
    public void pauseEffect(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null) {
            int code = this.audioEffectBridge.pauseEffect(Integer.parseInt(args.toString()));
            handler.complete((Object)code);
        }
    }

    @JavascriptInterface
    public void pauseAllEffects(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null) {
            int code = this.audioEffectBridge.pauseAllEffects();
            handler.complete((Object)code);
        }
    }

    @JavascriptInterface
    public void resumeEffect(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null) {
            int code = this.audioEffectBridge.resumeEffect(Integer.parseInt(args.toString()));
            handler.complete((Object)code);
        }
    }

    @JavascriptInterface
    public void resumeAllEffects(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null) {
            int code = this.audioEffectBridge.resumeAllEffects();
            handler.complete((Object)code);
        }
    }

    @JavascriptInterface
    public void getEffectDuration(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null) {
            int code = this.audioEffectBridge.getEffectDuration(args.toString());
            handler.complete((Object)code);
        }
    }

    @JavascriptInterface
    public void getEffectCurrentPosition(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null) {
            int code = this.audioEffectBridge.getEffectCurrentPosition(Integer.parseInt(args.toString()));
            handler.complete((Object)code);
        }
    }

    @JavascriptInterface
    public void setEffectPosition(Object args, CompletionHandler<Integer> handler) {
        if (this.audioEffectBridge != null && args instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)args;
            try {
                int soundId = jsonObject.getInt("soundId");
                int pos = jsonObject.getInt("pos");
                int code = this.audioEffectBridge.setEffectPosition(soundId, pos);
                handler.complete((Object)code);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

