/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk.domain;

import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.json.JSONException;
import org.json.JSONObject;

public class SDKError
extends Exception {
    static Gson gson = new Gson();
    private final String jsStack;

    public SDKError(String message) {
        super(message);
        this.jsStack = "Native Error";
    }

    public SDKError(String message, String jsStack) {
        super(message);
        this.jsStack = jsStack;
    }

    @Nullable
    public static SDKError parseError(JSONObject object) {
        try {
            String msg = object.getString("message");
            String jsStack = object.getString("jsStack");
            return new SDKError(msg, jsStack);
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Nullable
    public static SDKError promiseError(String str) {
        JsonObject jsonObject = (JsonObject)gson.fromJson(str, JsonObject.class);
        return SDKError.promiseError(jsonObject);
    }

    @Nullable
    public static SDKError promiseError(JsonObject jsonObject) {
        if (jsonObject.has("__error")) {
            String msg = "Unknow exception";
            String jsStack = "Unknow stack";
            if (jsonObject.getAsJsonObject("__error").has("message")) {
                msg = jsonObject.getAsJsonObject("__error").get("message").getAsString();
            }
            if (jsonObject.getAsJsonObject("__error").has("jsStack")) {
                jsStack = jsonObject.getAsJsonObject("__error").get("jsStack").getAsString();
            }
            return new SDKError(msg, jsStack);
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " jsStack: " + this.getJsStack();
    }

    public String getJsStack() {
        return this.jsStack;
    }
}

