/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.os.Build;
import com.herewhite.sdk.WhiteSdk;
import com.herewhite.sdk.domain.DeviceType;
import com.herewhite.sdk.domain.LoggerOptions;
import com.herewhite.sdk.domain.Region;
import com.herewhite.sdk.domain.SlideInvisibleBehavior;
import com.herewhite.sdk.domain.WhiteObject;
import java.util.HashMap;
import java.util.List;

public class WhiteSdkConfiguration
extends WhiteObject {
    private Region region;
    private DeviceType deviceType = DeviceType.touch;
    private boolean log = false;
    private RenderEngineType renderEngine = RenderEngineType.canvas;
    private boolean enableInterrupterAPI = false;
    private boolean enableSlideInterrupterAPI = false;
    private boolean preloadDynamicPPT = false;
    private boolean routeBackup = false;
    private boolean userCursor = false;
    private boolean onlyCallbackRemoteStateModify = false;
    private boolean disableDeviceInputs = false;
    private boolean enableIFramePlugin = false;
    private boolean enableRtcIntercept = false;
    private boolean enableRtcAudioEffectIntercept = false;
    private boolean enableSyncedStore = false;
    private boolean disableNewPencilStroke = false;
    private LoggerOptions loggerOptions;
    private String appIdentifier;
    private HashMap<String, String> __nativeTags = new HashMap();
    private List<String> __netlessUA;
    private PptParams pptParams = new PptParams();
    private SlideAppOptions slideAppOptions = new SlideAppOptions();
    private HashMap<String, String> fonts;
    private boolean enableImgErrorCallback;
    private Boolean useMultiViews = false;
    private List<String> apiHosts;

    public WhiteSdkConfiguration(String appIdentifier, boolean log) {
        this(appIdentifier);
        this.log = log;
    }

    public WhiteSdkConfiguration(String appIdentifier) {
        this.appIdentifier = appIdentifier;
        if (Build.VERSION.SDK_INT >= 24 && Build.VERSION.SDK_INT < 28) {
            this.renderEngine = RenderEngineType.svg;
        }
        this.setupNativeTags();
    }

    public boolean isEnableIFramePlugin() {
        return this.enableIFramePlugin;
    }

    public void setEnableIFramePlugin(boolean enableIFramePlugin) {
        this.enableIFramePlugin = enableIFramePlugin;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    boolean isEnableRtcIntercept() {
        return this.enableRtcIntercept;
    }

    void setEnableRtcIntercept(boolean enableRtcIntercept) {
        this.enableRtcIntercept = enableRtcIntercept;
    }

    public boolean isEnableRtcAudioEffectIntercept() {
        return this.enableRtcAudioEffectIntercept;
    }

    public void setEnableRtcAudioEffectIntercept(boolean enableRtcAudioEffectIntercept) {
        this.enableRtcAudioEffectIntercept = enableRtcAudioEffectIntercept;
    }

    public boolean isDisableDeviceInputs() {
        return this.disableDeviceInputs;
    }

    public void setDisableDeviceInputs(boolean disableDeviceInputs) {
        this.disableDeviceInputs = disableDeviceInputs;
    }

    public boolean isDisableNewPencilStroke() {
        return this.disableNewPencilStroke;
    }

    public void setDisableNewPencilStroke(boolean disableNewPencilStroke) {
        this.disableNewPencilStroke = disableNewPencilStroke;
    }

    public RenderEngineType getRenderEngine() {
        return this.renderEngine;
    }

    public void setRenderEngine(RenderEngineType renderEngine) {
        this.renderEngine = renderEngine;
    }

    public PptParams getPptParams() {
        return this.pptParams;
    }

    public void setPptParams(PptParams pptParams) {
        this.pptParams = pptParams;
    }

    public HashMap<String, String> getFonts() {
        return this.fonts;
    }

    public void setFonts(HashMap<String, String> fonts) {
        this.fonts = fonts;
    }

    public boolean isPreloadDynamicPPT() {
        return this.preloadDynamicPPT;
    }

    public void setPreloadDynamicPPT(boolean preloadDynamicPPT) {
        this.preloadDynamicPPT = preloadDynamicPPT;
    }

    private void setupNativeTags() {
        this.__nativeTags.put("nativeVersion", WhiteSdk.Version());
        this.__nativeTags.put("platform", "android API " + Build.VERSION.SDK_INT);
    }

    public void addNativeTag(String tag, String value) {
        this.__nativeTags.put(tag, value);
    }

    public LoggerOptions getLoggerOptions() {
        return this.loggerOptions;
    }

    public void setLoggerOptions(LoggerOptions loggerOptions) {
        this.loggerOptions = loggerOptions;
    }

    public List<String> getNetlessUA() {
        return this.__netlessUA;
    }

    public void setNetlessUA(List<String> netlessUA) {
        this.__netlessUA = netlessUA;
    }

    public boolean isRouteBackup() {
        return this.routeBackup;
    }

    public void setRouteBackup(boolean routeBackup) {
        this.routeBackup = routeBackup;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public boolean isUserCursor() {
        return this.userCursor;
    }

    public void setUserCursor(boolean userCursor) {
        this.userCursor = userCursor;
    }

    public boolean isOnlyCallbackRemoteStateModify() {
        return this.onlyCallbackRemoteStateModify;
    }

    public void setOnlyCallbackRemoteStateModify(boolean onlyCallbackRemoteStateModify) {
        this.onlyCallbackRemoteStateModify = onlyCallbackRemoteStateModify;
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public boolean isEnableInterrupterAPI() {
        return this.enableInterrupterAPI;
    }

    public void setEnableInterrupterAPI(boolean enableInterrupterAPI) {
        this.enableInterrupterAPI = enableInterrupterAPI;
    }

    public boolean isEnableImgErrorCallback() {
        return this.enableImgErrorCallback;
    }

    public void setEnableImgErrorCallback(boolean enableImgErrorCallback) {
        this.enableImgErrorCallback = enableImgErrorCallback;
    }

    public boolean isEnableSyncedStore() {
        return this.enableSyncedStore;
    }

    public void setEnableSyncedStore(boolean enableSyncedStore) {
        this.enableSyncedStore = enableSyncedStore;
    }

    public Boolean getUseMultiViews() {
        return this.useMultiViews;
    }

    public void setUseMultiViews(Boolean useMultiViews) {
        this.useMultiViews = useMultiViews;
    }

    public SlideAppOptions getSlideAppOptions() {
        return this.slideAppOptions;
    }

    public void setSlideAppOptions(SlideAppOptions slideAppOptions) {
        this.slideAppOptions = slideAppOptions;
    }

    public boolean isEnableSlideInterrupterAPI() {
        return this.enableSlideInterrupterAPI;
    }

    public void setEnableSlideInterrupterAPI(boolean enableSlideInterrupterAPI) {
        this.enableSlideInterrupterAPI = enableSlideInterrupterAPI;
    }

    public List<String> getApiHosts() {
        return this.apiHosts;
    }

    public void setApiHosts(List<String> apiHosts) {
        this.apiHosts = apiHosts;
    }

    public static class SlideAppOptions
    extends WhiteObject {
        private boolean showRenderError = false;
        private boolean debug = false;
        private boolean enableGlobalClick = true;
        private Integer minFPS = 25;
        private Integer maxFPS = 40;
        private Double resolution;
        private Integer maxResolutionLevel;
        private String bgColor;
        private Boolean forceCanvas = false;
        private SlideInvisibleBehavior invisibleBehavior = SlideInvisibleBehavior.Frozen;

        public boolean isShowRenderError() {
            return this.showRenderError;
        }

        public void setShowRenderError(boolean showRenderError) {
            this.showRenderError = showRenderError;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public boolean isEnableGlobalClick() {
            return this.enableGlobalClick;
        }

        public void setEnableGlobalClick(boolean enableGlobalClick) {
            this.enableGlobalClick = enableGlobalClick;
        }

        public Integer getMinFPS() {
            return this.minFPS;
        }

        public void setMinFPS(Integer minFPS) {
            this.minFPS = minFPS;
        }

        public Integer getMaxFPS() {
            return this.maxFPS;
        }

        public void setMaxFPS(Integer maxFPS) {
            this.maxFPS = maxFPS;
        }

        public Double getResolution() {
            return this.resolution;
        }

        public void setResolution(Double resolution) {
            this.resolution = resolution;
        }

        public Integer getMaxResolutionLevel() {
            return this.maxResolutionLevel;
        }

        public void setMaxResolutionLevel(Integer maxResolutionLevel) {
            this.maxResolutionLevel = maxResolutionLevel;
        }

        public String getBgColor() {
            return this.bgColor;
        }

        public void setBgColor(String bgColor) {
            this.bgColor = bgColor;
        }

        public Boolean getForceCanvas() {
            return this.forceCanvas;
        }

        public void setForceCanvas(Boolean forceCanvas) {
            this.forceCanvas = forceCanvas;
        }

        public SlideInvisibleBehavior getInvisibleBehavior() {
            return this.invisibleBehavior;
        }

        public void setInvisibleBehavior(SlideInvisibleBehavior invisibleBehavior) {
            this.invisibleBehavior = invisibleBehavior;
        }
    }

    public static class PptParams
    extends WhiteObject {
        private String scheme;
        private boolean useServerWrap = true;

        public PptParams(String scheme) {
            this.scheme = scheme;
        }

        public PptParams() {
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public boolean isUseServerWrap() {
            return this.useServerWrap;
        }

        public void setUseServerWrap(boolean useServerWrap) {
            this.useServerWrap = useServerWrap;
        }
    }

    public static enum RenderEngineType {
        svg,
        canvas;

    }
}

