/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk.converter;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.herewhite.sdk.converter.ConvertType;
import com.herewhite.sdk.domain.ConvertErrorCode;
import com.herewhite.sdk.domain.ConvertException;
import com.herewhite.sdk.domain.ConverterStatus;
import com.herewhite.sdk.domain.Region;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ProjectorQuery {
    private static final String QUERY_URL_FORMAT = "https://api.netless.link/v5/projector/tasks/%s";
    static ThreadPoolExecutor executorService = new ThreadPoolExecutor(4, 4, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ProjectorThreadFactory());
    private final Region region;
    private final String taskUuid;
    private final String taskToken;
    private final long interval;
    private final long timeout;
    private final Callback outCallback;
    private final Gson gson = new Gson();
    private final OkHttpClient client = new OkHttpClient();
    private ConverterStatus status;
    private long startTime;

    public ProjectorQuery(Region region, String taskUuid, String taskToken, long interval, long timeout, Callback callback) {
        this.region = region;
        this.taskUuid = taskUuid;
        this.taskToken = taskToken;
        this.interval = interval;
        this.timeout = timeout;
        this.outCallback = callback;
    }

    public void startQuery() {
        if (this.startTime != 0L && this.isNotFinish()) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        executorService.execute(this::startProgressLoop);
    }

    private boolean isNotFinish() {
        return this.status != ConverterStatus.Success && this.status != ConverterStatus.Fail;
    }

    private void startProgressLoop() {
        long timeLimit = this.startTime + this.timeout;
        try {
            this.status = ConverterStatus.Checking;
            while (System.currentTimeMillis() < timeLimit) {
                this.checkProgress();
                if (this.status != ConverterStatus.Checking) {
                    return;
                }
                Thread.sleep(this.interval);
            }
            this.onFailure(new ConvertException(ConvertErrorCode.CheckTimeout));
            this.status = ConverterStatus.Timeout;
        }
        catch (ConvertException e) {
            this.onFailure(e);
            this.status = ConverterStatus.Fail;
        }
        catch (InterruptedException ignored) {
            this.onFailure(new ConvertException(ConvertErrorCode.ConvertFail));
            this.status = ConverterStatus.Fail;
        }
    }

    private void checkProgress() throws ConvertException {
        block7: {
            Request request = new Request.Builder().url(String.format(QUERY_URL_FORMAT, this.taskUuid)).header("token", this.taskToken).header("region", this.convertRegion(this.region)).header("Content-Type", "application/json").header("Accept", "application/json").build();
            Call call = this.client.newCall(request);
            try {
                Response response = call.execute();
                String body = response.body().string();
                System.out.println("response is " + body);
                if (response.code() == 200) {
                    QueryResponse queryResponse = (QueryResponse)this.gson.fromJson(body, QueryResponse.class);
                    ConversionStatus status = queryResponse.status;
                    if (status == ConversionStatus.Fail) {
                        this.onFailure(new ConvertException(ConvertErrorCode.ConvertFail, queryResponse.errorMessage));
                        this.status = ConverterStatus.Fail;
                    } else if (status == ConversionStatus.Finished) {
                        this.onFinish(queryResponse);
                        this.status = ConverterStatus.Success;
                    } else {
                        this.onProgress(queryResponse.convertedPercentage, queryResponse);
                    }
                    break block7;
                }
                throw new ConvertException(ConvertErrorCode.ConvertFail, body);
            }
            catch (IOException e) {
                throw new ConvertException(ConvertErrorCode.CheckFail, e);
            }
        }
    }

    private String convertType(ConvertType type) {
        if (type == ConvertType.Dynamic) {
            return "dynamic";
        }
        return "static";
    }

    private String convertRegion(Region region) {
        JsonElement regionElement = this.gson.toJsonTree((Object)region);
        return regionElement.getAsString();
    }

    private void onFinish(QueryResponse response) {
        if (this.outCallback != null) {
            this.outCallback.onFinish(response);
        }
    }

    private void onFailure(ConvertException e) {
        if (this.outCallback != null) {
            this.outCallback.onFailure(e);
        }
    }

    private void onProgress(double convertedPercentage, QueryResponse response) {
        if (this.outCallback != null) {
            this.outCallback.onProgress(convertedPercentage, response);
        }
    }

    static {
        executorService.allowCoreThreadTimeOut(true);
    }

    public static class QueryResponse {
        private String uuid;
        private ConversionStatus status;
        private String errorCode;
        private String errorMessage;
        private double convertedPercentage;
        private String prefix;

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public ConversionStatus getStatus() {
            return this.status;
        }

        public void setStatus(ConversionStatus status) {
            this.status = status;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public double getConvertedPercentage() {
            return this.convertedPercentage;
        }

        public void setConvertedPercentage(int convertedPercentage) {
            this.convertedPercentage = convertedPercentage;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }

    public static class Builder {
        private Region region;
        private String taskUuid;
        private String taskToken;
        private long interval;
        private long timeout;
        private Callback callback;

        public Builder setRegion(Region region) {
            this.region = region;
            return this;
        }

        public Builder setTaskUuid(String taskUuid) {
            this.taskUuid = taskUuid;
            return this;
        }

        public Builder setTaskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public Builder setPoolInterval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder setTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setCallback(Callback callback) {
            this.callback = callback;
            return this;
        }

        public ProjectorQuery build() {
            if (this.taskUuid == null || this.taskToken == null) {
                throw new RuntimeException("taskUuid and taskToken should not be null");
            }
            if (this.region == null) {
                this.region = Region.cn;
            }
            if (this.timeout == 0L) {
                this.timeout = 30000L;
            }
            if (this.interval == 0L) {
                this.interval = 2000L;
            }
            return new ProjectorQuery(this.region, this.taskUuid, this.taskToken, this.interval, this.timeout, this.callback);
        }
    }

    private static final class ProjectorThreadFactory
    implements ThreadFactory {
        private ProjectorThreadFactory() {
        }

        @Override
        public synchronized Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable, "white-sdk-converter");
            result.setPriority(1);
            return result;
        }
    }

    public static interface Callback {
        public void onProgress(double var1, QueryResponse var3);

        public void onFinish(QueryResponse var1);

        public void onFailure(ConvertException var1);
    }

    public static enum ConversionStatus {
        Waiting,
        Converting,
        Finished,
        Fail,
        Abort;

    }
}

