/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk.internal;

import android.webkit.JavascriptInterface;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.herewhite.sdk.CommonCallback;
import com.herewhite.sdk.domain.SDKError;
import com.herewhite.sdk.domain.UrlInterrupter;
import com.herewhite.sdk.internal.Logger;
import com.herewhite.sdk.internal.PostMessageCallback;
import org.json.JSONObject;

public class SdkJsInterfaceImpl {
    private static final Gson gson = new Gson();
    @Nullable
    private CommonCallback commonCallback;
    @Nullable
    private UrlInterrupter urlInterrupter;
    @Nullable
    private PostMessageCallback postMessageCallback;

    public SdkJsInterfaceImpl(CommonCallback commonCallback) {
        this.commonCallback = commonCallback;
    }

    public void setCommonCallbacks(@Nullable CommonCallback commonCallbacks) {
        this.commonCallback = commonCallbacks;
    }

    public void setPostMessageCallback(PostMessageCallback postMessageCallback) {
        this.postMessageCallback = postMessageCallback;
    }

    @Nullable
    public UrlInterrupter getUrlInterrupter() {
        return this.urlInterrupter;
    }

    public void setUrlInterrupter(@Nullable UrlInterrupter urlInterrupter) {
        this.urlInterrupter = urlInterrupter;
    }

    @JavascriptInterface
    public String urlInterrupter(Object args) {
        if (this.commonCallback != null) {
            return this.commonCallback.urlInterrupter(String.valueOf(args));
        }
        if (this.urlInterrupter == null) {
            return String.valueOf(args);
        }
        return this.urlInterrupter.urlInterrupter(String.valueOf(args));
    }

    @JavascriptInterface
    public void throwError(Object args) {
        Logger.info("WhiteSDK throwError: " + args);
        if (this.commonCallback != null) {
            this.commonCallback.throwError(args);
        }
    }

    @JavascriptInterface
    public void logger(Object args) {
        Logger.info("WhiteSDK logger: " + args);
        JSONObject jsonObject = this.convertToJsonOrNull(args);
        if (this.commonCallback != null && jsonObject != null) {
            this.commonCallback.onLogger(jsonObject);
        }
    }

    @JavascriptInterface
    public void postMessage(Object args) {
        Logger.info("WhiteSDK postMessage: " + args);
        JSONObject jsonObject = this.convertToJsonOrNull(args);
        if (this.commonCallback != null && jsonObject != null) {
            this.commonCallback.onMessage(jsonObject);
        }
        if (this.postMessageCallback != null && jsonObject != null) {
            this.postMessageCallback.onMessage(jsonObject);
        }
    }

    @JavascriptInterface
    public void onPPTMediaPlay(Object args) {
        if (this.commonCallback != null) {
            this.commonCallback.onPPTMediaPlay();
        }
    }

    @JavascriptInterface
    public void onPPTMediaPause(Object args) {
        if (this.commonCallback != null) {
            this.commonCallback.onPPTMediaPause();
        }
    }

    @JavascriptInterface
    public void setupFail(Object args) {
        JSONObject jsonObject = this.convertToJsonOrNull(args);
        if (this.commonCallback != null && jsonObject != null) {
            SDKError sdkError = SDKError.parseError(jsonObject);
            this.commonCallback.sdkSetupFail(sdkError);
        }
    }

    private JSONObject convertToJsonOrNull(Object args) {
        JSONObject result = null;
        try {
            result = new JSONObject(String.valueOf(args));
        }
        catch (Exception e) {
            Logger.error("convertToJson exception", e);
        }
        return result;
    }
}

