/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import com.google.gson.JsonSyntaxException;
import com.herewhite.sdk.Displayer;
import com.herewhite.sdk.Logger;
import com.herewhite.sdk.SyncDisplayerState;
import com.herewhite.sdk.WhiteSdk;
import com.herewhite.sdk.WhiteboardView;
import com.herewhite.sdk.domain.EventEntry;
import com.herewhite.sdk.domain.EventListener;
import com.herewhite.sdk.domain.FrequencyEventListener;
import com.herewhite.sdk.domain.PlayerObserverMode;
import com.herewhite.sdk.domain.PlayerPhase;
import com.herewhite.sdk.domain.PlayerState;
import com.herewhite.sdk.domain.PlayerTimeInfo;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.SDKError;
import java.util.concurrent.ConcurrentHashMap;
import wendu.dsbridge.OnReturnValue;

public class Player
extends Displayer {
    private final ConcurrentHashMap<String, EventListener> eventListenerConcurrentHashMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, FrequencyEventListener> frequencyEventListenerConcurrentHashMap = new ConcurrentHashMap();
    private final SyncDisplayerState<PlayerState> syncPlayerState;
    private final long timeDuration;
    private final int framesCount;
    private final long beginTimestamp;
    private double playbackSpeed;
    private long scheduleTime = 0L;
    private PlayerPhase playerPhase = PlayerPhase.waitingFirstFrame;

    public double getPlaybackSpeed() {
        return this.playbackSpeed;
    }

    public void setPlaybackSpeed(double playbackSpeed) {
        this.playbackSpeed = playbackSpeed;
        this.bridge.callHandler("player.setPlaybackSpeed", new Object[]{playbackSpeed});
    }

    public void getPlaybackSpeed(final Promise<Double> promise) {
        this.bridge.callHandler("player.state.playbackSpeed", new OnReturnValue<Number>(){

            public void onValue(Number value) {
                promise.then(value.doubleValue());
            }
        });
    }

    public Player(String room, WhiteboardView bridge, Context context, WhiteSdk whiteSdk, PlayerTimeInfo playerTimeInfo, SyncDisplayerState<PlayerState> syncPlayerState) {
        super(room, bridge, context, whiteSdk);
        this.syncPlayerState = syncPlayerState;
        this.timeDuration = playerTimeInfo.getTimeDuration();
        this.framesCount = playerTimeInfo.getFramesCount();
        this.beginTimestamp = playerTimeInfo.getBeginTimestamp();
    }

    SyncDisplayerState<PlayerState> getSyncPlayerState() {
        return this.syncPlayerState;
    }

    void setPlayerPhase(PlayerPhase playerPhase) {
        this.playerPhase = playerPhase;
    }

    void setScheduleTime(long scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public void play() {
        this.bridge.callHandler("player.play", new Object[0]);
    }

    public void pause() {
        this.bridge.callHandler("player.pause", new Object[0]);
    }

    public void stop() {
        this.bridge.callHandler("player.stop", new Object[0]);
    }

    public void seekToScheduleTime(long seekTime) {
        this.bridge.callHandler("player.seekToScheduleTime", new Object[]{seekTime});
    }

    void fireMagixEvent(EventEntry eventEntry) {
        EventListener eventListener = this.eventListenerConcurrentHashMap.get(eventEntry.getEventName());
        if (eventListener != null) {
            try {
                eventListener.onEvent(eventEntry);
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while sending the event", e);
            }
        }
    }

    void fireHighFrequencyEvent(EventEntry[] eventEntries) {
        FrequencyEventListener eventListener = this.frequencyEventListenerConcurrentHashMap.get(eventEntries[0].getEventName());
        if (eventListener != null) {
            try {
                eventListener.onEvent(eventEntries);
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while sending the event", e);
            }
        }
    }

    public void setObserverMode(PlayerObserverMode mode) {
        this.bridge.callHandler("player.setObserverMode", new Object[]{mode.name()});
    }

    public PlayerPhase getPlayerPhase() {
        return this.playerPhase;
    }

    public void getPhase(final Promise<PlayerPhase> promise) {
        this.bridge.callHandler("player.getBroadcastState", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    promise.then(PlayerPhase.valueOf(String.valueOf(o)));
                }
                catch (AssertionError a) {
                    throw a;
                }
                catch (JsonSyntaxException e) {
                    Logger.error("An JsonSyntaxException occurred while parse json from getPhase", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred in getPhase promise then method", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public PlayerState getPlayerState() {
        if (this.playerPhase == PlayerPhase.waitingFirstFrame) {
            return null;
        }
        return this.syncPlayerState.getDisplayerState();
    }

    public void getPlayerState(final Promise<PlayerState> promise) {
        this.bridge.callHandler("player.state.playerState", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    PlayerState playerState = (PlayerState)Displayer.gson.fromJson(String.valueOf(o), PlayerState.class);
                    promise.then(playerState);
                }
                catch (AssertionError a) {
                    throw a;
                }
                catch (JsonSyntaxException e) {
                    Logger.error("An JsonSyntaxException occurred while parse json from getPlayerState", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred in getPlayerState promise then method", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public PlayerTimeInfo getPlayerTimeInfo() {
        return new PlayerTimeInfo(this.scheduleTime, this.timeDuration, this.framesCount, this.beginTimestamp);
    }

    public void getPlayerTimeInfo(final Promise<PlayerTimeInfo> promise) {
        this.bridge.callHandler("player.state.timeInfo", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                promise.then(Player.this.getPlayerTimeInfo());
            }
        });
    }
}

