/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.webkit.JavascriptInterface;
import com.herewhite.sdk.AudioMixerBridge;
import com.herewhite.sdk.WhiteboardView;
import org.json.JSONException;
import org.json.JSONObject;

public class AudioMixerImplement {
    private WhiteboardView bridge;
    private AudioMixerBridge mixerBridge;

    AudioMixerImplement(WhiteboardView bridge, AudioMixerBridge mixerBridge) {
        this.bridge = bridge;
        this.mixerBridge = mixerBridge;
    }

    public void setMediaState(long state, long errorCode) {
        this.bridge.callHandler("rtc.callback", new Object[]{state, errorCode});
    }

    @JavascriptInterface
    public void startAudioMixing(Object args) {
        if (this.mixerBridge != null && args instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)args;
            try {
                String filePath = jsonObject.getString("filePath");
                boolean loopback = jsonObject.getBoolean("loopback");
                boolean replace = jsonObject.getBoolean("replace");
                int cycle = jsonObject.getInt("cycle");
                this.mixerBridge.startAudioMixing(filePath, loopback, replace, cycle);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @JavascriptInterface
    public void stopAudioMixing(Object args) {
        if (this.mixerBridge != null) {
            this.mixerBridge.stopAudioMixing();
        }
    }

    @JavascriptInterface
    public void setAudioMixingPosition(Object args) {
        if (this.mixerBridge != null) {
            int pos = (Integer)args;
            this.mixerBridge.setAudioMixingPosition(pos);
        }
    }
}

