/*
 * Decompiled with CFR 0.152.
 */
package cn.nekocode.rxlifecycle.compact;

import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import cn.nekocode.rxlifecycle.LifecycleEvent;
import cn.nekocode.rxlifecycle.compact.BindingV4Fragment;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleCompletableTransformer;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleFlowableTransformer;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleMaybeTransformer;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleObservableTransformer;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleSingleTransformer;
import io.reactivex.BackpressureStrategy;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.SingleTransformer;

public class RxLifecycleCompact {
    private static final String FRAGMENT_TAG = "_BINDING_V4_FRAGMENT_";
    private final Observable<LifecycleEvent> mLifecycleObservable;

    public static RxLifecycleCompact bind(@NonNull Observable<LifecycleEvent> lifecycleObservable) {
        return new RxLifecycleCompact(lifecycleObservable);
    }

    public static RxLifecycleCompact bind(@NonNull AppCompatActivity targetActivity) {
        return RxLifecycleCompact.bind(targetActivity.getSupportFragmentManager());
    }

    public static RxLifecycleCompact bind(@NonNull Fragment targetFragment) {
        return RxLifecycleCompact.bind(targetFragment.getChildFragmentManager());
    }

    public static RxLifecycleCompact bind(@NonNull FragmentManager fragmentManager) {
        BindingV4Fragment fragment = (BindingV4Fragment)fragmentManager.findFragmentByTag(FRAGMENT_TAG);
        if (fragment == null) {
            fragment = new BindingV4Fragment();
            FragmentTransaction transaction = fragmentManager.beginTransaction();
            transaction.add((Fragment)fragment, FRAGMENT_TAG);
            transaction.commit();
        } else if (fragment.isDetached()) {
            FragmentTransaction transaction = fragmentManager.beginTransaction();
            transaction.attach((Fragment)fragment);
            transaction.commit();
        }
        return RxLifecycleCompact.bind(fragment.getLifecycleBehavior());
    }

    private RxLifecycleCompact(Observable<LifecycleEvent> lifecycleObservable) {
        this.mLifecycleObservable = lifecycleObservable;
    }

    public Flowable<LifecycleEvent> toFlowable(BackpressureStrategy strategy) {
        return this.mLifecycleObservable.toFlowable(strategy);
    }

    public Observable<LifecycleEvent> toObservable() {
        return this.mLifecycleObservable;
    }

    public <T> FlowableTransformer<T, T> cancelFlowableWhen(LifecycleEvent event) {
        return new BindLifecycleFlowableTransformer(this.mLifecycleObservable, event);
    }

    public <T> ObservableTransformer<T, T> disposeObservableWhen(LifecycleEvent event) {
        return new BindLifecycleObservableTransformer(this.mLifecycleObservable, event);
    }

    public CompletableTransformer disposeCompletableWhen(LifecycleEvent event) {
        return new BindLifecycleCompletableTransformer(this.mLifecycleObservable, event);
    }

    public <T> SingleTransformer<T, T> disposeSingleWhen(LifecycleEvent event) {
        return new BindLifecycleSingleTransformer(this.mLifecycleObservable, event);
    }

    public <T> MaybeTransformer<T, T> disposeMaybeWhen(LifecycleEvent event) {
        return new BindLifecycleMaybeTransformer(this.mLifecycleObservable, event);
    }
}

