/*
 * Decompiled with CFR 0.152.
 */
package com.naskar.fluentquery.binder;

import com.naskar.fluentquery.binder.BinderSQL;
import com.naskar.fluentquery.converters.NativeSQLResult;
import com.naskar.fluentquery.impl.MethodRecordProxy;
import com.naskar.fluentquery.impl.TypeUtils;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class BinderSQLImpl<T>
implements BinderSQL<T> {
    private NativeSQLResult result;
    private Map<Object, Function<T, ?>> maps = new IdentityHashMap();
    private MethodRecordProxy<T> proxy;

    public BinderSQLImpl(Class<T> clazz) {
        this.proxy = TypeUtils.createProxy(clazz);
        this.proxy.setExecute(false);
    }

    @Override
    public void configure(NativeSQLResult result) {
        this.result = result;
    }

    @Override
    public <R> R get(Function<T, R> getter) {
        this.proxy.clear();
        getter.apply(this.proxy.getProxy());
        R r = this.createInstance(this.proxy.getCalledMethod().getReturnType());
        this.maps.put(r, getter);
        return r;
    }

    private <R, E> R createInstance(Class<E> returnType) {
        if (Long.class.equals(returnType)) {
            return (R)new Long(0L);
        }
        if (Double.class.equals(returnType)) {
            return (R)new Double(0.0);
        }
        return (R)TypeUtils.createInstance(returnType);
    }

    @Override
    public NativeSQLResult bind(T t) {
        NativeSQLResult newResult = new NativeSQLResult();
        newResult.sql(this.result.sql());
        newResult.names().addAll(this.result.names());
        Map<String, Object> params = newResult.params();
        List<Object> values = newResult.values();
        for (Map.Entry<String, Object> e : this.result.params().entrySet()) {
            Object v = e.getValue();
            Function<T, ?> f = this.maps.get(e.getValue());
            if (f != null) {
                v = f.apply(t);
            }
            params.put(e.getKey(), v);
            values.add(v);
        }
        return newResult;
    }
}

