/*
 * Decompiled with CFR 0.152.
 */
package com.github.naoghuman.lib.fxml.core;

import com.github.naoghuman.lib.fxml.core.FXMLModel;
import com.github.naoghuman.lib.fxml.internal.DefaultFXMLValidator;
import java.util.List;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.scene.Parent;

public abstract class FXMLController {
    private final List<FXMLModel> models = FXCollections.observableArrayList();

    public void configure() {
    }

    public void configure(FXMLModel model) {
        DefaultFXMLValidator.requireNonNull(model);
        this.getModels().clear();
        this.getModels().add(model);
    }

    public void configure(List<FXMLModel> models) {
        DefaultFXMLValidator.requireNonNull(models);
        this.getModels().clear();
        this.getModels().addAll(models);
    }

    public Optional<FXMLModel> getModel(Class entity, Long entityId) {
        DefaultFXMLValidator.requireNonNull(entity);
        DefaultFXMLValidator.requireNonNull(entityId);
        Optional<FXMLModel> fxmlModel = this.models.stream().filter(model -> model.isSameEntity(entity, entityId)).findFirst();
        return fxmlModel;
    }

    public List<FXMLModel> getModels() {
        return this.models;
    }

    public Optional<Parent> getView() {
        return Optional.empty();
    }
}

