/*
 * Decompiled with CFR 0.152.
 */
package com.github.naoghuman.lib.fxml.core;

import com.github.naoghuman.lib.fxml.core.FXMLModel;
import com.github.naoghuman.lib.fxml.internal.DefaultFXMLValidator;
import com.github.naoghuman.lib.logger.core.LoggerFacade;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;

public final class FXMLAction {
    private static final HashMap<String, Consumer<FXMLModel>> CONSUMERS = new HashMap();
    private static final HashMap<String, EventHandler<ActionEvent>> EVENTHANDLERS = new HashMap();
    private static final HashMap<String, Function<Long, FXMLModel>> FUNCTIONS = new HashMap();
    private static final HashMap<String, Supplier<List<FXMLModel>>> SUPPLIERS = new HashMap();
    private static final String ERROR_MSG__ACTION_ID_ISNT_REGISTERED = "Error: The [actionId=%s] isn't registerd!";
    private static final Optional<FXMLAction> INSTANCE = Optional.of(new FXMLAction());

    public static final FXMLAction getDefault() {
        return INSTANCE.get();
    }

    private FXMLAction() {
    }

    public void handleAction(String actionId) {
        LoggerFacade.getDefault().debug(FXMLAction.class, "FXMLAction#handleAction(String)");
        DefaultFXMLValidator.requireNonNullAndNotEmpty(actionId);
        if (!this.isRegistered(actionId)) {
            throw new IllegalArgumentException(String.format(ERROR_MSG__ACTION_ID_ISNT_REGISTERED, actionId));
        }
        EventHandler<ActionEvent> eventHandler = EVENTHANDLERS.get(actionId);
        DefaultFXMLValidator.requireNonNull(eventHandler);
        eventHandler.handle((Event)new ActionEvent());
    }

    public void handleAction(String actionId, Object source) {
        LoggerFacade.getDefault().debug(FXMLAction.class, "FXMLAction#handleAction(String, Object)");
        DefaultFXMLValidator.requireNonNullAndNotEmpty(actionId);
        DefaultFXMLValidator.requireNonNull(source);
        if (!this.isRegistered(actionId)) {
            throw new IllegalArgumentException(String.format(ERROR_MSG__ACTION_ID_ISNT_REGISTERED, actionId));
        }
        EventHandler<ActionEvent> eventHandler = EVENTHANDLERS.get(actionId);
        DefaultFXMLValidator.requireNonNull(eventHandler);
        eventHandler.handle((Event)new ActionEvent(source, null));
    }

    public void handleConsumer(String actionId, FXMLModel model) {
        LoggerFacade.getDefault().debug(FXMLAction.class, "FXMLAction#handleConsumer(String, FXMLModel)");
        DefaultFXMLValidator.requireNonNullAndNotEmpty(actionId);
        DefaultFXMLValidator.requireNonNull(model);
        if (!this.isRegistered(actionId)) {
            throw new IllegalArgumentException(String.format(ERROR_MSG__ACTION_ID_ISNT_REGISTERED, actionId));
        }
        Consumer<FXMLModel> consumer = CONSUMERS.get(actionId);
        DefaultFXMLValidator.requireNonNull(consumer);
        consumer.accept(model);
    }

    public FXMLModel handleFunction(String actionId, Long entityId) {
        LoggerFacade.getDefault().debug(FXMLAction.class, "FXMLAction#handleFunction(String, Long)");
        DefaultFXMLValidator.requireNonNullAndNotEmpty(actionId);
        DefaultFXMLValidator.requireNonNull(entityId);
        if (!this.isRegistered(actionId)) {
            throw new IllegalArgumentException(String.format(ERROR_MSG__ACTION_ID_ISNT_REGISTERED, actionId));
        }
        Function<Long, FXMLModel> function = FUNCTIONS.get(actionId);
        DefaultFXMLValidator.requireNonNull(function);
        return function.apply(entityId);
    }

    public List<FXMLModel> handleSupplier(String actionId) {
        LoggerFacade.getDefault().debug(FXMLAction.class, "FXMLAction#handleSupplier(String)");
        DefaultFXMLValidator.requireNonNullAndNotEmpty(actionId);
        if (!this.isRegistered(actionId)) {
            throw new IllegalArgumentException(String.format(ERROR_MSG__ACTION_ID_ISNT_REGISTERED, actionId));
        }
        Supplier<List<FXMLModel>> supplier = SUPPLIERS.get(actionId);
        DefaultFXMLValidator.requireNonNull(supplier);
        return supplier.get();
    }

    public boolean isRegistered(String actionId) {
        LoggerFacade.getDefault().debug(FXMLAction.class, "FXMLAction#isRegistered(String)");
        DefaultFXMLValidator.requireNonNullAndNotEmpty(actionId);
        return CONSUMERS.containsKey(actionId) || EVENTHANDLERS.containsKey(actionId) || FUNCTIONS.containsKey(actionId) || SUPPLIERS.containsKey(actionId);
    }

    public void register(String actionId, Consumer<FXMLModel> consumer) {
        LoggerFacade.getDefault().info(FXMLAction.class, "FXMLAction#register(String, Consumer<FXMLModel>)");
        DefaultFXMLValidator.requireNonNullAndNotEmpty(actionId);
        DefaultFXMLValidator.requireNonNull(consumer);
        CONSUMERS.put(actionId, consumer);
    }

    public void register(String actionId, EventHandler<ActionEvent> eventHandler) {
        LoggerFacade.getDefault().info(FXMLAction.class, "FXMLAction#register(String, EventHandler<ActionEvent>)");
        DefaultFXMLValidator.requireNonNullAndNotEmpty(actionId);
        DefaultFXMLValidator.requireNonNull(eventHandler);
        EVENTHANDLERS.put(actionId, eventHandler);
    }

    public void register(String actionId, Function<Long, FXMLModel> function) {
        LoggerFacade.getDefault().info(FXMLAction.class, "FXMLAction#register(String, Function<Long, FXMLModel>)");
        DefaultFXMLValidator.requireNonNullAndNotEmpty(actionId);
        DefaultFXMLValidator.requireNonNull(function);
        FUNCTIONS.put(actionId, function);
    }

    public void register(String actionId, Supplier<List<FXMLModel>> supplier) {
        LoggerFacade.getDefault().info(FXMLAction.class, "FXMLAction#register(String, Supplier<List<FXMLModel>>)");
        DefaultFXMLValidator.requireNonNullAndNotEmpty(actionId);
        DefaultFXMLValidator.requireNonNull(supplier);
        SUPPLIERS.put(actionId, supplier);
    }

    public void remove(String actionId) {
        LoggerFacade.getDefault().debug(FXMLAction.class, "FXMLAction#remove(String)");
        DefaultFXMLValidator.requireNonNullAndNotEmpty(actionId);
        if (CONSUMERS.containsKey(actionId)) {
            LoggerFacade.getDefault().debug(FXMLAction.class, String.format("Remove 'Consumer<FXMLModel>' with [actionId]: %s", actionId));
            CONSUMERS.remove(actionId);
        }
        if (EVENTHANDLERS.containsKey(actionId)) {
            LoggerFacade.getDefault().debug(FXMLAction.class, String.format("Remove 'EventHandler<ActionEvent>' with [actionId]: %s", actionId));
            EVENTHANDLERS.remove(actionId);
        }
        if (FUNCTIONS.containsKey(actionId)) {
            LoggerFacade.getDefault().debug(FXMLAction.class, String.format("Remove 'Function<Long, FXMLModel>' with [actionId]: %s", actionId));
            FUNCTIONS.remove(actionId);
        }
        if (SUPPLIERS.containsKey(actionId)) {
            LoggerFacade.getDefault().debug(FXMLAction.class, String.format("Remove 'Supplier<List<FXMLModel>>' with [actionId]: %s", actionId));
            SUPPLIERS.remove(actionId);
        }
    }
}

