/*
 * Decompiled with CFR 0.152.
 */
package com.nanchen.compresshelper;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.nanchen.compresshelper.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    static final String FILES_PATH = "CompressHelper";
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private FileUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static File getFileByPath(String filePath) {
        return StringUtil.isSpace(filePath) ? null : new File(filePath);
    }

    public static boolean isFileExists(String filePath) {
        return FileUtil.isFileExists(FileUtil.getFileByPath(filePath));
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    public static boolean rename(String filePath, String newName) {
        return FileUtil.rename(FileUtil.getFileByPath(filePath), newName);
    }

    public static boolean rename(File file, String newName) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (StringUtil.isSpace(newName)) {
            return false;
        }
        if (newName.equals(file.getName())) {
            return true;
        }
        File newFile = new File(file.getParent() + File.separator + newName);
        return !newFile.exists() && file.renameTo(newFile);
    }

    public static boolean isDir(String dirPath) {
        return FileUtil.isDir(FileUtil.getFileByPath(dirPath));
    }

    public static boolean isDir(File file) {
        return FileUtil.isFileExists(file) && file.isDirectory();
    }

    public static boolean isFile(String filePath) {
        return FileUtil.isFile(FileUtil.getFileByPath(filePath));
    }

    public static boolean isFile(File file) {
        return FileUtil.isFileExists(file) && file.isFile();
    }

    public static File renameFile(File file, String newName) {
        File newFile = new File(file.getParent(), newName);
        if (!newFile.equals(file)) {
            if (newFile.exists() && newFile.delete()) {
                Log.d((String)"FileUtil", (String)("Delete old " + newName + " file"));
            }
            if (file.renameTo(newFile)) {
                Log.d((String)"FileUtil", (String)("Rename file to " + newName));
            }
        }
        return newFile;
    }

    public static File getTempFile(Context context, Uri uri) throws IOException {
        InputStream inputStream = context.getContentResolver().openInputStream(uri);
        String fileName = FileUtil.getFileName(context, uri);
        String[] splitName = FileUtil.splitFileName(fileName);
        File tempFile = File.createTempFile(splitName[0], splitName[1]);
        tempFile = FileUtil.renameFile(tempFile, fileName);
        tempFile.deleteOnExit();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tempFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (inputStream != null) {
            FileUtil.copy(inputStream, out);
            inputStream.close();
        }
        if (out != null) {
            out.close();
        }
        return tempFile;
    }

    static String[] splitFileName(String fileName) {
        String name = fileName;
        String extension = "";
        int i = fileName.lastIndexOf(".");
        if (i != -1) {
            name = fileName.substring(0, i);
            extension = fileName.substring(i);
        }
        return new String[]{name, extension};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getFileName(Context context, Uri uri) {
        int cut;
        String result = null;
        if (uri.getScheme().equals("content")) {
            try (Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);){
                if (cursor != null && cursor.moveToFirst()) {
                    result = cursor.getString(cursor.getColumnIndex("_display_name"));
                }
            }
        }
        if (result == null && (cut = (result = uri.getPath()).lastIndexOf(File.separator)) != -1) {
            result = result.substring(cut + 1);
        }
        return result;
    }

    static String getRealPathFromURI(Context context, Uri uri) {
        Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
        if (cursor == null) {
            return uri.getPath();
        }
        cursor.moveToFirst();
        int index = cursor.getColumnIndex("_data");
        String realPath = cursor.getString(index);
        cursor.close();
        return realPath;
    }

    static int copy(InputStream input, OutputStream output) throws IOException {
        long count = FileUtil.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return FileUtil.copyLarge(input, output, new byte[4096]);
    }

    static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

