/*
 * Decompiled with CFR 0.152.
 */
package com.naman14.androidlame;

import com.naman14.androidlame.AndroidLame;

public class LameBuilder {
    public int inSampleRate = 44100;
    public int outSampleRate = 0;
    public int outBitrate = 128;
    public int outChannel = 2;
    public int quality = 5;
    public int vbrQuality = 5;
    public int abrMeanBitrate = 128;
    public int lowpassFreq = 0;
    public int highpassFreq = 0;
    public float scaleInput = 1.0f;
    public Mode mode = Mode.DEFAULT;
    public VbrMode vbrMode = VbrMode.VBR_OFF;
    public String id3tagTitle = null;
    public String id3tagArtist = null;
    public String id3tagAlbum = null;
    public String id3tagComment = null;
    public String id3tagYear = null;

    public LameBuilder setQuality(int quality) {
        this.quality = quality;
        return this;
    }

    public LameBuilder setInSampleRate(int inSampleRate) {
        this.inSampleRate = inSampleRate;
        return this;
    }

    public LameBuilder setOutSampleRate(int outSampleRate) {
        this.outSampleRate = outSampleRate;
        return this;
    }

    public LameBuilder setOutBitrate(int bitrate) {
        this.outBitrate = bitrate;
        return this;
    }

    public LameBuilder setOutChannels(int channels) {
        this.outChannel = channels;
        return this;
    }

    public LameBuilder setId3tagTitle(String title) {
        this.id3tagTitle = title;
        return this;
    }

    public LameBuilder setId3tagArtist(String artist) {
        this.id3tagArtist = artist;
        return this;
    }

    public LameBuilder setId3tagAlbum(String album) {
        this.id3tagAlbum = album;
        return this;
    }

    public LameBuilder setId3tagComment(String comment) {
        this.id3tagComment = comment;
        return this;
    }

    public LameBuilder setId3tagYear(String year) {
        this.id3tagYear = year;
        return this;
    }

    public LameBuilder setScaleInput(float scaleAmount) {
        this.scaleInput = scaleAmount;
        return this;
    }

    public LameBuilder setMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public LameBuilder setVbrMode(VbrMode mode) {
        this.vbrMode = mode;
        return this;
    }

    public LameBuilder setVbrQuality(int quality) {
        this.vbrQuality = quality;
        return this;
    }

    public LameBuilder setAbrMeanBitrate(int bitrate) {
        this.abrMeanBitrate = bitrate;
        return this;
    }

    public LameBuilder setLowpassFreqency(int freq) {
        this.lowpassFreq = freq;
        return this;
    }

    public LameBuilder setHighpassFreqency(int freq) {
        this.highpassFreq = freq;
        return this;
    }

    public AndroidLame build() {
        return new AndroidLame(this);
    }

    public static enum VbrMode {
        VBR_OFF,
        VBR_RH,
        VBR_MTRH,
        VBR_ABR,
        VBR_DEFAUT;

    }

    public static enum Mode {
        STEREO,
        JSTEREO,
        MONO,
        DEFAULT;

    }
}

