/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.number;

import com.github.mygreen.cellformatter.number.DecimalNumber;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class ExponentNumber
extends DecimalNumber {
    private String exponentPart;
    private int exponentSign;

    public ExponentNumber(double value, int decimalScale) {
        super(value, decimalScale);
    }

    @Override
    protected void init() {
        if (this.isZero()) {
            this.integerPart = "";
            this.decimalPart = "";
            this.exponentPart = "0";
            this.exponentSign = 1;
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#");
        sb.append(".");
        for (int i = 0; i < this.getScale(); ++i) {
            sb.append("#");
        }
        sb.append("E0");
        DecimalFormat format = new DecimalFormat(sb.toString());
        format.setRoundingMode(RoundingMode.HALF_UP);
        String str = format.format(Math.abs(this.getValue()));
        int exponentIdx = str.indexOf("E");
        String numberPart = str.substring(0, exponentIdx);
        String exponentPart = str.substring(exponentIdx + 1);
        this.setupIntegerAndDecimalPart(numberPart);
        if (exponentPart.startsWith("-")) {
            this.exponentSign = -1;
            this.exponentPart = exponentPart.substring(1);
        } else {
            this.exponentSign = 1;
            this.exponentPart = exponentPart;
        }
    }

    public boolean isExponentPositive() {
        return this.exponentSign >= 0;
    }

    public boolean isExponentNegative() {
        return this.exponentSign < 0;
    }

    public String getExponentPart() {
        return this.exponentPart;
    }

    public String getExponentPart(int digit) {
        int length = this.exponentPart.length();
        if (length < digit || digit <= 0) {
            return "";
        }
        return String.valueOf(this.exponentPart.charAt(length - digit));
    }

    public String getExponentPartAfter(int digit) {
        int length = this.exponentPart.length();
        if (length < digit || digit <= 0) {
            return "";
        }
        return this.exponentPart.substring(0, length - digit + 1);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("E");
        if (this.isExponentPositive()) {
            sb.append("+");
        } else {
            sb.append("-");
        }
        sb.append(this.getExponentPart());
        return sb.toString();
    }
}

