/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.callback;

import com.github.mygreen.cellformatter.callback.DBNum1;
import com.github.mygreen.cellformatter.callback.DBNumBase;
import com.github.mygreen.cellformatter.callback.KansujiConverter;
import com.github.mygreen.cellformatter.term.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DBNum2
extends DBNumBase {
    private Map<String, KansujiConverter> converters = new ConcurrentHashMap<String, KansujiConverter>();

    public static DBNum2 create() {
        return new DBNum2();
    }

    public DBNum2() {
        super("ja", "zh", "ko");
        this.converters.put("ja", new JapaneseConverter());
        this.converters.put("zh", new ChineseConverter());
        this.converters.put("ko", new KoreanConverter());
    }

    @Override
    public String call(Object data, String value, Locale locale, Term<?> term) {
        String language = locale.getLanguage().toLowerCase();
        return this.converters.get(language).convert(value, this.is4YearTerm(term));
    }

    public static class KoreanConverter
    extends DBNum1.KoreanConverter {
        public KoreanConverter() {
            this.setNumMap(new String[]{"\uf9b2", "\u58f9", "\u8cb3", "\uf96b", "\u56db", "\u4f0d", "\uf9d1", "\u4e03", "\u516b", "\u4e5d"});
            this.setDigits10Map(new String[]{"", "\u842c", "\u5104", "\u5146", "\u4eac"});
            this.setDigits4Map(new String[]{"", "\uf973", "\u767e", "\u9621"});
        }
    }

    public static class ChineseConverter
    extends DBNum1.ChineseConverter {
        public ChineseConverter() {
            this.setNumMap(new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"});
            this.setDigits10Map(new String[]{"", "\u4e07", "\u4ebf", "\u5146", "\u4eac"});
            this.setDigits4Map(new String[]{"", "\u62fe", "\u4f70", "\u4edf"});
        }
    }

    public static class JapaneseConverter
    extends KansujiConverter {
        public JapaneseConverter() {
            this.setNumMap(new String[]{"\u3007", "\u58f1", "\u5f10", "\u53c2", "\u56db", "\u4f0d", "\u516d", "\u4e03", "\u516b", "\u4e5d"});
            this.setDigits10Map(new String[]{"", "\u842c", "\u5104", "\u5146", "\u4eac"});
            this.setDigits4Map(new String[]{"", "\u62fe", "\u767e", "\u9621"});
        }

        @Override
        protected String replace4Digits(String value) {
            int length = value.length();
            ArrayList<String> digits = new ArrayList<String>();
            for (int i = 0; i < length; ++i) {
                char c = value.charAt(length - i - 1);
                if (c == '0') continue;
                String item = this.replaceSimple(String.valueOf(c)) + this.digits4Map[i];
                digits.add(item);
            }
            Collections.reverse(digits);
            StringBuilder sb = new StringBuilder();
            for (String item : digits) {
                sb.append(item);
            }
            return sb.toString();
        }
    }
}

