/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.CellFormatResult;
import com.github.mygreen.cellformatter.CellFormatter;
import com.github.mygreen.cellformatter.CommonCell;
import com.github.mygreen.cellformatter.ConditionFormatter;
import com.github.mygreen.cellformatter.ConditionNumberFormatter;
import com.github.mygreen.cellformatter.ConditionOperator;
import com.github.mygreen.cellformatter.ConditionTextFormatter;
import com.github.mygreen.cellformatter.NoMatchConditionFormatterException;
import com.github.mygreen.cellformatter.lang.ArgUtils;
import com.github.mygreen.cellformatter.number.NumberFactory;
import com.github.mygreen.cellformatter.term.NumberTerm;
import com.github.mygreen.cellformatter.term.TextTerm;
import com.github.mygreen.cellformatter.tokenizer.Token;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

public class CustomFormatter
extends CellFormatter {
    public static final CustomFormatter DEFAULT_FORMATTER;
    private final String pattern;
    private List<ConditionFormatter> conditionFormatters = new CopyOnWriteArrayList<ConditionFormatter>();

    public CustomFormatter(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public CellFormatResult format(CommonCell cell, Locale runtimeLocale) {
        ArgUtils.notNull(cell, "cell");
        for (ConditionFormatter formatter : this.conditionFormatters) {
            if (!formatter.isMatch(cell)) continue;
            return formatter.format(cell, runtimeLocale);
        }
        if (cell.isText()) {
            return DEFAULT_FORMATTER.format(cell, runtimeLocale);
        }
        if (cell.isNumber()) {
            return DEFAULT_FORMATTER.format(cell, runtimeLocale);
        }
        throw new NoMatchConditionFormatterException(cell, String.format("not match format for cell : '%s'", cell.getCellAddress()));
    }

    @Override
    public String getPattern(Locale locale) {
        return this.pattern;
    }

    public boolean hasTextFormatter() {
        for (ConditionFormatter formatter : this.conditionFormatters) {
            if (!formatter.isTextFormatter()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDateFormatter() {
        for (ConditionFormatter formatter : this.conditionFormatters) {
            if (!formatter.isDateFormatter()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNumberFormatter() {
        for (ConditionFormatter formatter : this.conditionFormatters) {
            if (!formatter.isNumberFormatter()) continue;
            return true;
        }
        return false;
    }

    public void addConditionFormatter(ConditionFormatter formatter) {
        this.conditionFormatters.add(formatter);
    }

    public List<ConditionFormatter> getConditionFormatters() {
        return this.conditionFormatters;
    }

    static {
        ConditionNumberFormatter numberFormatter = new ConditionNumberFormatter("General");
        numberFormatter.addTerm(NumberTerm.general());
        numberFormatter.setOperator(ConditionOperator.ALL);
        numberFormatter.setNumberFactory(NumberFactory.decimalNumber(0, false, 0));
        ConditionTextFormatter textFormatter = new ConditionTextFormatter("General");
        textFormatter.addTerm(TextTerm.atMark(Token.SYMBOL_AT_MARK));
        textFormatter.setOperator(ConditionOperator.ALL);
        CustomFormatter formatter = new CustomFormatter("");
        formatter.addConditionFormatter(numberFormatter);
        formatter.addConditionFormatter(textFormatter);
        DEFAULT_FORMATTER = formatter;
    }
}

