/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.CellFormatResult;
import com.github.mygreen.cellformatter.CommonCell;
import com.github.mygreen.cellformatter.ConditionFormatter;
import com.github.mygreen.cellformatter.FormatCellType;
import com.github.mygreen.cellformatter.FormatterType;
import com.github.mygreen.cellformatter.term.Term;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConditionTextFormatter
extends ConditionFormatter {
    private List<Term<String>> terms = new CopyOnWriteArrayList<Term<String>>();

    public ConditionTextFormatter(String pattern) {
        super(pattern);
    }

    @Override
    public FormatterType getType() {
        return FormatterType.Text;
    }

    @Override
    public boolean isMatch(CommonCell cell) {
        return cell.isText() || cell.isBoolean();
    }

    @Override
    public CellFormatResult format(CommonCell cell, Locale runtimeLocale) {
        String value = cell.isBoolean() ? String.valueOf(cell.getBooleanCellValue()).toUpperCase() : cell.getTextCellValue();
        StringBuilder sb = new StringBuilder();
        for (Term<String> term : this.terms) {
            sb.append(term.format(value, this.getLocale(), runtimeLocale));
        }
        String text = sb.toString();
        CellFormatResult result = new CellFormatResult();
        if (cell.isBoolean()) {
            result.setValue(cell.getBooleanCellValue());
            result.setCellType(FormatCellType.Boolean);
        } else {
            result.setValue(value);
            result.setCellType(FormatCellType.Text);
        }
        result.setText(text);
        result.setTextColor(this.getColor());
        result.setSectionPattern(this.getPattern());
        return result;
    }

    public List<Term<String>> getTerms() {
        return this.terms;
    }

    public void addTerm(Term<String> term) {
        this.terms.add(term);
    }
}

