/*
 * Decompiled with CFR 0.152.
 */
package com.github.mxab.thymeleaf.extras.dataattribute.dialect;

import com.github.mxab.thymeleaf.extras.dataattribute.dialect.DataAttributeDialect;
import java.util.Collection;
import java.util.Map;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.NestableAttributeHolderNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.IProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;

public class DataAttributeMatcher
implements IProcessorMatcher<NestableAttributeHolderNode> {
    public boolean matches(Node node, ProcessorMatchingContext context) {
        NestableAttributeHolderNode element = (NestableAttributeHolderNode)node;
        if (context.getDialect() instanceof DataAttributeDialect) {
            String dialectPrefix = context.getDialectPrefix();
            Map attributeMap = element.getAttributeMap();
            Collection values = attributeMap.values();
            for (Attribute attribute : values) {
                String prefixFromAttributeName = Attribute.getPrefixFromAttributeName((String)attribute.getNormalizedName());
                if (!dialectPrefix.equals(prefixFromAttributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public Class<? extends NestableAttributeHolderNode> appliesTo() {
        return NestableAttributeHolderNode.class;
    }
}

