/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner.validation;

import com.github.mvp4g.mvp4g2.core.eventbus.IsEventBus;
import com.github.mvp4g.mvp4g2.core.eventbus.IsEventFilter;
import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Filters;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class FilterAnnotationValidator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private RoundEnvironment roundEnvironment;
    private TypeElement eventBusTypeElement;

    private FilterAnnotationValidator() {
    }

    private FilterAnnotationValidator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.roundEnvironment = builder.roundEnvironment;
        this.eventBusTypeElement = builder.eventBusTypeElement;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate() throws ProcessorException {
        Set<? extends Element> elementsWithFilterAnnotation = this.roundEnvironment.getElementsAnnotatedWith(Filters.class);
        if (elementsWithFilterAnnotation.size() > 1) {
            throw new ProcessorException("Mvp4g2Processor: There should be at least only one interface, that is annotated with @Filter");
        }
        for (Element element : elementsWithFilterAnnotation) {
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                if (!typeElement.getKind().isInterface()) {
                    throw new ProcessorException("Mvp4g2Processor: @Filter can only be used with an interface");
                }
                if (!this.processorUtils.extendsClassOrInterface(this.processingEnvironment.getTypeUtils(), typeElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(IsEventBus.class.getCanonicalName()).asType())) {
                    throw new ProcessorException("Mvp4g2Processor: @Filter can only be used on interfaces that extends IsEventBus");
                }
                List<String> eventFilterAsStringList = this.getEventFiltersAsList(this.eventBusTypeElement);
                for (String eventFilterClassname : eventFilterAsStringList) {
                    TypeElement filterElement = this.processingEnvironment.getElementUtils().getTypeElement(eventFilterClassname);
                    if (this.processorUtils.extendsClassOrInterface(this.processingEnvironment.getTypeUtils(), filterElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(IsEventFilter.class.getCanonicalName()).asType())) continue;
                    throw new ProcessorException("Mvp4g2Processor: @Filter - the filters attribute needs class that implements IsEventFilter");
                }
                continue;
            }
            throw new ProcessorException("Mvp4g2Processor: @Filter can only be used on a type (interface)");
        }
    }

    public List<String> getEventFiltersAsList(TypeElement typeElement) {
        TypeElement filterAnnotation = this.processingEnvironment.getElementUtils().getTypeElement(Filters.class.getName());
        TypeMirror filterAnnotationAsTypeMirror = filterAnnotation.asType();
        return typeElement.getAnnotationMirrors().stream().filter(annotationMirror -> annotationMirror.getAnnotationType().equals(filterAnnotationAsTypeMirror)).flatMap(annotationMirror -> annotationMirror.getElementValues().entrySet().stream()).findFirst().map(entry -> Arrays.stream(((AnnotationValue)entry.getValue()).toString().replace("{", "").replace("}", "").replace(" ", "").split(",")).map(v -> v.substring(0, v.indexOf(".class"))).collect(Collectors.toList())).orElse(null);
    }

    public static final class Builder {
        ProcessingEnvironment processingEnvironment;
        RoundEnvironment roundEnvironment;
        TypeElement eventBusTypeElement;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public Builder roundEnvironment(RoundEnvironment roundEnvironment) {
            this.roundEnvironment = roundEnvironment;
            return this;
        }

        public Builder eventBusTypeElement(TypeElement eventBusTypeElement) {
            this.eventBusTypeElement = eventBusTypeElement;
            return this;
        }

        public FilterAnnotationValidator build() {
            return new FilterAnnotationValidator(this);
        }
    }
}

