/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.generator;

import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

public class EventLoadMetaDataGenerator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private EventBusMetaModel eventBusMetaModel;
    private TypeSpec.Builder typeSpec;

    private EventLoadMetaDataGenerator() {
    }

    private EventLoadMetaDataGenerator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.eventBusMetaModel = builder.eventBusMetaModel;
        this.typeSpec = builder.typeSpec;
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate() {
        MethodSpec.Builder loadEventMethod = MethodSpec.methodBuilder((String)"loadEventMetaData").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED});
        this.eventBusMetaModel.getEventMetaModels().forEach(eventMetaModel -> {
            String metaDataClassName = this.createEventMetaDataClassName(this.eventBusMetaModel.getEventBus().getClassName(), eventMetaModel.getEventName());
            loadEventMethod.addComment("", new Object[0]);
            loadEventMethod.addComment("----------------------------------------------------------------------", new Object[0]);
            loadEventMethod.addComment("", new Object[0]);
            loadEventMethod.addComment("handle $N", new Object[]{metaDataClassName});
            loadEventMethod.addComment("", new Object[0]);
            loadEventMethod.addStatement("super.putEventMetaData($S, new $N())", new Object[]{eventMetaModel.getEventInternalName(), metaDataClassName});
        });
        this.typeSpec.addMethod(loadEventMethod.build());
    }

    private String createEventMetaDataClassName(String eventBusClassName, String eventName) {
        return this.processorUtils.setFirstCharacterToUpperCase(this.createEventMetaDataVariableName(eventBusClassName, eventName));
    }

    private String createEventMetaDataVariableName(String eventBusClassName, String eventName) {
        return this.processorUtils.createFullClassName(eventBusClassName + "_" + eventName);
    }

    private void generateLoadEventMetaDataMethod(TypeSpec.Builder typeSpec) {
    }

    public static final class Builder {
        ProcessingEnvironment processingEnvironment;
        EventBusMetaModel eventBusMetaModel;
        TypeSpec.Builder typeSpec;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvirement) {
            this.processingEnvironment = processingEnvirement;
            return this;
        }

        public Builder eventBusMetaModel(EventBusMetaModel eventBusMetaModel) {
            this.eventBusMetaModel = eventBusMetaModel;
            return this;
        }

        public Builder typeSpec(TypeSpec.Builder typeSpec) {
            this.typeSpec = typeSpec;
            return this;
        }

        public EventLoadMetaDataGenerator build() {
            return new EventLoadMetaDataGenerator(this);
        }
    }
}

