/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.generator;

import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Event;
import com.github.mvp4g.mvp4g2.core.history.NavigationEventCommand;
import com.github.mvp4g.mvp4g2.core.history.annotation.History;
import com.github.mvp4g.mvp4g2.core.internal.eventbus.AbstractEventBus;
import com.github.mvp4g.mvp4g2.core.internal.eventbus.EventMetaData;
import com.github.mvp4g.mvp4g2.core.internal.ui.HandlerMetaData;
import com.github.mvp4g.mvp4g2.core.internal.ui.PresenterMetaData;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.EventMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.HandlerMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.HistoryMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.PresenterMetaModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.lang.model.element.Modifier;

public class EventHandlingMethodGenerator {
    private static final String EXECUTION_METHOD_PREFIX = "exec";
    private ProcessorUtils processorUtils;
    private TypeSpec.Builder typeSpec;
    private EventBusMetaModel eventBusMetaModel;
    private HistoryMetaModel historyMetaModel;
    private HandlerMetaModel handlerMetaModel;
    private PresenterMetaModel presenterMetaModel;

    private EventHandlingMethodGenerator() {
    }

    private EventHandlingMethodGenerator(Builder builder) {
        this.processorUtils = builder.processorUtils;
        this.typeSpec = builder.typeSpec;
        this.eventBusMetaModel = builder.eventBusMetaModel;
        this.historyMetaModel = builder.historyMetaModel;
        this.handlerMetaModel = builder.handlerMetaModel;
        this.presenterMetaModel = builder.presenterMetaModel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate() {
        this.eventBusMetaModel.getEventMetaModels().forEach(eventMetaModel -> {
            this.generateEventHandlingMethod((EventMetaModel)eventMetaModel);
            this.generateEventHandlingMethodForExecution((EventMetaModel)eventMetaModel);
        });
        this.generateStartEventHandlingMethod();
        this.generateInitHistoryEventHandlingMethod();
        this.generateNotFoundHistoryEventHandlingMethod();
    }

    private void generateEventHandlingMethod(EventMetaModel eventMetaModel) {
        MethodSpec.Builder eventHandlingMethod = MethodSpec.methodBuilder((String)eventMetaModel.getEventName()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        eventHandlingMethod.addStatement("int startLogDepth = $T.logDepth", new Object[]{ClassName.get(AbstractEventBus.class)});
        eventHandlingMethod.beginControlFlow("try", new Object[0]);
        eventMetaModel.getParameterMetaDataList().stream().map(parameterMetaData -> ParameterSpec.builder((TypeName)parameterMetaData.getType().getTypeName(), (String)parameterMetaData.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build()).forEach(arg_0 -> ((MethodSpec.Builder)eventHandlingMethod).addParameter(arg_0));
        if (eventMetaModel.isNavigationEvent()) {
            eventHandlingMethod.addCode("super.logAskingForConfirmation(++$T.logDepth, $S", new Object[]{ClassName.get(AbstractEventBus.class), eventMetaModel.getEventName()});
            eventMetaModel.getParameterMetaDataList().forEach(parameterMetaData -> eventHandlingMethod.addCode(", $N", new Object[]{parameterMetaData.getName()}));
            eventHandlingMethod.addCode(");\n", new Object[0]);
            MethodSpec.Builder executeMethod = MethodSpec.methodBuilder((String)"execute").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
            this.callEventExecMethod(executeMethod, eventMetaModel);
            TypeSpec confirmCommand = TypeSpec.anonymousClassBuilder((CodeBlock)CodeBlock.builder().add("this", new Object[0]).build()).addSuperinterface(NavigationEventCommand.class).addMethod(executeMethod.build()).build();
            eventHandlingMethod.addStatement("super.placeService.confirmEvent($L)", new Object[]{confirmCommand});
        } else {
            this.callEventExecMethod(eventHandlingMethod, eventMetaModel);
        }
        eventHandlingMethod.nextControlFlow("finally", new Object[0]);
        eventHandlingMethod.addStatement("$T.logDepth = startLogDepth", new Object[]{ClassName.get(AbstractEventBus.class)});
        eventHandlingMethod.endControlFlow();
        this.typeSpec.addMethod(eventHandlingMethod.build());
    }

    private void generateEventHandlingMethodForExecution(EventMetaModel eventMetaModel) {
        String sb = EXECUTION_METHOD_PREFIX + eventMetaModel.getEventName().substring(0, 1).toUpperCase() + eventMetaModel.getEventName().substring(1);
        MethodSpec.Builder eventHandlingMethod = MethodSpec.methodBuilder((String)sb).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        eventMetaModel.getParameterMetaDataList().stream().map(parameterMetaData -> ParameterSpec.builder((TypeName)parameterMetaData.getType().getTypeName(), (String)parameterMetaData.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build()).forEach(arg_0 -> ((MethodSpec.Builder)eventHandlingMethod).addParameter(arg_0));
        eventHandlingMethod.addCode("super.logEvent(++$T.logDepth, $S", new Object[]{ClassName.get(AbstractEventBus.class), eventMetaModel.getEventName()});
        eventMetaModel.getParameterMetaDataList().forEach(parameterMetaData -> eventHandlingMethod.addCode(", $N", new Object[]{parameterMetaData.getName()}));
        eventHandlingMethod.addCode(");\n", new Object[0]);
        eventHandlingMethod.addStatement("++$T.logDepth", new Object[]{ClassName.get(AbstractEventBus.class)});
        if (eventMetaModel.getParameterMetaDataList().size() > 0) {
            StringBuilder parameters = new StringBuilder();
            IntStream.range(0, eventMetaModel.getParameterMetaDataList().size()).forEachOrdered(i -> {
                parameters.append(eventMetaModel.getParameterMetaDataList().get(i).getName());
                if (i != eventMetaModel.getParameterMetaDataList().size() - 1) {
                    parameters.append(", ");
                }
            });
            eventHandlingMethod.beginControlFlow("if (!super.filterEvent($S, $L))", new Object[]{eventMetaModel.getEventName(), parameters});
        } else {
            eventHandlingMethod.beginControlFlow("if (!super.filterEvent($S))", new Object[]{eventMetaModel.getEventName()});
        }
        eventHandlingMethod.addStatement("return", new Object[0]);
        eventHandlingMethod.endControlFlow();
        eventHandlingMethod.addStatement("$T<$T> eventMetaData = super.getEventMetaData($S)", new Object[]{ClassName.get(EventMetaData.class), this.eventBusMetaModel.getEventBus().getTypeName(), eventMetaModel.getEventInternalName()});
        eventHandlingMethod.addStatement("super.createAndBindView(eventMetaData)", new Object[0]);
        eventHandlingMethod.addCode("super.bind(eventMetaData", new Object[0]);
        eventMetaModel.getParameterMetaDataList().forEach(parameterMetaData -> eventHandlingMethod.addCode(", $N", new Object[]{parameterMetaData.getName()}));
        eventHandlingMethod.addCode(");\n", new Object[0]);
        eventHandlingMethod.addStatement("super.activate(eventMetaData)", new Object[0]);
        eventHandlingMethod.addStatement("super.deactivate(eventMetaData)", new Object[0]);
        List<String> eventHandlerClasses = this.getAllEventHandlersForEvent(eventMetaModel);
        if (eventHandlerClasses != null) {
            eventHandlingMethod.addStatement("$T<$T<?>> handlers = null", new Object[]{ClassName.get(List.class), ClassName.get(HandlerMetaData.class)});
            eventHandlingMethod.addStatement("$T<$T<?, ?>> presenters = null", new Object[]{ClassName.get(List.class), ClassName.get(PresenterMetaData.class)});
            eventHandlingMethod.addStatement("$T<$T> listOfExecutedHandlers = new $T<>()", new Object[]{ClassName.get(List.class), ClassName.get(String.class), ClassName.get(ArrayList.class)});
            eventHandlerClasses.forEach(eventHandlerClass -> {
                eventHandlingMethod.addComment("handling: " + eventHandlerClass, new Object[0]);
                this.createEventHandlingMethod(eventHandlingMethod, eventMetaModel, (String)eventHandlerClass);
            });
            this.createPlaceServicePlaceCall(eventHandlingMethod, eventMetaModel);
        }
        this.typeSpec.addMethod(eventHandlingMethod.build());
    }

    private void generateStartEventHandlingMethod() {
        MethodSpec.Builder startEventHandlingMethod = MethodSpec.methodBuilder((String)"fireStartEvent").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        Optional<EventMetaModel> optional = this.eventBusMetaModel.getEventMetaModels().stream().filter(EventMetaModel::isStartEvent).findFirst();
        optional.ifPresent(eventMetaModel -> startEventHandlingMethod.addStatement("this.$L()", new Object[]{eventMetaModel.getEventName()}));
        this.typeSpec.addMethod(startEventHandlingMethod.build());
    }

    private void generateInitHistoryEventHandlingMethod() {
        MethodSpec.Builder initHistoryEventHandlingMethod = MethodSpec.methodBuilder((String)"fireInitHistoryEvent").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        Optional<EventMetaModel> optional = this.eventBusMetaModel.getEventMetaModels().stream().filter(EventMetaModel::isInitHistory).findFirst();
        if (optional.isPresent()) {
            initHistoryEventHandlingMethod.addStatement("this.$L()", new Object[]{optional.get().getEventName()});
        } else {
            initHistoryEventHandlingMethod.addStatement("assert false : $S", new Object[]{"no @InitHistory-event defined"});
        }
        this.typeSpec.addMethod(initHistoryEventHandlingMethod.build());
    }

    private void generateNotFoundHistoryEventHandlingMethod() {
        MethodSpec.Builder notFoundHistoryEventHandlingMethod = MethodSpec.methodBuilder((String)"fireNotFoundHistoryEvent").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        Optional<EventMetaModel> optional = this.eventBusMetaModel.getEventMetaModels().stream().filter(EventMetaModel::isNotFoundHistory).findFirst();
        if (optional.isPresent()) {
            notFoundHistoryEventHandlingMethod.addStatement("this.$L()", new Object[]{optional.get().getEventName()});
        } else {
            notFoundHistoryEventHandlingMethod.addStatement("assert false : $S", new Object[]{"no @NotFoundHistory-event defined"});
        }
        this.typeSpec.addMethod(notFoundHistoryEventHandlingMethod.build());
    }

    private void callEventExecMethod(MethodSpec.Builder method, EventMetaModel eventMetaModel) {
        String sb = EXECUTION_METHOD_PREFIX + eventMetaModel.getEventName().substring(0, 1).toUpperCase() + eventMetaModel.getEventName().substring(1);
        method.addCode(sb + "(", new Object[0]);
        IntStream.range(0, eventMetaModel.getParameterMetaDataList().size()).forEachOrdered(i -> {
            method.addCode(eventMetaModel.getParameterMetaDataList().get(i).getName(), new Object[0]);
            if (i != eventMetaModel.getParameterMetaDataList().size() - 1) {
                method.addCode(", ", new Object[0]);
            }
        });
        method.addCode(");\n", new Object[0]);
    }

    private List<String> getAllEventHandlersForEvent(EventMetaModel eventMetaModel) {
        ArrayList<String> listOfEventHandlers = new ArrayList<String>();
        eventMetaModel.getHandlers().stream().filter(s -> !listOfEventHandlers.contains(s.getClassName())).forEach(s -> listOfEventHandlers.add(s.getClassName()));
        this.handlerMetaModel.getHandlerKeys().stream().filter(s -> !listOfEventHandlers.contains(s)).map(s -> this.handlerMetaModel.getHandlerData((String)s)).forEach(handlerData -> handlerData.getHandledEvents().stream().filter(handledEvent -> handledEvent.equals(this.processorUtils.createEventHandlingMethodName(eventMetaModel.getEventInternalName()))).map(handledEvent -> handlerData.getHandler().getClassName()).forEach(listOfEventHandlers::add));
        this.presenterMetaModel.getPresenterKeys().stream().filter(s -> !listOfEventHandlers.contains(s)).map(handlerKey -> this.presenterMetaModel.getPresenterData((String)handlerKey)).forEach(presenterData -> presenterData.getHandledEvents().stream().filter(handledEvent -> handledEvent.equals(this.processorUtils.createEventHandlingMethodName(eventMetaModel.getEventInternalName()))).map(handledEvent -> presenterData.getPresenter().getClassName()).forEach(listOfEventHandlers::add));
        return listOfEventHandlers;
    }

    private void createEventHandlingMethod(MethodSpec.Builder method, EventMetaModel eventMetaModel, String eventHandlerClass) {
        boolean isPresenter = this.presenterMetaModel.getPresenterKeys().contains(eventHandlerClass);
        String handlerMetaDataMapName = isPresenter ? "presenterMetaDataMap" : "handlerMetaDataMap";
        String variableName = isPresenter ? "presenters" : "handlers";
        method.addStatement("$N = this.$N.get($S)", new Object[]{variableName, handlerMetaDataMapName, eventHandlerClass});
        this.generateEventHandlerCall(method, eventMetaModel, eventHandlerClass, isPresenter);
    }

    private void createPlaceServicePlaceCall(MethodSpec.Builder method, EventMetaModel eventMetaModel) {
        if (eventMetaModel.getHistoryConverter() == null) {
            return;
        }
        if (Event.NoHistoryConverter.class.getCanonicalName().equals(eventMetaModel.getHistoryConverter().getClassName())) {
            return;
        }
        String historyConverterType = this.historyMetaModel.getHistoryData(eventMetaModel.getHistoryConverter().getClassName()).getHistoryConverterType();
        method.beginControlFlow("if (listOfExecutedHandlers.size() > 0)", new Object[0]);
        switch (History.HistoryConverterType.valueOf((String)historyConverterType)) {
            case NONE: {
                method.addStatement("super.placeService.place($S, null, false)", new Object[]{eventMetaModel.getEventName()});
                break;
            }
            case SIMPLE: {
                method.addCode("super.placeService.place($S, (($L) super.placeService.getHistoryConverter($S)).convertToToken($S", new Object[]{eventMetaModel.getEventName(), eventMetaModel.getHistoryConverter().getClassName(), eventMetaModel.getEventName(), eventMetaModel.getEventName()});
                this.createSignatureForEventCall(method, eventMetaModel, true);
                method.addCode("), false);\n", new Object[0]);
                break;
            }
            case DEFAULT: {
                method.addCode("super.placeService.place($S, (($T) super.placeService.getHistoryConverter($S)).on$L(", new Object[]{eventMetaModel.getEventName(), ClassName.get((String)eventMetaModel.getHistoryConverter().getPackage(), (String)eventMetaModel.getHistoryConverter().getSimpleName(), (String[])new String[0]), eventMetaModel.getEventName(), eventMetaModel.getEventName().substring(0, 1).toUpperCase() + eventMetaModel.getEventName().substring(1)});
                this.createSignatureForEventCall(method, eventMetaModel, false);
                method.addCode("), false);\n", new Object[0]);
                break;
            }
        }
        method.endControlFlow();
    }

    private void generateEventHandlerCall(MethodSpec.Builder method, EventMetaModel eventMetaModel, String eventHandlerClass, boolean isPresenter) {
        String getHandlerMethodName = isPresenter ? "getPresenter" : "getHandler";
        String variableName = isPresenter ? "presenters" : "handlers";
        String methodName = isPresenter ? "executePresenter" : "executeHandler";
        MethodSpec.Builder passMethod = MethodSpec.methodBuilder((String)"execPass").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(EventMetaData.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}), (String)"eventMetaData", (Modifier[])new Modifier[0]).build()).addParameter(isPresenter ? ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(PresenterMetaData.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class), WildcardTypeName.subtypeOf(Object.class)}), (String)"metaData", (Modifier[])new Modifier[0]).build() : ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(HandlerMetaData.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}), (String)"metaData", (Modifier[])new Modifier[0]).build()).returns(Boolean.TYPE).addCode("return metaData.$N().pass(eventMetaData.getEventName()", new Object[]{getHandlerMethodName});
        this.createSignatureForEventCall(passMethod, eventMetaModel, true);
        passMethod.addCode(");\n", new Object[0]);
        MethodSpec.Builder execMethod = MethodSpec.methodBuilder((String)"execEventHandlingMethod").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(isPresenter ? ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(PresenterMetaData.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class), WildcardTypeName.subtypeOf(Object.class)}), (String)"metaData", (Modifier[])new Modifier[0]).build() : ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(HandlerMetaData.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}), (String)"metaData", (Modifier[])new Modifier[0]).build()).addCode("(($T) metaData.$N()).on$L(", new Object[]{ClassName.get((String)eventHandlerClass.substring(0, eventHandlerClass.lastIndexOf(".")), (String)eventHandlerClass.substring(eventHandlerClass.lastIndexOf(".") + 1), (String[])new String[0]), getHandlerMethodName, eventMetaModel.getEventName().substring(0, 1).toUpperCase() + eventMetaModel.getEventName().substring(1)});
        this.createSignatureForEventCall(execMethod, eventMetaModel, false);
        execMethod.addCode(");\n", new Object[0]);
        method.addStatement("super.$L(eventMetaData, $L, $L, $L, $L)", new Object[]{methodName, variableName, eventMetaModel.getHistoryConverter() == null || Event.NoHistoryConverter.class.getCanonicalName().equals(eventMetaModel.getHistoryConverter().getClassName()) ? "null" : "listOfExecutedHandlers", TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)(isPresenter ? ClassName.get(AbstractEventBus.ExecPresenter.class) : ClassName.get(AbstractEventBus.ExecHandler.class))).addMethod(passMethod.build()).addMethod(execMethod.build()).build(), eventMetaModel.getHistoryConverter() != null && !Event.NoHistoryConverter.class.getCanonicalName().equals(eventMetaModel.getHistoryConverter().getClassName())});
    }

    private void createSignatureForEventCall(MethodSpec.Builder method, EventMetaModel eventMetaModel, boolean leadingComma) {
        IntStream.range(0, eventMetaModel.getParameterMetaDataList().size()).forEachOrdered(i -> {
            if (i != 0) {
                method.addCode(", ", new Object[0]);
            } else if (leadingComma) {
                method.addCode(", ", new Object[0]);
            }
            method.addCode("$N", new Object[]{eventMetaModel.getParameterMetaDataList().get(i).getName()});
        });
    }

    public static final class Builder {
        ProcessorUtils processorUtils;
        TypeSpec.Builder typeSpec;
        EventBusMetaModel eventBusMetaModel;
        HistoryMetaModel historyMetaModel;
        HandlerMetaModel handlerMetaModel;
        PresenterMetaModel presenterMetaModel;

        public Builder processorUtils(ProcessorUtils processorUtils) {
            this.processorUtils = processorUtils;
            return this;
        }

        public Builder eventBusMetaModel(EventBusMetaModel eventBusMetaModel) {
            this.eventBusMetaModel = eventBusMetaModel;
            return this;
        }

        public Builder historyMetaModel(HistoryMetaModel historyMetaModel) {
            this.historyMetaModel = historyMetaModel;
            return this;
        }

        public Builder handlerMetaModel(HandlerMetaModel handlerMetaModel) {
            this.handlerMetaModel = handlerMetaModel;
            return this;
        }

        public Builder presenterMetaModel(PresenterMetaModel presenterMetaModel) {
            this.presenterMetaModel = presenterMetaModel;
            return this;
        }

        public Builder typeSpec(TypeSpec.Builder typeSpec) {
            this.typeSpec = typeSpec;
            return this;
        }

        public EventHandlingMethodGenerator build() {
            return new EventHandlingMethodGenerator(this);
        }
    }
}

