/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.validators.cpm;

import br.com.fluentvalidator.AbstractValidator;
import br.com.fluentvalidator.context.Error;
import br.com.fluentvalidator.function.FunctionBuilder;
import br.com.fluentvalidator.handler.HandlerInvalidField;
import br.com.fluentvalidator.predicate.ComparablePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.PredicateBuilder;
import br.com.fluentvalidator.predicate.StringPredicate;
import com.emv.qrcode.core.model.cpm.BERTLV;
import com.emv.qrcode.core.model.cpm.BERTag;
import com.emv.qrcode.model.cpm.AdditionalData;
import com.emv.qrcode.model.cpm.ApplicationTemplate;
import com.emv.qrcode.model.cpm.CommonDataTemplate;
import com.emv.qrcode.model.cpm.ConsumerPresentedMode;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

class CommonDataTemplateValidator
extends AbstractValidator<CommonDataTemplate> {
    private final Function<CommonDataTemplate, ConsumerPresentedMode> cpm = fn -> (ConsumerPresentedMode)this.getPropertyOnContext("cpm", ConsumerPresentedMode.class);

    CommonDataTemplateValidator() {
    }

    public void rules() {
        this.failFastRule();
        this.ruleFor(cdt -> cdt).must(this.validateDuplicateTags()).handlerInvalidField((HandlerInvalidField)new HandlerInvalidDuplicateTags()).critical();
        this.ruleFor("ApplicationDefinitionFileName", AdditionalData::getApplicationDefinitionFileName).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(BERTLV::getStringValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ApplicationDefinitionFileName value must be present").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue)).must(ComparablePredicate.betweenInclusive(BERTLV::getLength, (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(16))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ApplicationDefinitionFileName value size must be between five and sixteen").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("ApplicationLabel", AdditionalData::getApplicationLabel).must(ComparablePredicate.betweenInclusive(BERTLV::getLength, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(16))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ApplicationLabel value size must be between five and sixteen").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("ApplicationPAN", AdditionalData::getApplicationPAN).must(ComparablePredicate.lessThanOrEqual(BERTLV::getLength, (Comparable)Integer.valueOf(10))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ApplicationPAN value size must be less than or equal ten").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("ApplicationVersionNumber", AdditionalData::getApplicationVersionNumber).must(ComparablePredicate.equalTo(BERTLV::getLength, (Comparable)Integer.valueOf(2))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ApplicationVersionNumber value size must be equal two").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("CardholderName", AdditionalData::getCardholderName).must(ComparablePredicate.betweenInclusive(BERTLV::getLength, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(26))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("CardholderName value size must be between two and twenty-six").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("Last4DigitsOfPAN", AdditionalData::getLast4DigitsOfPAN).must(ComparablePredicate.equalTo(BERTLV::getLength, (Comparable)Integer.valueOf(2))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("Last4DigitsOfPAN value size must be equal two").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("LanguagePreference", AdditionalData::getLanguagePreference).must(ComparablePredicate.betweenInclusive(BERTLV::getLength, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("LanguagePreference value size must be between two and eight").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("Track2EquivalentData", AdditionalData::getTrack2EquivalentData).must(ComparablePredicate.lessThanOrEqual(BERTLV::getLength, (Comparable)Integer.valueOf(19))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("Track2EquivalentData value size must be less than or equal nineteen").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("TokenRequestorID", AdditionalData::getTokenRequestorID).must(ComparablePredicate.equalTo(BERTLV::getLength, (Comparable)Integer.valueOf(6))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TokenRequestorID value size must be equal six").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("PaymentAccountReference", AdditionalData::getPaymentAccountReference).must(ComparablePredicate.equalTo(BERTLV::getLength, (Comparable)Integer.valueOf(29))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PaymentAccountReference value size must be equal twenty-nine").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
    }

    private Predicate<CommonDataTemplate> validateDuplicateTags() {
        return PredicateBuilder.from((Predicate)LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).and(cdt -> {
            ConsumerPresentedMode consumerPresentedMode = this.cpm.apply((CommonDataTemplate)cdt);
            HashSet<BERTag> tags = new HashSet<BERTag>();
            for (ApplicationTemplate applicationTemplate : consumerPresentedMode.getApplicationTemplates()) {
                tags.addAll(applicationTemplate.getAdditionalDataMap().keySet());
            }
            for (BERTag tag : cdt.getAdditionalDataMap().keySet()) {
                if (!tags.contains(tag)) continue;
                return false;
            }
            return true;
        });
    }

    private final class HandlerInvalidDuplicateTags
    implements HandlerInvalidField<CommonDataTemplate> {
        private HandlerInvalidDuplicateTags() {
        }

        public Collection<Error> handle(CommonDataTemplate attemptedValue) {
            ConsumerPresentedMode consumerPresentedMode = (ConsumerPresentedMode)CommonDataTemplateValidator.this.cpm.apply(attemptedValue);
            HashSet<BERTag> tags = new HashSet<BERTag>();
            HashSet<Error> errors = new HashSet<Error>();
            for (ApplicationTemplate applicationTemplate : consumerPresentedMode.getApplicationTemplates()) {
                tags.addAll(applicationTemplate.getAdditionalDataMap().keySet());
            }
            for (Map.Entry entry : attemptedValue.getAdditionalDataMap().entrySet()) {
                BERTag tag = (BERTag)entry.getKey();
                BERTLV value = (BERTLV)entry.getValue();
                if (!tags.contains(tag)) continue;
                errors.add(Error.create((String)"tag", (String)"Duplicate definition tag on CommonDataTemplate", (String)tag.toString(), (Object)value.getStringValue()));
            }
            return new LinkedList<Error>(errors);
        }
    }
}

