/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.model.cpm;

import com.emv.qrcode.core.model.cpm.BERTLAlphanumeric;
import com.emv.qrcode.core.model.cpm.BERTLBinary;
import com.emv.qrcode.core.model.cpm.BERTLCompressedNumeric;
import com.emv.qrcode.core.model.cpm.BERTLNumeric;
import com.emv.qrcode.core.model.cpm.BERTLV;
import com.emv.qrcode.core.model.cpm.BERTag;
import com.emv.qrcode.model.cpm.constants.TagTransactionProcessingCodes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public abstract class AdditionalData
implements Serializable {
    private static final long serialVersionUID = -2275311356136693642L;
    private final Map<BERTag, BERTLV> additionalDataMap = new LinkedHashMap<BERTag, BERTLV>();

    public final void addAdditionalData(BERTLV bertlv) {
        if (Objects.nonNull(bertlv)) {
            this.additionalDataMap.put(bertlv.getTag(), bertlv);
        }
    }

    public final void setApplicationDefinitionFileName(String applicationDefinitionFileName) {
        this.addAdditionalData(new BERTLBinary(TagTransactionProcessingCodes.ID_APPLICATION_DEFINITION_FILE_NAME, applicationDefinitionFileName));
    }

    public final void setApplicationLabel(String applicationLabel) {
        this.addAdditionalData(new BERTLAlphanumeric(TagTransactionProcessingCodes.ID_APPLICATION_LABEL, applicationLabel));
    }

    public final void setTrack2EquivalentData(String track2EquivalentData) {
        this.addAdditionalData(new BERTLBinary(TagTransactionProcessingCodes.ID_TRACK_2_EQUIVALENT_DATA, track2EquivalentData));
    }

    public final void setApplicationPAN(String applicationPAN) {
        this.addAdditionalData(new BERTLCompressedNumeric(TagTransactionProcessingCodes.ID_APPLICATION_PAN, applicationPAN));
    }

    public final void setCardholderName(String cardholderName) {
        this.addAdditionalData(new BERTLAlphanumeric(TagTransactionProcessingCodes.ID_CARDHOLDER_NAME, cardholderName));
    }

    public final void setLanguagePreference(String languagePreference) {
        this.addAdditionalData(new BERTLAlphanumeric(TagTransactionProcessingCodes.ID_LANGUAGE_PREFERENCE, languagePreference));
    }

    public final void setIssuerURL(String issuerURL) {
        this.addAdditionalData(new BERTLAlphanumeric(TagTransactionProcessingCodes.ID_ISSUER_URL, issuerURL));
    }

    public final void setApplicationVersionNumber(String applicationVersionNumber) {
        this.addAdditionalData(new BERTLBinary(TagTransactionProcessingCodes.ID_APPLICATION_VERSION_NUMBER, applicationVersionNumber));
    }

    public final void setTokenRequestorID(String tokenRequestorID) {
        this.addAdditionalData(new BERTLNumeric(TagTransactionProcessingCodes.ID_TOKEN_REQUESTOR_ID, tokenRequestorID));
    }

    public final void setPaymentAccountReference(String paymentAccountReference) {
        this.addAdditionalData(new BERTLAlphanumeric(TagTransactionProcessingCodes.ID_PAYMENT_ACCOUNT_REFERENCE, paymentAccountReference));
    }

    public final void setLast4DigitsOfPAN(String last4DigitsOfPAN) {
        this.addAdditionalData(new BERTLNumeric(TagTransactionProcessingCodes.ID_LAST_4_DIGITS_OF_PAN, last4DigitsOfPAN));
    }

    public final void setCryptogramInformationData(String cryptogramInformationData) {
        this.addAdditionalData(new BERTLBinary(TagTransactionProcessingCodes.ID_CRYPTOGRAM_INFORMATION_DATA, cryptogramInformationData));
    }

    public final void setApplicationTransactionCounter(String applicationTransactionCounter) {
        this.addAdditionalData(new BERTLNumeric(TagTransactionProcessingCodes.ID_APPLICATION_TRANSACTION_COUNTER, applicationTransactionCounter));
    }

    public final void setApplicationCryptogram(String applicationCryptogram) {
        this.addAdditionalData(new BERTLBinary(TagTransactionProcessingCodes.ID_APPLICATION_CRYPTOGRAM, applicationCryptogram));
    }

    public final void setIssuerApplicationData(String issuerApplicationData) {
        this.addAdditionalData(new BERTLBinary(TagTransactionProcessingCodes.ID_ISSUER_APPLICATION_DATA, issuerApplicationData));
    }

    public final void setUnpredictableNumber(String unpredictableNumber) {
        this.addAdditionalData(new BERTLBinary(TagTransactionProcessingCodes.ID_UNPREDICTABLE_NUMBER, unpredictableNumber));
    }

    public final BERTLV getAdditionalData(BERTag tag) {
        return this.additionalDataMap.get(tag);
    }

    public final BERTLV getApplicationDefinitionFileName() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_APPLICATION_DEFINITION_FILE_NAME);
    }

    public final BERTLV getApplicationLabel() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_APPLICATION_LABEL);
    }

    public final BERTLV getTrack2EquivalentData() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_TRACK_2_EQUIVALENT_DATA);
    }

    public final BERTLV getApplicationPAN() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_APPLICATION_PAN);
    }

    public final BERTLV getCardholderName() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_CARDHOLDER_NAME);
    }

    public final BERTLV getLanguagePreference() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_LANGUAGE_PREFERENCE);
    }

    public final BERTLV getIssuerURL() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_ISSUER_URL);
    }

    public final BERTLV getApplicationVersionNumber() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_APPLICATION_VERSION_NUMBER);
    }

    public final BERTLV getTokenRequestorID() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_TOKEN_REQUESTOR_ID);
    }

    public final BERTLV getPaymentAccountReference() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_PAYMENT_ACCOUNT_REFERENCE);
    }

    public final BERTLV getLast4DigitsOfPAN() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_LAST_4_DIGITS_OF_PAN);
    }

    public final BERTLV getCryptogramInformationData() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_CRYPTOGRAM_INFORMATION_DATA);
    }

    public final BERTLV getApplicationTransactionCounter() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_APPLICATION_TRANSACTION_COUNTER);
    }

    public final BERTLV getApplicationCryptogram() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_APPLICATION_CRYPTOGRAM);
    }

    public final BERTLV getIssuerApplicationData() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_ISSUER_APPLICATION_DATA);
    }

    public final BERTLV getUnpredictableNumber() {
        return this.getAdditionalData(TagTransactionProcessingCodes.ID_UNPREDICTABLE_NUMBER);
    }

    public byte[] getBytes() throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            for (Map.Entry<BERTag, BERTLV> entry : this.additionalDataMap.entrySet()) {
                out.write(entry.getValue().getBytes());
            }
            Object object = out.toByteArray();
            return object;
        }
    }

    @Generated
    public Map<BERTag, BERTLV> getAdditionalDataMap() {
        return this.additionalDataMap;
    }
}

