/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.cpm;

import com.emv.qrcode.core.utils.BERUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

final class DecodeCpmIterator
implements Iterator<byte[]> {
    private Integer current = 0;
    private final Integer max;
    private final byte[] source;

    public DecodeCpmIterator(byte[] source) {
        this.max = source.length;
        this.source = source;
    }

    @Override
    public boolean hasNext() {
        if (this.current >= this.max) {
            return false;
        }
        Integer countBytesOfTag = BERUtils.countBytesOfTag(this.source, this.current);
        Integer countBytesOfLength = BERUtils.countBytesOfLength(this.source, this.current);
        Integer valueLength = BERUtils.valueOfLength(this.source, this.current);
        return this.current + countBytesOfTag + countBytesOfLength + valueLength <= this.max;
    }

    @Override
    public void forEachRemaining(Consumer<? super byte[]> action) {
        while (this.hasNext()) {
            action.accept((byte[])this.next());
        }
    }

    @Override
    public byte[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        byte[] value = BERUtils.chunk(this.source, this.current);
        this.current = this.current + value.length;
        return value;
    }
}

