/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.core.model.cpm;

import com.emv.qrcode.core.model.TLV;
import com.emv.qrcode.core.model.cpm.BERTag;
import com.emv.qrcode.core.utils.BERUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.codec.binary.Hex;

public abstract class BERTLV
implements TLV<BERTag, byte[]> {
    private static final long serialVersionUID = 1286326121944790325L;
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final BERTag EMPTY_TAG = new BERTag(EMPTY_BYTES);
    private BERTag tag;
    protected byte[] value;

    protected BERTLV(BERTag tag, byte[] value) {
        this.tag = tag;
        this.value = value;
    }

    protected BERTLV(byte[] tag, byte[] value) {
        this(new BERTag(tag), value);
    }

    @Override
    public BERTag getTag() {
        return this.tag;
    }

    public final void setTag(BERTag tag) {
        this.tag = Optional.ofNullable(tag).orElse(EMPTY_TAG);
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    public abstract String getStringValue();

    public final void setValue(byte[] value) {
        this.value = Optional.ofNullable(value).orElse(EMPTY_BYTES);
    }

    @Override
    public final Integer getLength() {
        return this.value.length;
    }

    public final String toHex() throws IOException {
        return Hex.encodeHexString((byte[])this.getBytes(), (boolean)false);
    }

    public byte[] getBytes() throws IOException {
        if (this.getLength() == 0) {
            return EMPTY_BYTES;
        }
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            stream.write(this.getTag().getBytes());
            stream.write(BERUtils.lengthOfValue(this.getLength()));
            stream.write(this.getValue());
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }
}

