/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.security;

import com.ibm.mqlight.api.impl.LogbackLogging;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.KeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PemFile {
    private static final Logger logger = LoggerFactory.getLogger(PemFile.class);
    private static final Pattern CERTIFICATE_PATTERN;
    private static final Pattern ENCRYPTED_KEY_PATTERN;
    private static final Pattern KEY_PATTERN;
    private final File pemFile;
    private String pemFileData = null;

    public PemFile(File pemFile) {
        this.pemFile = pemFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Certificate> getCertificates() throws CertificateException, IOException {
        String methodName = "getCertificates";
        logger.entry(this, "getCertificates");
        String fileData = this.getPemFileData();
        ArrayList<ByteBuf> certDataList = new ArrayList<ByteBuf>();
        Matcher m = CERTIFICATE_PATTERN.matcher(fileData);
        int start = 0;
        while (m.find(start)) {
            ByteBuf base64CertData = Unpooled.copiedBuffer((CharSequence)m.group(1), (Charset)Charset.forName("US-ASCII"));
            ByteBuf certData = Base64.decode((ByteBuf)base64CertData);
            base64CertData.release();
            certDataList.add(certData);
            start = m.end();
        }
        if (certDataList.isEmpty()) {
            CertificateException exception = new CertificateException("No certificates found in PEM file: " + this.pemFile);
            logger.throwing(this, "getCertificates", exception);
            throw exception;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        try {
            for (ByteBuf certData : certDataList) {
                certificates.add(cf.generateCertificate((InputStream)new ByteBufInputStream(certData)));
            }
        }
        finally {
            for (ByteBuf certData : certDataList) {
                certData.release();
            }
        }
        logger.exit(this, "getCertificates", certificates);
        return certificates;
    }

    public byte[] getPrivateKeyBytes() throws KeyException, IOException {
        String base64KeyDataStr;
        String methodName = "getPrivateKeyBytes";
        logger.entry(this, "getPrivateKeyBytes");
        String fileData = this.getPemFileData();
        Matcher m = KEY_PATTERN.matcher(fileData);
        if (m.find()) {
            base64KeyDataStr = m.group(1);
        } else {
            m = ENCRYPTED_KEY_PATTERN.matcher(fileData);
            if (m.find()) {
                base64KeyDataStr = m.group(1);
            } else {
                KeyException exception = new KeyException("Private key not found in PEM file: " + this.pemFile);
                logger.throwing(this, "getPrivateKeyBytes", exception);
                throw exception;
            }
        }
        ByteBuf base64KeyData = Unpooled.copiedBuffer((CharSequence)base64KeyDataStr, (Charset)Charset.forName("US-ASCII"));
        ByteBuf keyData = Base64.decode((ByteBuf)base64KeyData);
        base64KeyData.release();
        byte[] keyBytes = new byte[keyData.readableBytes()];
        keyData.readBytes(keyBytes).release();
        logger.exit(this, "getPrivateKeyBytes", keyBytes);
        return keyBytes;
    }

    public boolean containsEncryptedPrivateKey() throws IOException {
        String methodName = "containsEncryptedPrivateKey";
        logger.entry(this, "containsEncryptedPrivateKey");
        String fileData = this.getPemFileData();
        Matcher m = ENCRYPTED_KEY_PATTERN.matcher(fileData);
        boolean result = m.find();
        logger.exit(this, "containsEncryptedPrivateKey", result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPemFileData() throws IOException {
        String methodName = "getPemFileData";
        logger.entry(this, "getPemFileData");
        if (this.pemFileData != null) {
            logger.exit(this, "getPemFileData", this.pemFileData);
            return this.pemFileData;
        }
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this.pemFile), "US-ASCII");
        try {
            int ch;
            while ((ch = isr.read()) != -1) {
                sb.append((char)ch);
            }
        }
        catch (Throwable throwable) {
            try {
                isr.close();
            }
            catch (IOException e) {
                logger.data(this, "getPemFileData", "Failed to close input stream reader. Reason: ", e);
            }
            throw throwable;
        }
        try {
            isr.close();
        }
        catch (IOException e) {
            logger.data(this, "getPemFileData", "Failed to close input stream reader. Reason: ", e);
        }
        this.pemFileData = sb.toString();
        logger.exit(this, "getPemFileData", this.pemFileData);
        return this.pemFileData;
    }

    static {
        LogbackLogging.setup();
        CERTIFICATE_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);
        ENCRYPTED_KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*ENCRYPTED PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*ENCRYPTED PRIVATE\\s+KEY[^-]*-+", 2);
        KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);
    }
}

