/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.timer;

import com.ibm.mqlight.api.Promise;
import com.ibm.mqlight.api.impl.Component;
import com.ibm.mqlight.api.impl.timer.CancelResponse;
import com.ibm.mqlight.api.impl.timer.PopResponse;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class TimerPromiseImpl
implements Promise<Void> {
    private static final Logger logger = LoggerFactory.getLogger(TimerPromiseImpl.class);
    private final Component component;
    private final Object context;
    private final AtomicBoolean complete = new AtomicBoolean(false);

    public TimerPromiseImpl(Component component, Object context) {
        String methodName = "<init>";
        logger.entry(this, "<init>", component, context);
        this.component = component;
        this.context = context;
        logger.exit(this, "<init>");
    }

    @Override
    public void setFailure(Exception exception) throws IllegalStateException {
        String methodName = "setFailure";
        logger.entry(this, "setFailure", exception);
        if (this.complete.getAndSet(true)) {
            IllegalStateException ex = new IllegalStateException("Promise already completed");
            logger.throwing(this, "setFailure", ex);
            throw ex;
        }
        this.component.tell(new CancelResponse(this), this.component);
        logger.exit(this, "setFailure");
    }

    @Override
    public void setSuccess(Void result) throws IllegalStateException {
        String methodName = "setSuccess";
        logger.entry(this, "setSuccess", result);
        if (this.complete.getAndSet(true)) {
            IllegalStateException exception = new IllegalStateException("Promise already completed");
            logger.throwing(this, "setSuccess", exception);
            throw exception;
        }
        this.component.tell(new PopResponse(this), this.component);
        logger.exit(this, "setSuccess");
    }

    @Override
    public boolean isComplete() {
        return this.complete.get();
    }

    public Object getContext() {
        return this.context;
    }
}

