/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.network;

import com.ibm.mqlight.api.Promise;
import com.ibm.mqlight.api.impl.Component;
import com.ibm.mqlight.api.impl.ComponentImpl;
import com.ibm.mqlight.api.impl.network.WriteResponse;
import com.ibm.mqlight.api.logging.FFDCProbeId;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class NetworkWritePromiseImpl
implements Promise<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(NetworkWritePromiseImpl.class);
    private final AtomicBoolean complete = new AtomicBoolean(false);
    private final Component component;
    private final long amount;
    private final Object context;

    public NetworkWritePromiseImpl(Component component, int amount, Object context) {
        String methodName = "<init>";
        logger.entry(this, "<init>", component, context);
        this.component = component;
        this.amount = amount;
        this.context = context;
        logger.exit(this, "<init>");
    }

    @Override
    public boolean isComplete() {
        return this.complete.get();
    }

    @Override
    public void setSuccess(Boolean drained) throws IllegalStateException {
        String methodName = "setSuccess";
        logger.entry(this, "setSuccess", drained);
        if (this.complete.getAndSet(true)) {
            IllegalStateException ex = new IllegalStateException("Promise already completed");
            logger.ffdc("setSuccess", FFDCProbeId.PROBE_001, ex, this);
            logger.throwing(this, "setSuccess", ex);
            throw ex;
        }
        this.component.tell(new WriteResponse(this.context, this.amount, drained), ComponentImpl.NOBODY);
        logger.exit(this, "setSuccess");
    }

    @Override
    public void setFailure(Exception exception) throws IllegalStateException {
        String methodName = "setFailure";
        logger.entry(this, "setFailure", exception);
        if (this.complete.getAndSet(true)) {
            IllegalStateException ex = new IllegalStateException("Promise already completed");
            logger.ffdc("setFailure", FFDCProbeId.PROBE_002, ex, this);
            logger.throwing(this, "setFailure", ex);
            throw ex;
        }
        logger.exit(this, "setFailure");
    }
}

