/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.network;

import com.ibm.mqlight.api.NetworkException;
import com.ibm.mqlight.api.Promise;
import com.ibm.mqlight.api.SecurityException;
import com.ibm.mqlight.api.endpoint.Endpoint;
import com.ibm.mqlight.api.impl.LogbackLogging;
import com.ibm.mqlight.api.impl.network.ssl.SSLEngineFactory;
import com.ibm.mqlight.api.logging.FFDCProbeId;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import com.ibm.mqlight.api.network.NetworkChannel;
import com.ibm.mqlight.api.network.NetworkListener;
import com.ibm.mqlight.api.network.NetworkService;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public class NettyNetworkService
implements NetworkService {
    private static final Logger logger = LoggerFactory.getLogger(NettyNetworkService.class);
    private static final Object bootstrapSync;
    private static Bootstrap bootstrap;
    final Pattern disabledProtocolPattern = Pattern.compile("(SSLv2|SSLv3).*");
    final Pattern disabledCipherPattern = Pattern.compile(".*_(NULL|EXPORT|DES|RC4|MD5|PSK|SRP|CAMELLIA)_.*");
    private static int useCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(Endpoint endpoint, NetworkListener listener, Promise<NetworkChannel> promise) {
        String methodName = "connect";
        logger.entry(this, "connect", endpoint, listener, promise);
        try {
            final SSLEngine sslEngine = endpoint.useSsl() ? SSLEngineFactory.newInstance().createClientSSLEngine(endpoint.getSSLOptions(), endpoint.getHost(), endpoint.getPort()) : null;
            Object object = bootstrapSync;
            synchronized (object) {
                ChannelInitializer<SocketChannel> handler = endpoint.useSsl() ? new ChannelInitializer<SocketChannel>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void initChannel(SocketChannel ch) throws Exception {
                        Object object = bootstrapSync;
                        synchronized (object) {
                            ch.pipeline().addFirst(new ChannelHandler[]{new SslHandler(sslEngine)});
                            ch.pipeline().addLast(new ChannelHandler[]{new NettyInboundHandler(ch)});
                        }
                    }
                } : new ChannelInitializer<SocketChannel>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void initChannel(SocketChannel ch) throws Exception {
                        Object object = bootstrapSync;
                        synchronized (object) {
                            ch.pipeline().addLast(new ChannelHandler[]{new NettyInboundHandler(ch)});
                        }
                    }
                };
                Bootstrap bootstrap = NettyNetworkService.getBootstrap(endpoint.useSsl(), (ChannelHandler)handler);
                ChannelFuture f = bootstrap.connect(endpoint.getHost(), endpoint.getPort());
                f.addListener((GenericFutureListener)new ConnectListener(endpoint, f, promise, listener));
            }
        }
        catch (KeyManagementException | NoSuchAlgorithmException | SSLException e) {
            if (e.getCause() == null) {
                promise.setFailure(new java.lang.SecurityException(e.getMessage(), e));
            }
            promise.setFailure(new java.lang.SecurityException(e.getCause().getMessage(), e.getCause()));
        }
        logger.exit(this, "connect");
    }

    private static synchronized Bootstrap getBootstrap(boolean secure, ChannelHandler handler) {
        Bootstrap result;
        String methodName = "getBootstrap";
        logger.entry("getBootstrap", secure);
        if (++useCount == 1) {
            NioEventLoopGroup workerGroup = new NioEventLoopGroup();
            bootstrap = new Bootstrap();
            bootstrap.group((EventLoopGroup)workerGroup);
            bootstrap.channel(NioSocketChannel.class);
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)30000);
            bootstrap.handler(handler);
        }
        if (secure) {
            result = bootstrap.clone();
            result.handler(handler);
        } else {
            result = bootstrap;
        }
        logger.exit("getBootstrap", result);
        return result;
    }

    private static synchronized void decrementUseCount() {
        String methodName = "decrementUseCount";
        logger.entry("decrementUseCount");
        if (--useCount <= 0) {
            if (bootstrap != null) {
                bootstrap.group().shutdownGracefully(0L, 500L, TimeUnit.MILLISECONDS);
            }
            bootstrap = null;
            useCount = 0;
        }
        logger.exit("decrementUseCount");
    }

    public boolean awaitTermination(long timeout) throws InterruptedException {
        String methodName = "awaitTermination";
        logger.entry("awaitTermination");
        boolean terminated = bootstrap != null ? bootstrap.group().awaitTermination(timeout, TimeUnit.SECONDS) : true;
        logger.exit("awaitTermination", terminated);
        return terminated;
    }

    static {
        LogbackLogging.setup();
        bootstrapSync = new Object();
        useCount = 0;
    }

    protected class ConnectListener
    implements GenericFutureListener<ChannelFuture> {
        private final Logger logger = LoggerFactory.getLogger(ConnectListener.class);
        private final Endpoint endpoint;
        private final Promise<NetworkChannel> promise;
        private final NetworkListener listener;

        protected ConnectListener(Endpoint endpoint, ChannelFuture cFuture, Promise<NetworkChannel> promise, NetworkListener listener) {
            String methodName = "<init>";
            this.logger.entry(this, "<init>", endpoint, cFuture, promise, listener);
            this.endpoint = endpoint;
            this.promise = promise;
            this.listener = listener;
            this.logger.exit(this, "<init>");
        }

        public void operationComplete(ChannelFuture cFuture) throws Exception {
            String methodName = "operationComplete";
            this.logger.entry(this, "operationComplete", cFuture);
            if (cFuture.isSuccess()) {
                NettyInboundHandler handler = (NettyInboundHandler)cFuture.channel().pipeline().last();
                handler.setListener(this.listener);
                this.promise.setSuccess(handler);
            } else {
                String message = cFuture.cause().getMessage();
                if (message == null || message.length() == 0) {
                    message = cFuture.cause() instanceof UnresolvedAddressException ? "unresolved address " + this.endpoint.getURI() : cFuture.cause().toString() + " for address " + this.endpoint.getURI();
                }
                NetworkException cause = new NetworkException("Could not connect to server: " + message, cFuture.cause());
                this.promise.setFailure(cause);
                NettyNetworkService.decrementUseCount();
            }
            this.logger.exit(this, "operationComplete");
        }
    }

    static class NettyInboundHandler
    extends ChannelInboundHandlerAdapter
    implements NetworkChannel {
        private static final Logger logger = LoggerFactory.getLogger(NettyInboundHandler.class);
        private final SocketChannel channel;
        private NetworkListener listener = null;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        final LinkedList<WriteRequest> pendingWrites = new LinkedList();
        boolean writeInProgress = false;
        private Object context;

        protected NettyInboundHandler(SocketChannel channel) {
            String methodName = "<init>";
            logger.entry(this, "<init>", channel);
            this.channel = channel;
            logger.exit(this, "<init>");
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            String methodName = "channelRead";
            logger.entry(this, "channelRead", ctx, msg);
            if (this.listener != null) {
                this.listener.onRead(this, (ByteBuf)msg);
            }
            logger.exit(this, "channelRead");
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            String methodName = "exceptionCaught";
            logger.entry(this, "exceptionCaught", cause);
            try {
                Exception exception;
                ctx.close();
                if (cause instanceof Exception) {
                    exception = (Exception)cause;
                } else {
                    logger.ffdc("exceptionCaught", FFDCProbeId.PROBE_001, cause, this);
                    exception = new NetworkException("unexpected error", cause);
                }
                while (exception.getCause() != null && exception.getCause() instanceof Exception && exception.getCause().getCause() != null) {
                    exception = (Exception)exception.getCause();
                }
                String condition = exception.getClass().getName();
                if (condition.contains("javax.net.ssl.") || condition.contains("java.security.") || condition.contains("com.ibm.jsse2.") || condition.contains("sun.security.")) {
                    exception = new SecurityException(exception.getMessage(), exception.getCause());
                }
                if (this.listener != null) {
                    this.listener.onError(this, exception);
                }
            }
            catch (Throwable t) {
                logger.error("An exception was thrown during exceptionCaught() handling of " + cause.toString(), t);
            }
            logger.exit(this, "exceptionCaught");
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            String methodName = "channelWritabilityChanged";
            logger.entry(this, "channelWritabilityChanged", ctx);
            this.doWrite();
            logger.exit(this, "channelWritabilityChanged");
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            String methodName = "channelInactive";
            logger.entry(this, "channelInactive", ctx);
            boolean alreadyClosed = this.closed.getAndSet(true);
            if (!alreadyClosed) {
                if (this.listener != null) {
                    this.listener.onClose(this);
                }
                NettyNetworkService.decrementUseCount();
            }
            logger.exit(this, "channelInactive");
        }

        protected void setListener(NetworkListener listener) {
            String methodName = "setListener";
            logger.entry(this, "setListener", listener);
            this.listener = listener;
            logger.exit(this, "setListener");
        }

        @Override
        public void close(final Promise<Void> nwfuture) {
            String methodName = "close";
            logger.entry(this, "close", nwfuture);
            boolean alreadyClosed = this.closed.getAndSet(true);
            if (!alreadyClosed) {
                ChannelFuture f = this.channel.disconnect();
                if (nwfuture != null) {
                    f.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            nwfuture.setSuccess(null);
                            NettyNetworkService.decrementUseCount();
                        }
                    });
                } else {
                    NettyNetworkService.decrementUseCount();
                }
            } else if (nwfuture != null) {
                nwfuture.setSuccess(null);
            }
            logger.exit(this, "close");
        }

        @Override
        public void write(ByteBuffer buffer, Promise<Boolean> promise) {
            String methodName = "write";
            logger.entry(this, "write", buffer, promise);
            this.doWrite(buffer, promise);
            logger.exit(this, "write");
        }

        private void processWriteRequest(WriteRequest toProcess) {
            String methodName = "processWriteRequest";
            logger.entry(this, "processWriteRequest", toProcess);
            final Promise<Boolean> writeCompletePromise = toProcess.promise;
            logger.data(this, "processWriteRequest", "writeAndFlush {}", toProcess);
            ChannelFuture f = this.channel.writeAndFlush((Object)toProcess.buffer);
            f.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(ChannelFuture future) throws Exception {
                    boolean havePendingWrites;
                    LinkedList<WriteRequest> linkedList = NettyInboundHandler.this.pendingWrites;
                    synchronized (linkedList) {
                        NettyInboundHandler.this.writeInProgress = false;
                        havePendingWrites = !NettyInboundHandler.this.pendingWrites.isEmpty();
                    }
                    logger.data(this, "processWriteRequest", "doWrite (complete)");
                    writeCompletePromise.setSuccess(!havePendingWrites);
                    NettyInboundHandler.this.doWrite();
                }
            });
            logger.exit(this, "processWriteRequest");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWrite() {
            String methodName = "doWrite";
            logger.entry(this, "doWrite");
            WriteRequest toProcess = null;
            LinkedList<WriteRequest> linkedList = this.pendingWrites;
            synchronized (linkedList) {
                if (!this.writeInProgress && this.channel.isWritable() && !this.pendingWrites.isEmpty()) {
                    toProcess = this.pendingWrites.removeFirst();
                    this.writeInProgress = true;
                }
            }
            if (toProcess != null) {
                this.processWriteRequest(toProcess);
            }
            logger.exit(this, "doWrite");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuf copyBuffer(ByteBufAllocator alloc, ByteBuffer buffer) {
            int length = buffer.remaining();
            int position = buffer.position();
            ByteBuf buf = alloc.directBuffer(length);
            try {
                buf.writeBytes(buffer);
            }
            finally {
                buffer.position(position);
            }
            return buf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWrite(ByteBuffer buffer, Promise<Boolean> promise) {
            String methodName = "doWrite";
            logger.entry(this, "doWrite", buffer, promise);
            WriteRequest toProcess = null;
            LinkedList<WriteRequest> linkedList = this.pendingWrites;
            synchronized (linkedList) {
                if (!this.writeInProgress && this.channel.isWritable()) {
                    if (this.pendingWrites.isEmpty()) {
                        toProcess = new WriteRequest(this.copyBuffer(this.channel.alloc(), buffer), promise);
                    } else {
                        this.pendingWrites.addLast(new WriteRequest(this.copyBuffer(this.channel.alloc(), buffer), promise));
                        toProcess = this.pendingWrites.removeFirst();
                    }
                    this.writeInProgress = true;
                } else {
                    this.pendingWrites.addLast(new WriteRequest(this.copyBuffer(this.channel.alloc(), buffer), promise));
                }
            }
            if (toProcess != null) {
                this.processWriteRequest(toProcess);
            }
            logger.exit(this, "doWrite");
        }

        @Override
        public synchronized void setContext(Object context) {
            this.context = context;
        }

        @Override
        public synchronized Object getContext() {
            return this.context;
        }

        private static class WriteRequest {
            protected final ByteBuf buffer;
            protected final Promise<Boolean> promise;

            protected WriteRequest(ByteBuf buffer, Promise<Boolean> promise) {
                this.buffer = buffer;
                this.promise = promise;
            }
        }
    }
}

