/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.callback;

import com.ibm.mqlight.api.Promise;
import com.ibm.mqlight.api.impl.Component;
import com.ibm.mqlight.api.impl.ComponentImpl;
import com.ibm.mqlight.api.impl.callback.CallbackExceptionNotification;
import com.ibm.mqlight.api.impl.callback.FlushResponse;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class CallbackPromiseImpl
implements Promise<Void> {
    private static final Logger logger = LoggerFactory.getLogger(CallbackPromiseImpl.class);
    private final AtomicBoolean complete = new AtomicBoolean(false);
    private final Component component;
    private final boolean ignoreSuccess;

    public CallbackPromiseImpl(Component component, boolean ignoreSuccess) {
        String methodName = "<init>";
        logger.entry(this, "<init>", component, ignoreSuccess);
        this.component = component;
        this.ignoreSuccess = ignoreSuccess;
        logger.exit(this, "<init>");
    }

    @Override
    public boolean isComplete() {
        return this.complete.get();
    }

    @Override
    public void setFailure(Exception exception) throws IllegalStateException {
        String methodName = "setFailure";
        logger.entry(this, "setFailure", exception);
        if (this.complete.getAndSet(true)) {
            IllegalStateException ex = new IllegalStateException("Promise already completed");
            logger.throwing(this, "setFailure", ex);
            throw ex;
        }
        this.component.tell(new CallbackExceptionNotification(exception), this.component);
        logger.exit(this, "setFailure");
    }

    @Override
    public void setSuccess(Void result) throws IllegalStateException {
        String methodName = "setSuccess";
        logger.entry(this, "setSuccess", result);
        if (this.complete.getAndSet(true)) {
            IllegalStateException ex = new IllegalStateException("Promise already completed");
            logger.throwing(this, "setSuccess", ex);
            throw ex;
        }
        if (!this.ignoreSuccess) {
            this.component.tell(new FlushResponse(), ComponentImpl.NOBODY);
        }
        logger.exit(this, "setSuccess");
    }
}

