/*
 * Decompiled with CFR 0.152.
 */
package moxy.viewstate;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import moxy.MvpView;
import moxy.viewstate.ViewCommand;
import moxy.viewstate.ViewCommands;

public abstract class MvpViewState<View extends MvpView> {
    protected ViewCommands<View> mViewCommands = new ViewCommands();
    protected Set<View> mViews = Collections.newSetFromMap(new WeakHashMap());
    protected Set<View> mInRestoreState = Collections.newSetFromMap(new WeakHashMap());
    protected Map<View, Set<ViewCommand<View>>> mViewStates = new WeakHashMap<View, Set<ViewCommand<View>>>();

    protected void restoreState(View view, Set<ViewCommand<View>> currentState) {
        if (this.mViewCommands.isEmpty()) {
            return;
        }
        this.mViewCommands.reapply(view, currentState);
    }

    protected Boolean hasNotView() {
        return this.mViews == null || this.mViews.isEmpty();
    }

    public void attachView(View view) {
        if (view == null) {
            throw new IllegalArgumentException("Mvp view must be not null");
        }
        boolean isViewAdded = this.mViews.add(view);
        if (!isViewAdded) {
            return;
        }
        this.mInRestoreState.add(view);
        Set<ViewCommand<Object>> currentState = this.mViewStates.get(view);
        currentState = currentState == null ? Collections.emptySet() : currentState;
        this.restoreState(view, currentState);
        this.mViewStates.remove(view);
        this.mInRestoreState.remove(view);
    }

    public void detachView(View view) {
        this.mViews.remove(view);
        this.mInRestoreState.remove(view);
        Set currentState = Collections.newSetFromMap(new WeakHashMap());
        currentState.addAll(this.mViewCommands.getCurrentState());
        this.mViewStates.put(view, currentState);
    }

    public void destroyView(View view) {
        this.mViewStates.remove(view);
    }

    public Set<View> getViews() {
        return this.mViews;
    }

    public boolean isInRestoreState(View view) {
        return this.mInRestoreState.contains(view);
    }
}

