/*
 * Decompiled with CFR 0.152.
 */
package moxy.compiler;

import com.squareup.javapoet.JavaFile;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moxy.InjectViewState;
import moxy.compiler.AnnotationRule;
import moxy.compiler.ElementProcessor;
import moxy.compiler.JavaFilesGenerator;
import moxy.compiler.PresenterInjectorRules;
import moxy.compiler.presenterbinder.InjectPresenterProcessor;
import moxy.compiler.presenterbinder.PresenterBinderClassGenerator;
import moxy.compiler.viewstate.ViewInterfaceProcessor;
import moxy.compiler.viewstate.ViewStateClassGenerator;
import moxy.compiler.viewstateprovider.InjectViewStateProcessor;
import moxy.compiler.viewstateprovider.ViewStateProviderClassGenerator;
import moxy.presenter.InjectPresenter;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JJ\u0010\u0015\u001a\u00020\r\"\b\b\u0000\u0010\u0016*\u00020\u0017\"\u0004\b\u0001\u0010\u00182\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00180\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001fH\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040!H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0004H\u0002J\b\u0010*\u001a\u00020\rH\u0002J\u001e\u0010+\u001a\u00020\b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016JZ\u0010.\u001a\u00020\r\"\b\b\u0000\u0010\u0016*\u00020\u0017\"\u0004\b\u0001\u0010\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u000201002\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00180\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001fH\u0002J\u0010\u00102\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0007\u0010\t\u00a8\u00064"}, d2={"Lmoxy/compiler/MvpCompiler;", "Ljavax/annotation/processing/AbstractProcessor;", "()V", "defaultStrategy", "", "getDefaultStrategy", "()Ljava/lang/String;", "isIsolatingProcessingEnabled", "", "()Z", "isIsolatingProcessingEnabled$delegate", "Lkotlin/Lazy;", "checkInjectors", "", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "annotationRule", "Lmoxy/compiler/AnnotationRule;", "createSourceFile", "file", "Lcom/squareup/javapoet/JavaFile;", "generateCode", "E", "Ljavax/lang/model/element/Element;", "R", "element", "kind", "Ljavax/lang/model/element/ElementKind;", "processor", "Lmoxy/compiler/ElementProcessor;", "classGenerator", "Lmoxy/compiler/JavaFilesGenerator;", "getSupportedAnnotationTypes", "", "getSupportedOptions", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "init", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "isOptionEnabled", "option", "printIsolatingOptionWarning", "process", "annotations", "Ljavax/lang/model/element/TypeElement;", "processInjectors", "clazz", "Ljava/lang/Class;", "", "throwableProcess", "Companion", "moxy-compiler"})
public final class MvpCompiler
extends AbstractProcessor {
    private final Lazy isIsolatingProcessingEnabled$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ MvpCompiler this$0;

        public final boolean invoke() {
            return MvpCompiler.access$isOptionEnabled(this.this$0, "moxyEnableIsolatingProcessing");
        }
        {
            this.this$0 = mvpCompiler;
            super(0);
        }
    }));
    private static final String OPTION_DISABLE_EMPTY_STRATEGY_CHECK = "disableEmptyStrategyCheck";
    @NotNull
    public static final String DEFAULT_MOXY_STRATEGY = "defaultMoxyStrategy";
    private static final String OPTION_ENABLE_EMPTY_STRATEGY_HELPER = "enableEmptyStrategyHelper";
    private static final String OPTION_ENABLE_ISOLATING_PROCESSING = "moxyEnableIsolatingProcessing";
    private static Messager messager;
    private static Types typeUtils;
    private static Elements elementUtils;
    private static Map<String, String> options;
    @NotNull
    public static final Companion Companion;

    private final String getDefaultStrategy() {
        Map<String, String> map = options;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
        }
        return map.get(DEFAULT_MOXY_STRATEGY);
    }

    @Override
    public synchronized void init(@NotNull ProcessingEnvironment processingEnv) {
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        super.init(processingEnv);
        Messager messager = processingEnv.getMessager();
        Intrinsics.checkNotNullExpressionValue((Object)messager, (String)"processingEnv.messager");
        MvpCompiler.messager = messager;
        Types types = processingEnv.getTypeUtils();
        Intrinsics.checkNotNullExpressionValue((Object)types, (String)"processingEnv.typeUtils");
        typeUtils = types;
        Elements elements = processingEnv.getElementUtils();
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"processingEnv.elementUtils");
        elementUtils = elements;
        Map<String, String> map = processingEnv.getOptions();
        Intrinsics.checkNotNullExpressionValue(map, (String)"processingEnv.options");
        options = map;
        if (this.isIsolatingProcessingEnabled()) {
            this.printIsolatingOptionWarning();
        }
    }

    private final void printIsolatingOptionWarning() {
        Messager messager = MvpCompiler.messager;
        if (messager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "Isolating annotation processor mode was enabled for Moxy.\nThis option is experimental for now. We are pretty sure it should work correctly but we are not 100% sure.\n\nIf you'll notice problems after enabling this option such as:\n- ViewState is not being recompiled after you change your view interface\n- ViewState is not being compiled at all after you change your view interface\nplease report them using https://github.com/moxy-community/Moxy/issues/new.\n\nIn the same time to fix such problems while waiting for fix on our side you have two options:\n1. Just disable isolating mode. This will switch Moxy processor back to aggregating mode, so incremental compilation will be ok. This could hurt you compilation time a bit, hopefully not very much.\n2. Do clean build. This will force Gradle to recompile all generated sources from scratch. Sure, this is also bad for compilation time.\n\nHopefully we will enable isolating annotation processor mode by default after several releases. ");
    }

    @Override
    @NotNull
    public Set<String> getSupportedOptions() {
        String gradleIncrementalProcessingTypeOption = (this.isIsolatingProcessingEnabled() ? IncrementalAnnotationProcessorType.ISOLATING : IncrementalAnnotationProcessorType.AGGREGATING).getProcessorOption();
        Object[] objectArray = new String[5];
        objectArray[0] = OPTION_ENABLE_EMPTY_STRATEGY_HELPER;
        objectArray[1] = DEFAULT_MOXY_STRATEGY;
        objectArray[2] = OPTION_DISABLE_EMPTY_STRATEGY_CHECK;
        objectArray[3] = OPTION_ENABLE_ISOLATING_PROCESSING;
        String string = gradleIncrementalProcessingTypeOption;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gradleIncrementalProcessingTypeOption");
        objectArray[4] = string;
        return SetsKt.setOf((Object[])objectArray);
    }

    private final boolean isIsolatingProcessingEnabled() {
        Lazy lazy = this.isIsolatingProcessingEnabled$delegate;
        MvpCompiler mvpCompiler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<String> getSupportedAnnotationTypes() {
        return SetsKt.setOf((Object[])new String[]{InjectPresenter.class.getCanonicalName(), InjectViewState.class.getCanonicalName()});
    }

    @Override
    @NotNull
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latestSupported();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sourceVersion), (String)"latestSupported()");
        return sourceVersion;
    }

    @Override
    public boolean process(@NotNull Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        if (annotations.isEmpty()) {
            return false;
        }
        try {
            return this.throwableProcess(roundEnv);
        }
        catch (RuntimeException e) {
            Messager messager = MvpCompiler.messager;
            if (messager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
            }
            messager.printMessage(Diagnostic.Kind.OTHER, "Moxy compilation has failed. Could you copy stack trace above and write us (or open an issue on Github)?");
            e.printStackTrace();
            Messager messager2 = MvpCompiler.messager;
            if (messager2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
            }
            messager2.printMessage(Diagnostic.Kind.ERROR, "Moxy compilation failed; see the compiler error output for details (" + e + ')');
            return true;
        }
    }

    private final boolean throwableProcess(RoundEnvironment roundEnv) {
        this.checkInjectors(roundEnv, new PresenterInjectorRules(ElementKind.FIELD, Modifier.PUBLIC, Modifier.DEFAULT));
        InjectViewStateProcessor injectViewStateProcessor = new InjectViewStateProcessor();
        ViewStateProviderClassGenerator viewStateProviderClassGenerator = new ViewStateProviderClassGenerator();
        InjectPresenterProcessor injectPresenterProcessor = new InjectPresenterProcessor();
        PresenterBinderClassGenerator presenterBinderClassGenerator = new PresenterBinderClassGenerator();
        boolean disableEmptyStrategyCheck = this.isOptionEnabled(OPTION_DISABLE_EMPTY_STRATEGY_CHECK);
        boolean enableEmptyStrategyHelper = this.isOptionEnabled(OPTION_ENABLE_EMPTY_STRATEGY_HELPER);
        ViewInterfaceProcessor viewInterfaceProcessor = new ViewInterfaceProcessor(disableEmptyStrategyCheck, enableEmptyStrategyHelper, this.getDefaultStrategy());
        ViewStateClassGenerator viewStateClassGenerator = new ViewStateClassGenerator();
        this.processInjectors(roundEnv, InjectViewState.class, ElementKind.CLASS, injectViewStateProcessor, viewStateProviderClassGenerator);
        this.processInjectors(roundEnv, InjectPresenter.class, ElementKind.FIELD, injectPresenterProcessor, presenterBinderClassGenerator);
        for (TypeElement usedView : injectViewStateProcessor.getUsedViews()) {
            this.generateCode(usedView, ElementKind.INTERFACE, viewInterfaceProcessor, viewStateClassGenerator);
        }
        JavaFile migrationHelper = viewInterfaceProcessor.makeMigrationHelper();
        if (migrationHelper != null) {
            this.createSourceFile(migrationHelper);
        }
        return true;
    }

    private final boolean isOptionEnabled(String option) {
        boolean bl;
        Map<String, String> map = options;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
        }
        String string = map.get(option);
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            bl = Boolean.parseBoolean(string2);
        } else {
            bl = false;
        }
        return bl;
    }

    private final void checkInjectors(RoundEnvironment roundEnv, AnnotationRule annotationRule) {
        for (Element element : roundEnv.getElementsAnnotatedWith(InjectPresenter.class)) {
            annotationRule.checkAnnotation(element);
        }
        String string = annotationRule.getErrorStack();
        if (string != null) {
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() > 0) {
                Messager messager = MvpCompiler.messager;
                if (messager == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
                }
                messager.printMessage(Diagnostic.Kind.ERROR, string);
            }
        }
    }

    private final <E extends Element, R> void processInjectors(RoundEnvironment roundEnv, Class<? extends Annotation> clazz, ElementKind kind, ElementProcessor<E, R> processor, JavaFilesGenerator<R> classGenerator) {
        Iterator<? extends Element> iterator = roundEnv.getElementsAnnotatedWith(clazz).iterator();
        while (iterator.hasNext()) {
            Element element;
            Element element2 = element = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"element");
            if (element2.getKind() != kind) {
                Messager messager = MvpCompiler.messager;
                if (messager == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
                }
                messager.printMessage(Diagnostic.Kind.ERROR, element + " must be " + kind.name() + ", or do not annotate it with @" + clazz.getSimpleName(), element);
            }
            this.generateCode(element, kind, processor, classGenerator);
        }
    }

    private final <E extends Element, R> void generateCode(Element element, ElementKind kind, ElementProcessor<E, R> processor, JavaFilesGenerator<R> classGenerator) {
        if (element.getKind() != kind) {
            Messager messager = MvpCompiler.messager;
            if (messager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
            }
            messager.printMessage(Diagnostic.Kind.ERROR, element + " must be " + kind.name(), element);
        }
        Element element2 = element;
        if (element2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type E");
        }
        R r = processor.process(element2);
        if (r == null) {
            return;
        }
        R result = r;
        Iterator<JavaFile> iterator = classGenerator.generate(result).iterator();
        while (iterator.hasNext()) {
            JavaFile file;
            JavaFile javaFile = file = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)javaFile, (String)"file");
            this.createSourceFile(javaFile);
        }
    }

    private final void createSourceFile(JavaFile file) {
        try {
            ProcessingEnvironment processingEnvironment = this.processingEnv;
            Intrinsics.checkNotNullExpressionValue((Object)processingEnvironment, (String)"processingEnv");
            file.writeTo(processingEnvironment.getFiler());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ boolean access$isOptionEnabled(MvpCompiler $this, String option) {
        return $this.isOptionEnabled(option);
    }

    @JvmStatic
    @NotNull
    public static final Messager getMessager() {
        Companion companion = Companion;
        Messager messager = MvpCompiler.messager;
        if (messager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
        }
        return messager;
    }

    @JvmStatic
    @NotNull
    public static final Types getTypeUtils() {
        Companion companion = Companion;
        Types types = typeUtils;
        if (types == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeUtils");
        }
        return types;
    }

    @JvmStatic
    @NotNull
    public static final Elements getElementUtils() {
        Companion companion = Companion;
        Elements elements = elementUtils;
        if (elements == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"elementUtils");
        }
        return elements;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f8G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R<\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00152\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0015@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR&\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u001b8G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lmoxy/compiler/MvpCompiler$Companion;", "", "()V", "DEFAULT_MOXY_STRATEGY", "", "OPTION_DISABLE_EMPTY_STRATEGY_CHECK", "OPTION_ENABLE_EMPTY_STRATEGY_HELPER", "OPTION_ENABLE_ISOLATING_PROCESSING", "<set-?>", "Ljavax/lang/model/util/Elements;", "elementUtils", "getElementUtils", "()Ljavax/lang/model/util/Elements;", "setElementUtils", "(Ljavax/lang/model/util/Elements;)V", "Ljavax/annotation/processing/Messager;", "messager", "getMessager", "()Ljavax/annotation/processing/Messager;", "setMessager", "(Ljavax/annotation/processing/Messager;)V", "", "options", "getOptions", "()Ljava/util/Map;", "setOptions", "(Ljava/util/Map;)V", "Ljavax/lang/model/util/Types;", "typeUtils", "getTypeUtils", "()Ljavax/lang/model/util/Types;", "setTypeUtils", "(Ljavax/lang/model/util/Types;)V", "moxy-compiler"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Messager getMessager() {
            Messager messager = messager;
            if (messager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
            }
            return messager;
        }

        private final void setMessager(Messager messager) {
            MvpCompiler.messager = messager;
        }

        @JvmStatic
        @NotNull
        public final Types getTypeUtils() {
            Types types = typeUtils;
            if (types == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeUtils");
            }
            return types;
        }

        private final void setTypeUtils(Types types) {
            typeUtils = types;
        }

        @JvmStatic
        @NotNull
        public final Elements getElementUtils() {
            Elements elements = elementUtils;
            if (elements == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"elementUtils");
            }
            return elements;
        }

        private final void setElementUtils(Elements elements) {
            elementUtils = elements;
        }

        @NotNull
        public final Map<String, String> getOptions() {
            Map map = options;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            return map;
        }

        private final void setOptions(Map<String, String> map) {
            options = map;
        }

        private Companion() {
        }

        public static final /* synthetic */ Messager access$getMessager$p(Companion $this) {
            return $this.getMessager();
        }

        public static final /* synthetic */ void access$setMessager$p(Companion $this, Messager messager) {
            $this.setMessager(messager);
        }

        public static final /* synthetic */ Types access$getTypeUtils$p(Companion $this) {
            return $this.getTypeUtils();
        }

        public static final /* synthetic */ void access$setTypeUtils$p(Companion $this, Types types) {
            $this.setTypeUtils(types);
        }

        public static final /* synthetic */ Elements access$getElementUtils$p(Companion $this) {
            return $this.getElementUtils();
        }

        public static final /* synthetic */ void access$setElementUtils$p(Companion $this, Elements elements) {
            $this.setElementUtils(elements);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

