/*
 * Decompiled with CFR 0.152.
 */
package moxy.compiler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

public abstract class AnnotationRule {
    protected final ElementKind validKind;
    protected final Set<Modifier> validModifiers;
    protected StringBuilder errorBuilder;

    public AnnotationRule(ElementKind validKind, Modifier ... validModifiers) {
        if (validModifiers == null || validModifiers.length == 0) {
            throw new RuntimeException("Valid modifiers cant be empty or null.");
        }
        this.validKind = validKind;
        this.validModifiers = new HashSet<Modifier>(Arrays.asList(validModifiers));
        this.errorBuilder = new StringBuilder();
    }

    public abstract void checkAnnotation(Element var1);

    public String getErrorStack() {
        return this.errorBuilder.toString();
    }

    protected String validModifiersToString() {
        if (this.validModifiers.size() > 1) {
            StringBuilder result = new StringBuilder("one of [");
            boolean addSeparator = false;
            for (Modifier validModifier : this.validModifiers) {
                if (addSeparator) {
                    result.append(", ");
                }
                addSeparator = true;
                result.append(validModifier.toString());
            }
            result.append("]");
            return result.toString();
        }
        return (Object)((Object)this.validModifiers.iterator().next()) + ".";
    }
}

