/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.AddingCriteriaToSegmentsRequest;
import io.swagger.client.model.AddingCriteriaToSegmentsResponse;
import io.swagger.client.model.CreatingANewSegmentRequest;
import io.swagger.client.model.CreatingANewSegmentResponse;
import io.swagger.client.model.DeletingASegmentResponse;
import io.swagger.client.model.GettingSegmentDetailsResponse;
import io.swagger.client.model.GettingSegmentSubscribersResponse;
import io.swagger.client.model.GettingSegmentsResponse;
import io.swagger.client.model.UpdatingASegmentRequest;
import io.swagger.client.model.UpdatingASegmentResponse;
import io.swagger.client.model.UpdatingSegmentCriteriaRequest;
import io.swagger.client.model.UpdatingSegmentCriteriaResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SegmentsApi {
    private ApiClient apiClient;

    public SegmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SegmentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addingCriteriaToSegmentsCall(String format, String mailingListID, String apikey, String segmentID, AddingCriteriaToSegmentsRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AddingCriteriaToSegmentsRequest localVarPostBody = body;
        String localVarPath = "/lists/{MailingListID}/segments/{SegmentID}/criteria/add.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString())).replaceAll("\\{SegmentID\\}", this.apiClient.escapeString(segmentID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addingCriteriaToSegmentsValidateBeforeCall(String format, String mailingListID, String apikey, String segmentID, AddingCriteriaToSegmentsRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling addingCriteriaToSegments(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling addingCriteriaToSegments(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling addingCriteriaToSegments(Async)");
        }
        if (segmentID == null) {
            throw new ApiException("Missing the required parameter 'segmentID' when calling addingCriteriaToSegments(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addingCriteriaToSegments(Async)");
        }
        Call call = this.addingCriteriaToSegmentsCall(format, mailingListID, apikey, segmentID, body, progressListener, progressRequestListener);
        return call;
    }

    public AddingCriteriaToSegmentsResponse addingCriteriaToSegments(String format, String mailingListID, String apikey, String segmentID, AddingCriteriaToSegmentsRequest body) throws ApiException {
        ApiResponse<AddingCriteriaToSegmentsResponse> resp = this.addingCriteriaToSegmentsWithHttpInfo(format, mailingListID, apikey, segmentID, body);
        return resp.getData();
    }

    public ApiResponse<AddingCriteriaToSegmentsResponse> addingCriteriaToSegmentsWithHttpInfo(String format, String mailingListID, String apikey, String segmentID, AddingCriteriaToSegmentsRequest body) throws ApiException {
        Call call = this.addingCriteriaToSegmentsValidateBeforeCall(format, mailingListID, apikey, segmentID, body, null, null);
        Type localVarReturnType = new TypeToken<AddingCriteriaToSegmentsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addingCriteriaToSegmentsAsync(String format, String mailingListID, String apikey, String segmentID, AddingCriteriaToSegmentsRequest body, final ApiCallback<AddingCriteriaToSegmentsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addingCriteriaToSegmentsValidateBeforeCall(format, mailingListID, apikey, segmentID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AddingCriteriaToSegmentsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call creatingANewSegmentCall(String format, String mailingListID, String apikey, CreatingANewSegmentRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreatingANewSegmentRequest localVarPostBody = body;
        String localVarPath = "/lists/{MailingListID}/segments/create.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call creatingANewSegmentValidateBeforeCall(String format, String mailingListID, String apikey, CreatingANewSegmentRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling creatingANewSegment(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling creatingANewSegment(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling creatingANewSegment(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling creatingANewSegment(Async)");
        }
        Call call = this.creatingANewSegmentCall(format, mailingListID, apikey, body, progressListener, progressRequestListener);
        return call;
    }

    public CreatingANewSegmentResponse creatingANewSegment(String format, String mailingListID, String apikey, CreatingANewSegmentRequest body) throws ApiException {
        ApiResponse<CreatingANewSegmentResponse> resp = this.creatingANewSegmentWithHttpInfo(format, mailingListID, apikey, body);
        return resp.getData();
    }

    public ApiResponse<CreatingANewSegmentResponse> creatingANewSegmentWithHttpInfo(String format, String mailingListID, String apikey, CreatingANewSegmentRequest body) throws ApiException {
        Call call = this.creatingANewSegmentValidateBeforeCall(format, mailingListID, apikey, body, null, null);
        Type localVarReturnType = new TypeToken<CreatingANewSegmentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call creatingANewSegmentAsync(String format, String mailingListID, String apikey, CreatingANewSegmentRequest body, final ApiCallback<CreatingANewSegmentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.creatingANewSegmentValidateBeforeCall(format, mailingListID, apikey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreatingANewSegmentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deletingASegmentCall(String format, String mailingListID, String apikey, String segmentID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{MailingListID}/segments/{SegmentID}/delete.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString())).replaceAll("\\{SegmentID\\}", this.apiClient.escapeString(segmentID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deletingASegmentValidateBeforeCall(String format, String mailingListID, String apikey, String segmentID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling deletingASegment(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling deletingASegment(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling deletingASegment(Async)");
        }
        if (segmentID == null) {
            throw new ApiException("Missing the required parameter 'segmentID' when calling deletingASegment(Async)");
        }
        Call call = this.deletingASegmentCall(format, mailingListID, apikey, segmentID, progressListener, progressRequestListener);
        return call;
    }

    public DeletingASegmentResponse deletingASegment(String format, String mailingListID, String apikey, String segmentID) throws ApiException {
        ApiResponse<DeletingASegmentResponse> resp = this.deletingASegmentWithHttpInfo(format, mailingListID, apikey, segmentID);
        return resp.getData();
    }

    public ApiResponse<DeletingASegmentResponse> deletingASegmentWithHttpInfo(String format, String mailingListID, String apikey, String segmentID) throws ApiException {
        Call call = this.deletingASegmentValidateBeforeCall(format, mailingListID, apikey, segmentID, null, null);
        Type localVarReturnType = new TypeToken<DeletingASegmentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deletingASegmentAsync(String format, String mailingListID, String apikey, String segmentID, final ApiCallback<DeletingASegmentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deletingASegmentValidateBeforeCall(format, mailingListID, apikey, segmentID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeletingASegmentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gettingSegmentDetailsCall(String format, String mailingListID, String segmentID, String apikey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{MailingListID}/segments/{SegmentID}/details.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString())).replaceAll("\\{SegmentID\\}", this.apiClient.escapeString(segmentID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gettingSegmentDetailsValidateBeforeCall(String format, String mailingListID, String segmentID, String apikey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingSegmentDetails(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling gettingSegmentDetails(Async)");
        }
        if (segmentID == null) {
            throw new ApiException("Missing the required parameter 'segmentID' when calling gettingSegmentDetails(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingSegmentDetails(Async)");
        }
        Call call = this.gettingSegmentDetailsCall(format, mailingListID, segmentID, apikey, progressListener, progressRequestListener);
        return call;
    }

    public GettingSegmentDetailsResponse gettingSegmentDetails(String format, String mailingListID, String segmentID, String apikey) throws ApiException {
        ApiResponse<GettingSegmentDetailsResponse> resp = this.gettingSegmentDetailsWithHttpInfo(format, mailingListID, segmentID, apikey);
        return resp.getData();
    }

    public ApiResponse<GettingSegmentDetailsResponse> gettingSegmentDetailsWithHttpInfo(String format, String mailingListID, String segmentID, String apikey) throws ApiException {
        Call call = this.gettingSegmentDetailsValidateBeforeCall(format, mailingListID, segmentID, apikey, null, null);
        Type localVarReturnType = new TypeToken<GettingSegmentDetailsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gettingSegmentDetailsAsync(String format, String mailingListID, String segmentID, String apikey, final ApiCallback<GettingSegmentDetailsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gettingSegmentDetailsValidateBeforeCall(format, mailingListID, segmentID, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingSegmentDetailsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gettingSegmentSubscribersCall(String format, String mailingListID, String segmentID, String apikey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{MailingListID}/segments/{SegmentID}/members.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString())).replaceAll("\\{SegmentID\\}", this.apiClient.escapeString(segmentID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gettingSegmentSubscribersValidateBeforeCall(String format, String mailingListID, String segmentID, String apikey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingSegmentSubscribers(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling gettingSegmentSubscribers(Async)");
        }
        if (segmentID == null) {
            throw new ApiException("Missing the required parameter 'segmentID' when calling gettingSegmentSubscribers(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingSegmentSubscribers(Async)");
        }
        Call call = this.gettingSegmentSubscribersCall(format, mailingListID, segmentID, apikey, progressListener, progressRequestListener);
        return call;
    }

    public GettingSegmentSubscribersResponse gettingSegmentSubscribers(String format, String mailingListID, String segmentID, String apikey) throws ApiException {
        ApiResponse<GettingSegmentSubscribersResponse> resp = this.gettingSegmentSubscribersWithHttpInfo(format, mailingListID, segmentID, apikey);
        return resp.getData();
    }

    public ApiResponse<GettingSegmentSubscribersResponse> gettingSegmentSubscribersWithHttpInfo(String format, String mailingListID, String segmentID, String apikey) throws ApiException {
        Call call = this.gettingSegmentSubscribersValidateBeforeCall(format, mailingListID, segmentID, apikey, null, null);
        Type localVarReturnType = new TypeToken<GettingSegmentSubscribersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gettingSegmentSubscribersAsync(String format, String mailingListID, String segmentID, String apikey, final ApiCallback<GettingSegmentSubscribersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gettingSegmentSubscribersValidateBeforeCall(format, mailingListID, segmentID, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingSegmentSubscribersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gettingSegmentsCall(String format, String mailingListID, String apikey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{MailingListID}/segments.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gettingSegmentsValidateBeforeCall(String format, String mailingListID, String apikey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingSegments(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling gettingSegments(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingSegments(Async)");
        }
        Call call = this.gettingSegmentsCall(format, mailingListID, apikey, progressListener, progressRequestListener);
        return call;
    }

    public GettingSegmentsResponse gettingSegments(String format, String mailingListID, String apikey) throws ApiException {
        ApiResponse<GettingSegmentsResponse> resp = this.gettingSegmentsWithHttpInfo(format, mailingListID, apikey);
        return resp.getData();
    }

    public ApiResponse<GettingSegmentsResponse> gettingSegmentsWithHttpInfo(String format, String mailingListID, String apikey) throws ApiException {
        Call call = this.gettingSegmentsValidateBeforeCall(format, mailingListID, apikey, null, null);
        Type localVarReturnType = new TypeToken<GettingSegmentsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gettingSegmentsAsync(String format, String mailingListID, String apikey, final ApiCallback<GettingSegmentsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gettingSegmentsValidateBeforeCall(format, mailingListID, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingSegmentsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updatingASegmentCall(String format, String mailingListID, String apikey, String segmentID, UpdatingASegmentRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdatingASegmentRequest localVarPostBody = body;
        String localVarPath = "/lists/{MailingListID}/segments/{SegmentID}/update.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString())).replaceAll("\\{SegmentID\\}", this.apiClient.escapeString(segmentID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updatingASegmentValidateBeforeCall(String format, String mailingListID, String apikey, String segmentID, UpdatingASegmentRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling updatingASegment(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling updatingASegment(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling updatingASegment(Async)");
        }
        if (segmentID == null) {
            throw new ApiException("Missing the required parameter 'segmentID' when calling updatingASegment(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatingASegment(Async)");
        }
        Call call = this.updatingASegmentCall(format, mailingListID, apikey, segmentID, body, progressListener, progressRequestListener);
        return call;
    }

    public UpdatingASegmentResponse updatingASegment(String format, String mailingListID, String apikey, String segmentID, UpdatingASegmentRequest body) throws ApiException {
        ApiResponse<UpdatingASegmentResponse> resp = this.updatingASegmentWithHttpInfo(format, mailingListID, apikey, segmentID, body);
        return resp.getData();
    }

    public ApiResponse<UpdatingASegmentResponse> updatingASegmentWithHttpInfo(String format, String mailingListID, String apikey, String segmentID, UpdatingASegmentRequest body) throws ApiException {
        Call call = this.updatingASegmentValidateBeforeCall(format, mailingListID, apikey, segmentID, body, null, null);
        Type localVarReturnType = new TypeToken<UpdatingASegmentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updatingASegmentAsync(String format, String mailingListID, String apikey, String segmentID, UpdatingASegmentRequest body, final ApiCallback<UpdatingASegmentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updatingASegmentValidateBeforeCall(format, mailingListID, apikey, segmentID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdatingASegmentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updatingSegmentCriteriaCall(String format, String mailingListID, String apikey, String segmentID, Double criteriaID, UpdatingSegmentCriteriaRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdatingSegmentCriteriaRequest localVarPostBody = body;
        String localVarPath = "/lists/{MailingListID}/segments/{SegmentID}/criteria/{CriteriaID}/update.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString())).replaceAll("\\{SegmentID\\}", this.apiClient.escapeString(segmentID.toString())).replaceAll("\\{CriteriaID\\}", this.apiClient.escapeString(criteriaID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updatingSegmentCriteriaValidateBeforeCall(String format, String mailingListID, String apikey, String segmentID, Double criteriaID, UpdatingSegmentCriteriaRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling updatingSegmentCriteria(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling updatingSegmentCriteria(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling updatingSegmentCriteria(Async)");
        }
        if (segmentID == null) {
            throw new ApiException("Missing the required parameter 'segmentID' when calling updatingSegmentCriteria(Async)");
        }
        if (criteriaID == null) {
            throw new ApiException("Missing the required parameter 'criteriaID' when calling updatingSegmentCriteria(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatingSegmentCriteria(Async)");
        }
        Call call = this.updatingSegmentCriteriaCall(format, mailingListID, apikey, segmentID, criteriaID, body, progressListener, progressRequestListener);
        return call;
    }

    public UpdatingSegmentCriteriaResponse updatingSegmentCriteria(String format, String mailingListID, String apikey, String segmentID, Double criteriaID, UpdatingSegmentCriteriaRequest body) throws ApiException {
        ApiResponse<UpdatingSegmentCriteriaResponse> resp = this.updatingSegmentCriteriaWithHttpInfo(format, mailingListID, apikey, segmentID, criteriaID, body);
        return resp.getData();
    }

    public ApiResponse<UpdatingSegmentCriteriaResponse> updatingSegmentCriteriaWithHttpInfo(String format, String mailingListID, String apikey, String segmentID, Double criteriaID, UpdatingSegmentCriteriaRequest body) throws ApiException {
        Call call = this.updatingSegmentCriteriaValidateBeforeCall(format, mailingListID, apikey, segmentID, criteriaID, body, null, null);
        Type localVarReturnType = new TypeToken<UpdatingSegmentCriteriaResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updatingSegmentCriteriaAsync(String format, String mailingListID, String apikey, String segmentID, Double criteriaID, UpdatingSegmentCriteriaRequest body, final ApiCallback<UpdatingSegmentCriteriaResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updatingSegmentCriteriaValidateBeforeCall(format, mailingListID, apikey, segmentID, criteriaID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdatingSegmentCriteriaResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

