/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.AbTestCampaignSummaryResponse;
import io.swagger.client.model.ActivityByLocationResponse;
import io.swagger.client.model.CampaignSummaryResponse;
import io.swagger.client.model.CloningAnExistingCampaignResponse;
import io.swagger.client.model.CreatingADraftCampaignRequest;
import io.swagger.client.model.CreatingADraftCampaignResponse;
import io.swagger.client.model.DeletingACampaignResponse;
import io.swagger.client.model.GetAllCampaignsResponse;
import io.swagger.client.model.GetCampaignStatisticsWithPagingFilteredResponse;
import io.swagger.client.model.GetCampaignsByPageAndPagesizeResponse;
import io.swagger.client.model.GetCampaignsByPageResponse;
import io.swagger.client.model.GettingAllYourSendersResponse;
import io.swagger.client.model.GettingCampaignDetailsResponse;
import io.swagger.client.model.GettingSenderDetailsResponse;
import io.swagger.client.model.LinkActivityResponse;
import io.swagger.client.model.SchedulingACampaignRequest;
import io.swagger.client.model.SchedulingACampaignResponse;
import io.swagger.client.model.SendingACampaignResponse;
import io.swagger.client.model.TestingACampaignRequest;
import io.swagger.client.model.TestingACampaignResponse;
import io.swagger.client.model.UnschedulingACampaignResponse;
import io.swagger.client.model.UpdatingADraftCampaignRequest;
import io.swagger.client.model.UpdatingADraftCampaignResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class CampaignsApi {
    private ApiClient apiClient;

    public CampaignsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CampaignsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call aBTestCampaignSummaryCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns/{CampaignID}/view_ab_summary.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call aBTestCampaignSummaryValidateBeforeCall(String format, String apikey, String campaignID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling aBTestCampaignSummary(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling aBTestCampaignSummary(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling aBTestCampaignSummary(Async)");
        }
        Call call = this.aBTestCampaignSummaryCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;
    }

    public AbTestCampaignSummaryResponse aBTestCampaignSummary(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<AbTestCampaignSummaryResponse> resp = this.aBTestCampaignSummaryWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    public ApiResponse<AbTestCampaignSummaryResponse> aBTestCampaignSummaryWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        Call call = this.aBTestCampaignSummaryValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<AbTestCampaignSummaryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call aBTestCampaignSummaryAsync(String format, String apikey, String campaignID, final ApiCallback<AbTestCampaignSummaryResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.aBTestCampaignSummaryValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AbTestCampaignSummaryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call activityByLocationCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns/{CampaignID}/stats/countries.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call activityByLocationValidateBeforeCall(String format, String apikey, String campaignID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling activityByLocation(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling activityByLocation(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling activityByLocation(Async)");
        }
        Call call = this.activityByLocationCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;
    }

    public ActivityByLocationResponse activityByLocation(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<ActivityByLocationResponse> resp = this.activityByLocationWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    public ApiResponse<ActivityByLocationResponse> activityByLocationWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        Call call = this.activityByLocationValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<ActivityByLocationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call activityByLocationAsync(String format, String apikey, String campaignID, final ApiCallback<ActivityByLocationResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.activityByLocationValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ActivityByLocationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call campaignSummaryCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns/{CampaignID}/view_summary.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call campaignSummaryValidateBeforeCall(String format, String apikey, String campaignID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling campaignSummary(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling campaignSummary(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling campaignSummary(Async)");
        }
        Call call = this.campaignSummaryCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;
    }

    public CampaignSummaryResponse campaignSummary(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<CampaignSummaryResponse> resp = this.campaignSummaryWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    public ApiResponse<CampaignSummaryResponse> campaignSummaryWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        Call call = this.campaignSummaryValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<CampaignSummaryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call campaignSummaryAsync(String format, String apikey, String campaignID, final ApiCallback<CampaignSummaryResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.campaignSummaryValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CampaignSummaryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call cloningAnExistingCampaignCall(String format, String campaignID, String apikey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns/{CampaignID}/clone.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call cloningAnExistingCampaignValidateBeforeCall(String format, String campaignID, String apikey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling cloningAnExistingCampaign(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling cloningAnExistingCampaign(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling cloningAnExistingCampaign(Async)");
        }
        Call call = this.cloningAnExistingCampaignCall(format, campaignID, apikey, progressListener, progressRequestListener);
        return call;
    }

    public CloningAnExistingCampaignResponse cloningAnExistingCampaign(String format, String campaignID, String apikey) throws ApiException {
        ApiResponse<CloningAnExistingCampaignResponse> resp = this.cloningAnExistingCampaignWithHttpInfo(format, campaignID, apikey);
        return resp.getData();
    }

    public ApiResponse<CloningAnExistingCampaignResponse> cloningAnExistingCampaignWithHttpInfo(String format, String campaignID, String apikey) throws ApiException {
        Call call = this.cloningAnExistingCampaignValidateBeforeCall(format, campaignID, apikey, null, null);
        Type localVarReturnType = new TypeToken<CloningAnExistingCampaignResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call cloningAnExistingCampaignAsync(String format, String campaignID, String apikey, final ApiCallback<CloningAnExistingCampaignResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.cloningAnExistingCampaignValidateBeforeCall(format, campaignID, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CloningAnExistingCampaignResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call creatingADraftCampaignCall(String format, String apikey, CreatingADraftCampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreatingADraftCampaignRequest localVarPostBody = body;
        String localVarPath = "/campaigns/create.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call creatingADraftCampaignValidateBeforeCall(String format, String apikey, CreatingADraftCampaignRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling creatingADraftCampaign(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling creatingADraftCampaign(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling creatingADraftCampaign(Async)");
        }
        Call call = this.creatingADraftCampaignCall(format, apikey, body, progressListener, progressRequestListener);
        return call;
    }

    public CreatingADraftCampaignResponse creatingADraftCampaign(String format, String apikey, CreatingADraftCampaignRequest body) throws ApiException {
        ApiResponse<CreatingADraftCampaignResponse> resp = this.creatingADraftCampaignWithHttpInfo(format, apikey, body);
        return resp.getData();
    }

    public ApiResponse<CreatingADraftCampaignResponse> creatingADraftCampaignWithHttpInfo(String format, String apikey, CreatingADraftCampaignRequest body) throws ApiException {
        Call call = this.creatingADraftCampaignValidateBeforeCall(format, apikey, body, null, null);
        Type localVarReturnType = new TypeToken<CreatingADraftCampaignResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call creatingADraftCampaignAsync(String format, String apikey, CreatingADraftCampaignRequest body, final ApiCallback<CreatingADraftCampaignResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.creatingADraftCampaignValidateBeforeCall(format, apikey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreatingADraftCampaignResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deletingACampaignCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns/{CampaignID}/delete.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deletingACampaignValidateBeforeCall(String format, String apikey, String campaignID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling deletingACampaign(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling deletingACampaign(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling deletingACampaign(Async)");
        }
        Call call = this.deletingACampaignCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;
    }

    public DeletingACampaignResponse deletingACampaign(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<DeletingACampaignResponse> resp = this.deletingACampaignWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    public ApiResponse<DeletingACampaignResponse> deletingACampaignWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        Call call = this.deletingACampaignValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<DeletingACampaignResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deletingACampaignAsync(String format, String apikey, String campaignID, final ApiCallback<DeletingACampaignResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deletingACampaignValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeletingACampaignResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAllCampaignsCall(String format, String apikey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllCampaignsValidateBeforeCall(String format, String apikey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling getAllCampaigns(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling getAllCampaigns(Async)");
        }
        Call call = this.getAllCampaignsCall(format, apikey, progressListener, progressRequestListener);
        return call;
    }

    public GetAllCampaignsResponse getAllCampaigns(String format, String apikey) throws ApiException {
        ApiResponse<GetAllCampaignsResponse> resp = this.getAllCampaignsWithHttpInfo(format, apikey);
        return resp.getData();
    }

    public ApiResponse<GetAllCampaignsResponse> getAllCampaignsWithHttpInfo(String format, String apikey) throws ApiException {
        Call call = this.getAllCampaignsValidateBeforeCall(format, apikey, null, null);
        Type localVarReturnType = new TypeToken<GetAllCampaignsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllCampaignsAsync(String format, String apikey, final ApiCallback<GetAllCampaignsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllCampaignsValidateBeforeCall(format, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetAllCampaignsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCampaignStatisticsWithPagingFilteredCall(String format, String apikey, String campaignID, String type, String page, String pageSize, String from, String to, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns/{CampaignID}/stats/{Type}.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString())).replaceAll("\\{Type\\}", this.apiClient.escapeString(type.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "Page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "PageSize", pageSize));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "From", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "To", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCampaignStatisticsWithPagingFilteredValidateBeforeCall(String format, String apikey, String campaignID, String type, String page, String pageSize, String from, String to, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling getCampaignStatisticsWithPagingFiltered(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling getCampaignStatisticsWithPagingFiltered(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling getCampaignStatisticsWithPagingFiltered(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getCampaignStatisticsWithPagingFiltered(Async)");
        }
        Call call = this.getCampaignStatisticsWithPagingFilteredCall(format, apikey, campaignID, type, page, pageSize, from, to, progressListener, progressRequestListener);
        return call;
    }

    public GetCampaignStatisticsWithPagingFilteredResponse getCampaignStatisticsWithPagingFiltered(String format, String apikey, String campaignID, String type, String page, String pageSize, String from, String to) throws ApiException {
        ApiResponse<GetCampaignStatisticsWithPagingFilteredResponse> resp = this.getCampaignStatisticsWithPagingFilteredWithHttpInfo(format, apikey, campaignID, type, page, pageSize, from, to);
        return resp.getData();
    }

    public ApiResponse<GetCampaignStatisticsWithPagingFilteredResponse> getCampaignStatisticsWithPagingFilteredWithHttpInfo(String format, String apikey, String campaignID, String type, String page, String pageSize, String from, String to) throws ApiException {
        Call call = this.getCampaignStatisticsWithPagingFilteredValidateBeforeCall(format, apikey, campaignID, type, page, pageSize, from, to, null, null);
        Type localVarReturnType = new TypeToken<GetCampaignStatisticsWithPagingFilteredResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCampaignStatisticsWithPagingFilteredAsync(String format, String apikey, String campaignID, String type, String page, String pageSize, String from, String to, final ApiCallback<GetCampaignStatisticsWithPagingFilteredResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCampaignStatisticsWithPagingFilteredValidateBeforeCall(format, apikey, campaignID, type, page, pageSize, from, to, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetCampaignStatisticsWithPagingFilteredResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCampaignsByPageCall(String format, String apikey, Double page, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns/{Page}.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{Page\\}", this.apiClient.escapeString(page.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCampaignsByPageValidateBeforeCall(String format, String apikey, Double page, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling getCampaignsByPage(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling getCampaignsByPage(Async)");
        }
        if (page == null) {
            throw new ApiException("Missing the required parameter 'page' when calling getCampaignsByPage(Async)");
        }
        Call call = this.getCampaignsByPageCall(format, apikey, page, progressListener, progressRequestListener);
        return call;
    }

    public GetCampaignsByPageResponse getCampaignsByPage(String format, String apikey, Double page) throws ApiException {
        ApiResponse<GetCampaignsByPageResponse> resp = this.getCampaignsByPageWithHttpInfo(format, apikey, page);
        return resp.getData();
    }

    public ApiResponse<GetCampaignsByPageResponse> getCampaignsByPageWithHttpInfo(String format, String apikey, Double page) throws ApiException {
        Call call = this.getCampaignsByPageValidateBeforeCall(format, apikey, page, null, null);
        Type localVarReturnType = new TypeToken<GetCampaignsByPageResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCampaignsByPageAsync(String format, String apikey, Double page, final ApiCallback<GetCampaignsByPageResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCampaignsByPageValidateBeforeCall(format, apikey, page, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetCampaignsByPageResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCampaignsByPageAndPagesizeCall(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns/{Page}/{PageSize}.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{Page\\}", this.apiClient.escapeString(page.toString())).replaceAll("\\{PageSize\\}", this.apiClient.escapeString(pageSize.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        if (shortBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ShortBy", shortBy));
        }
        if (sortMethod != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "SortMethod", sortMethod));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCampaignsByPageAndPagesizeValidateBeforeCall(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling getCampaignsByPageAndPagesize(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling getCampaignsByPageAndPagesize(Async)");
        }
        if (page == null) {
            throw new ApiException("Missing the required parameter 'page' when calling getCampaignsByPageAndPagesize(Async)");
        }
        if (pageSize == null) {
            throw new ApiException("Missing the required parameter 'pageSize' when calling getCampaignsByPageAndPagesize(Async)");
        }
        Call call = this.getCampaignsByPageAndPagesizeCall(format, apikey, page, pageSize, shortBy, sortMethod, progressListener, progressRequestListener);
        return call;
    }

    public GetCampaignsByPageAndPagesizeResponse getCampaignsByPageAndPagesize(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod) throws ApiException {
        ApiResponse<GetCampaignsByPageAndPagesizeResponse> resp = this.getCampaignsByPageAndPagesizeWithHttpInfo(format, apikey, page, pageSize, shortBy, sortMethod);
        return resp.getData();
    }

    public ApiResponse<GetCampaignsByPageAndPagesizeResponse> getCampaignsByPageAndPagesizeWithHttpInfo(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod) throws ApiException {
        Call call = this.getCampaignsByPageAndPagesizeValidateBeforeCall(format, apikey, page, pageSize, shortBy, sortMethod, null, null);
        Type localVarReturnType = new TypeToken<GetCampaignsByPageAndPagesizeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCampaignsByPageAndPagesizeAsync(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod, final ApiCallback<GetCampaignsByPageAndPagesizeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCampaignsByPageAndPagesizeValidateBeforeCall(format, apikey, page, pageSize, shortBy, sortMethod, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetCampaignsByPageAndPagesizeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gettingAllYourSendersCall(String format, String apikey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/senders/find_all.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gettingAllYourSendersValidateBeforeCall(String format, String apikey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingAllYourSenders(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingAllYourSenders(Async)");
        }
        Call call = this.gettingAllYourSendersCall(format, apikey, progressListener, progressRequestListener);
        return call;
    }

    public GettingAllYourSendersResponse gettingAllYourSenders(String format, String apikey) throws ApiException {
        ApiResponse<GettingAllYourSendersResponse> resp = this.gettingAllYourSendersWithHttpInfo(format, apikey);
        return resp.getData();
    }

    public ApiResponse<GettingAllYourSendersResponse> gettingAllYourSendersWithHttpInfo(String format, String apikey) throws ApiException {
        Call call = this.gettingAllYourSendersValidateBeforeCall(format, apikey, null, null);
        Type localVarReturnType = new TypeToken<GettingAllYourSendersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gettingAllYourSendersAsync(String format, String apikey, final ApiCallback<GettingAllYourSendersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gettingAllYourSendersValidateBeforeCall(format, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingAllYourSendersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gettingCampaignDetailsCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns/{CampaignID}/view.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gettingCampaignDetailsValidateBeforeCall(String format, String apikey, String campaignID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingCampaignDetails(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingCampaignDetails(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling gettingCampaignDetails(Async)");
        }
        Call call = this.gettingCampaignDetailsCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;
    }

    public GettingCampaignDetailsResponse gettingCampaignDetails(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<GettingCampaignDetailsResponse> resp = this.gettingCampaignDetailsWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    public ApiResponse<GettingCampaignDetailsResponse> gettingCampaignDetailsWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        Call call = this.gettingCampaignDetailsValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<GettingCampaignDetailsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gettingCampaignDetailsAsync(String format, String apikey, String campaignID, final ApiCallback<GettingCampaignDetailsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gettingCampaignDetailsValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingCampaignDetailsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gettingSenderDetailsCall(String format, String email, String apikey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/senders/find_one.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (email != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "Email", email));
        }
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gettingSenderDetailsValidateBeforeCall(String format, String email, String apikey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingSenderDetails(Async)");
        }
        if (email == null) {
            throw new ApiException("Missing the required parameter 'email' when calling gettingSenderDetails(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingSenderDetails(Async)");
        }
        Call call = this.gettingSenderDetailsCall(format, email, apikey, progressListener, progressRequestListener);
        return call;
    }

    public GettingSenderDetailsResponse gettingSenderDetails(String format, String email, String apikey) throws ApiException {
        ApiResponse<GettingSenderDetailsResponse> resp = this.gettingSenderDetailsWithHttpInfo(format, email, apikey);
        return resp.getData();
    }

    public ApiResponse<GettingSenderDetailsResponse> gettingSenderDetailsWithHttpInfo(String format, String email, String apikey) throws ApiException {
        Call call = this.gettingSenderDetailsValidateBeforeCall(format, email, apikey, null, null);
        Type localVarReturnType = new TypeToken<GettingSenderDetailsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gettingSenderDetailsAsync(String format, String email, String apikey, final ApiCallback<GettingSenderDetailsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gettingSenderDetailsValidateBeforeCall(format, email, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingSenderDetailsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call linkActivityCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns/{CampaignID}/stats/links.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call linkActivityValidateBeforeCall(String format, String apikey, String campaignID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling linkActivity(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling linkActivity(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling linkActivity(Async)");
        }
        Call call = this.linkActivityCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;
    }

    public LinkActivityResponse linkActivity(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<LinkActivityResponse> resp = this.linkActivityWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    public ApiResponse<LinkActivityResponse> linkActivityWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        Call call = this.linkActivityValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<LinkActivityResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call linkActivityAsync(String format, String apikey, String campaignID, final ApiCallback<LinkActivityResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.linkActivityValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LinkActivityResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call schedulingACampaignCall(String format, String apikey, String campaignID, SchedulingACampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SchedulingACampaignRequest localVarPostBody = body;
        String localVarPath = "/campaigns/{CampaignID}/schedule.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call schedulingACampaignValidateBeforeCall(String format, String apikey, String campaignID, SchedulingACampaignRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling schedulingACampaign(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling schedulingACampaign(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling schedulingACampaign(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling schedulingACampaign(Async)");
        }
        Call call = this.schedulingACampaignCall(format, apikey, campaignID, body, progressListener, progressRequestListener);
        return call;
    }

    public SchedulingACampaignResponse schedulingACampaign(String format, String apikey, String campaignID, SchedulingACampaignRequest body) throws ApiException {
        ApiResponse<SchedulingACampaignResponse> resp = this.schedulingACampaignWithHttpInfo(format, apikey, campaignID, body);
        return resp.getData();
    }

    public ApiResponse<SchedulingACampaignResponse> schedulingACampaignWithHttpInfo(String format, String apikey, String campaignID, SchedulingACampaignRequest body) throws ApiException {
        Call call = this.schedulingACampaignValidateBeforeCall(format, apikey, campaignID, body, null, null);
        Type localVarReturnType = new TypeToken<SchedulingACampaignResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call schedulingACampaignAsync(String format, String apikey, String campaignID, SchedulingACampaignRequest body, final ApiCallback<SchedulingACampaignResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.schedulingACampaignValidateBeforeCall(format, apikey, campaignID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SchedulingACampaignResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call sendingACampaignCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns/{CampaignID}/send.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call sendingACampaignValidateBeforeCall(String format, String apikey, String campaignID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling sendingACampaign(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling sendingACampaign(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling sendingACampaign(Async)");
        }
        Call call = this.sendingACampaignCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;
    }

    public SendingACampaignResponse sendingACampaign(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<SendingACampaignResponse> resp = this.sendingACampaignWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    public ApiResponse<SendingACampaignResponse> sendingACampaignWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        Call call = this.sendingACampaignValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<SendingACampaignResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call sendingACampaignAsync(String format, String apikey, String campaignID, final ApiCallback<SendingACampaignResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendingACampaignValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SendingACampaignResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call testingACampaignCall(String format, String apikey, String campaignID, TestingACampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TestingACampaignRequest localVarPostBody = body;
        String localVarPath = "/campaigns/{CampaignID}/send_test.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call testingACampaignValidateBeforeCall(String format, String apikey, String campaignID, TestingACampaignRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling testingACampaign(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling testingACampaign(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling testingACampaign(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling testingACampaign(Async)");
        }
        Call call = this.testingACampaignCall(format, apikey, campaignID, body, progressListener, progressRequestListener);
        return call;
    }

    public TestingACampaignResponse testingACampaign(String format, String apikey, String campaignID, TestingACampaignRequest body) throws ApiException {
        ApiResponse<TestingACampaignResponse> resp = this.testingACampaignWithHttpInfo(format, apikey, campaignID, body);
        return resp.getData();
    }

    public ApiResponse<TestingACampaignResponse> testingACampaignWithHttpInfo(String format, String apikey, String campaignID, TestingACampaignRequest body) throws ApiException {
        Call call = this.testingACampaignValidateBeforeCall(format, apikey, campaignID, body, null, null);
        Type localVarReturnType = new TypeToken<TestingACampaignResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call testingACampaignAsync(String format, String apikey, String campaignID, TestingACampaignRequest body, final ApiCallback<TestingACampaignResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.testingACampaignValidateBeforeCall(format, apikey, campaignID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestingACampaignResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call unschedulingACampaignCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/campaigns/{CampaignID}/unschedule.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call unschedulingACampaignValidateBeforeCall(String format, String apikey, String campaignID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling unschedulingACampaign(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling unschedulingACampaign(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling unschedulingACampaign(Async)");
        }
        Call call = this.unschedulingACampaignCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;
    }

    public UnschedulingACampaignResponse unschedulingACampaign(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<UnschedulingACampaignResponse> resp = this.unschedulingACampaignWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    public ApiResponse<UnschedulingACampaignResponse> unschedulingACampaignWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        Call call = this.unschedulingACampaignValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<UnschedulingACampaignResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call unschedulingACampaignAsync(String format, String apikey, String campaignID, final ApiCallback<UnschedulingACampaignResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.unschedulingACampaignValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UnschedulingACampaignResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updatingADraftCampaignCall(String format, String apikey, String campaignID, UpdatingADraftCampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdatingADraftCampaignRequest localVarPostBody = body;
        String localVarPath = "/campaigns/{CampaignID}/update.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updatingADraftCampaignValidateBeforeCall(String format, String apikey, String campaignID, UpdatingADraftCampaignRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling updatingADraftCampaign(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling updatingADraftCampaign(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling updatingADraftCampaign(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatingADraftCampaign(Async)");
        }
        Call call = this.updatingADraftCampaignCall(format, apikey, campaignID, body, progressListener, progressRequestListener);
        return call;
    }

    public UpdatingADraftCampaignResponse updatingADraftCampaign(String format, String apikey, String campaignID, UpdatingADraftCampaignRequest body) throws ApiException {
        ApiResponse<UpdatingADraftCampaignResponse> resp = this.updatingADraftCampaignWithHttpInfo(format, apikey, campaignID, body);
        return resp.getData();
    }

    public ApiResponse<UpdatingADraftCampaignResponse> updatingADraftCampaignWithHttpInfo(String format, String apikey, String campaignID, UpdatingADraftCampaignRequest body) throws ApiException {
        Call call = this.updatingADraftCampaignValidateBeforeCall(format, apikey, campaignID, body, null, null);
        Type localVarReturnType = new TypeToken<UpdatingADraftCampaignResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updatingADraftCampaignAsync(String format, String apikey, String campaignID, UpdatingADraftCampaignRequest body, final ApiCallback<UpdatingADraftCampaignResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updatingADraftCampaignValidateBeforeCall(format, apikey, campaignID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdatingADraftCampaignResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

