/*
 * Moosend API
 * TODO: Add a description
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.AddingMultipleSubscribersRequest;
import io.swagger.client.model.AddingMultipleSubscribersResponse;
import io.swagger.client.model.AddingSubscribersRequest;
import io.swagger.client.model.AddingSubscribersResponse;
import io.swagger.client.model.GetSubscriberByEmailAddressResponse;
import io.swagger.client.model.GetSubscriberByIdResponse;
import io.swagger.client.model.GettingSubscribersResponse;
import io.swagger.client.model.RemovingASubscriberRequest;
import io.swagger.client.model.RemovingASubscriberResponse;
import io.swagger.client.model.RemovingMultipleSubscribersRequest;
import io.swagger.client.model.RemovingMultipleSubscribersResponse;
import io.swagger.client.model.UnsubscribingSubscribersFromAccountRequest;
import io.swagger.client.model.UnsubscribingSubscribersFromAccountResponse;
import io.swagger.client.model.UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest;
import io.swagger.client.model.UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse;
import io.swagger.client.model.UnsubscribingSubscribersFromMailingListRequest;
import io.swagger.client.model.UnsubscribingSubscribersFromMailingListResponse;
import io.swagger.client.model.UpdatingASubscriberRequest;
import io.swagger.client.model.UpdatingASubscriberResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubscribersApi {
    private ApiClient apiClient;

    public SubscribersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscribersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for addingMultipleSubscribers
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to add subscribers to. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addingMultipleSubscribersCall(String format, String apikey, String mailingListID, AddingMultipleSubscribersRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/subscribers/{MailingListID}/subscribe_many.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addingMultipleSubscribersValidateBeforeCall(String format, String apikey, String mailingListID, AddingMultipleSubscribersRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling addingMultipleSubscribers(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling addingMultipleSubscribers(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling addingMultipleSubscribers(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addingMultipleSubscribers(Async)");
        }
        
        
        com.squareup.okhttp.Call call = addingMultipleSubscribersCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Adding multiple subscribers
     * This method allows you to add multiple subscribers in a mailing list with a single call. If some subscribers already exist with the given email addresses, they will be updated. If you try to add a subscriber with an invalid email address, this attempt will be ignored, as the process will skip to the next subscriber automatically.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to add subscribers to. (required)
     * @param body  (required)
     * @return AddingMultipleSubscribersResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AddingMultipleSubscribersResponse addingMultipleSubscribers(String format, String apikey, String mailingListID, AddingMultipleSubscribersRequest body) throws ApiException {
        ApiResponse<AddingMultipleSubscribersResponse> resp = addingMultipleSubscribersWithHttpInfo(format, apikey, mailingListID, body);
        return resp.getData();
    }

    /**
     * Adding multiple subscribers
     * This method allows you to add multiple subscribers in a mailing list with a single call. If some subscribers already exist with the given email addresses, they will be updated. If you try to add a subscriber with an invalid email address, this attempt will be ignored, as the process will skip to the next subscriber automatically.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to add subscribers to. (required)
     * @param body  (required)
     * @return ApiResponse&lt;AddingMultipleSubscribersResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AddingMultipleSubscribersResponse> addingMultipleSubscribersWithHttpInfo(String format, String apikey, String mailingListID, AddingMultipleSubscribersRequest body) throws ApiException {
        com.squareup.okhttp.Call call = addingMultipleSubscribersValidateBeforeCall(format, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<AddingMultipleSubscribersResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Adding multiple subscribers (asynchronously)
     * This method allows you to add multiple subscribers in a mailing list with a single call. If some subscribers already exist with the given email addresses, they will be updated. If you try to add a subscriber with an invalid email address, this attempt will be ignored, as the process will skip to the next subscriber automatically.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to add subscribers to. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addingMultipleSubscribersAsync(String format, String apikey, String mailingListID, AddingMultipleSubscribersRequest body, final ApiCallback<AddingMultipleSubscribersResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addingMultipleSubscribersValidateBeforeCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AddingMultipleSubscribersResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for addingSubscribers
     * @param format  (required)
     * @param mailingListID The ID of the mailing list to add the new member. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addingSubscribersCall(String format, String mailingListID, String apikey, AddingSubscribersRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/subscribers/{MailingListID}/subscribe.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addingSubscribersValidateBeforeCall(String format, String mailingListID, String apikey, AddingSubscribersRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling addingSubscribers(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling addingSubscribers(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling addingSubscribers(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addingSubscribers(Async)");
        }
        
        
        com.squareup.okhttp.Call call = addingSubscribersCall(format, mailingListID, apikey, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Adding subscribers
     * Adds a new subscriber to the specified mailing list. If there is already a subscriber with the specified email address in the list, an update will be performed instead.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list to add the new member. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @return AddingSubscribersResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AddingSubscribersResponse addingSubscribers(String format, String mailingListID, String apikey, AddingSubscribersRequest body) throws ApiException {
        ApiResponse<AddingSubscribersResponse> resp = addingSubscribersWithHttpInfo(format, mailingListID, apikey, body);
        return resp.getData();
    }

    /**
     * Adding subscribers
     * Adds a new subscriber to the specified mailing list. If there is already a subscriber with the specified email address in the list, an update will be performed instead.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list to add the new member. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @return ApiResponse&lt;AddingSubscribersResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AddingSubscribersResponse> addingSubscribersWithHttpInfo(String format, String mailingListID, String apikey, AddingSubscribersRequest body) throws ApiException {
        com.squareup.okhttp.Call call = addingSubscribersValidateBeforeCall(format, mailingListID, apikey, body, null, null);
        Type localVarReturnType = new TypeToken<AddingSubscribersResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Adding subscribers (asynchronously)
     * Adds a new subscriber to the specified mailing list. If there is already a subscriber with the specified email address in the list, an update will be performed instead.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list to add the new member. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addingSubscribersAsync(String format, String mailingListID, String apikey, AddingSubscribersRequest body, final ApiCallback<AddingSubscribersResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addingSubscribersValidateBeforeCall(format, mailingListID, apikey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AddingSubscribersResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getSubscriberByEmailAddress
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the subscriber belongs. (required)
     * @param email The email of the subscriber. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSubscriberByEmailAddressCall(String format, String apikey, String mailingListID, String email, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/subscribers/{MailingListID}/view.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));
        if (email != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "Email", email));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSubscriberByEmailAddressValidateBeforeCall(String format, String apikey, String mailingListID, String email, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling getSubscriberByEmailAddress(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling getSubscriberByEmailAddress(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling getSubscriberByEmailAddress(Async)");
        }
        
        // verify the required parameter 'email' is set
        if (email == null) {
            throw new ApiException("Missing the required parameter 'email' when calling getSubscriberByEmailAddress(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getSubscriberByEmailAddressCall(format, apikey, mailingListID, email, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get subscriber by email address
     * Searches for a subscriber with the specified email address in the specified mailing list and returns detailed information such as id, name, date created, date unsubscribed, status and custom fields
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the subscriber belongs. (required)
     * @param email The email of the subscriber. (required)
     * @return GetSubscriberByEmailAddressResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetSubscriberByEmailAddressResponse getSubscriberByEmailAddress(String format, String apikey, String mailingListID, String email) throws ApiException {
        ApiResponse<GetSubscriberByEmailAddressResponse> resp = getSubscriberByEmailAddressWithHttpInfo(format, apikey, mailingListID, email);
        return resp.getData();
    }

    /**
     * Get subscriber by email address
     * Searches for a subscriber with the specified email address in the specified mailing list and returns detailed information such as id, name, date created, date unsubscribed, status and custom fields
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the subscriber belongs. (required)
     * @param email The email of the subscriber. (required)
     * @return ApiResponse&lt;GetSubscriberByEmailAddressResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetSubscriberByEmailAddressResponse> getSubscriberByEmailAddressWithHttpInfo(String format, String apikey, String mailingListID, String email) throws ApiException {
        com.squareup.okhttp.Call call = getSubscriberByEmailAddressValidateBeforeCall(format, apikey, mailingListID, email, null, null);
        Type localVarReturnType = new TypeToken<GetSubscriberByEmailAddressResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get subscriber by email address (asynchronously)
     * Searches for a subscriber with the specified email address in the specified mailing list and returns detailed information such as id, name, date created, date unsubscribed, status and custom fields
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the subscriber belongs. (required)
     * @param email The email of the subscriber. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSubscriberByEmailAddressAsync(String format, String apikey, String mailingListID, String email, final ApiCallback<GetSubscriberByEmailAddressResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSubscriberByEmailAddressValidateBeforeCall(format, apikey, mailingListID, email, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSubscriberByEmailAddressResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getSubscriberById
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to search the subscriber in. (required)
     * @param subscriberID The id of the subscriber being searched. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSubscriberByIdCall(String format, String apikey, String mailingListID, String subscriberID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/subscribers/{MailingListID}/find/{SubscriberID}.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()))
            .replaceAll("\\{" + "SubscriberID" + "\\}", apiClient.escapeString(subscriberID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSubscriberByIdValidateBeforeCall(String format, String apikey, String mailingListID, String subscriberID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling getSubscriberById(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling getSubscriberById(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling getSubscriberById(Async)");
        }
        
        // verify the required parameter 'subscriberID' is set
        if (subscriberID == null) {
            throw new ApiException("Missing the required parameter 'subscriberID' when calling getSubscriberById(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getSubscriberByIdCall(format, apikey, mailingListID, subscriberID, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get subscriber by id
     * Searches for a subscriber with the specified unique id in the specified mailing list and returns detailed information such as email, name, date created, date unsubscribed, status and custom fields.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to search the subscriber in. (required)
     * @param subscriberID The id of the subscriber being searched. (required)
     * @return GetSubscriberByIdResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetSubscriberByIdResponse getSubscriberById(String format, String apikey, String mailingListID, String subscriberID) throws ApiException {
        ApiResponse<GetSubscriberByIdResponse> resp = getSubscriberByIdWithHttpInfo(format, apikey, mailingListID, subscriberID);
        return resp.getData();
    }

    /**
     * Get subscriber by id
     * Searches for a subscriber with the specified unique id in the specified mailing list and returns detailed information such as email, name, date created, date unsubscribed, status and custom fields.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to search the subscriber in. (required)
     * @param subscriberID The id of the subscriber being searched. (required)
     * @return ApiResponse&lt;GetSubscriberByIdResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetSubscriberByIdResponse> getSubscriberByIdWithHttpInfo(String format, String apikey, String mailingListID, String subscriberID) throws ApiException {
        com.squareup.okhttp.Call call = getSubscriberByIdValidateBeforeCall(format, apikey, mailingListID, subscriberID, null, null);
        Type localVarReturnType = new TypeToken<GetSubscriberByIdResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get subscriber by id (asynchronously)
     * Searches for a subscriber with the specified unique id in the specified mailing list and returns detailed information such as email, name, date created, date unsubscribed, status and custom fields.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to search the subscriber in. (required)
     * @param subscriberID The id of the subscriber being searched. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSubscriberByIdAsync(String format, String apikey, String mailingListID, String subscriberID, final ApiCallback<GetSubscriberByIdResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSubscriberByIdValidateBeforeCall(format, apikey, mailingListID, subscriberID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSubscriberByIdResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for gettingSubscribers
     * @param format  (required)
     * @param mailingListID The ID of the mailing list where the subscribers belong. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param status Specifies what type of subscriber statistics results will be returned. (required)
     * @param page Specifies the page of subscriber statistics results will be returned. (optional)
     * @param pageSize Specifies the page size of subscriber statistics results will be returned. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call gettingSubscribersCall(String format, String mailingListID, String apikey, String status, Double page, Double pageSize, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/subscribers/{Status}.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()))
            .replaceAll("\\{" + "Status" + "\\}", apiClient.escapeString(status.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "Page", page));
        if (pageSize != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "PageSize", pageSize));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call gettingSubscribersValidateBeforeCall(String format, String mailingListID, String apikey, String status, Double page, Double pageSize, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingSubscribers(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling gettingSubscribers(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingSubscribers(Async)");
        }
        
        // verify the required parameter 'status' is set
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling gettingSubscribers(Async)");
        }
        
        
        com.squareup.okhttp.Call call = gettingSubscribersCall(format, mailingListID, apikey, status, page, pageSize, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Getting subscribers
     * Gets a list of all subscribers in a given mailing list. You may filter the list by setting a date to fetch those subscribed since then and/or by their status. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list where the subscribers belong. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param status Specifies what type of subscriber statistics results will be returned. (required)
     * @param page Specifies the page of subscriber statistics results will be returned. (optional)
     * @param pageSize Specifies the page size of subscriber statistics results will be returned. (optional)
     * @return GettingSubscribersResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GettingSubscribersResponse gettingSubscribers(String format, String mailingListID, String apikey, String status, Double page, Double pageSize) throws ApiException {
        ApiResponse<GettingSubscribersResponse> resp = gettingSubscribersWithHttpInfo(format, mailingListID, apikey, status, page, pageSize);
        return resp.getData();
    }

    /**
     * Getting subscribers
     * Gets a list of all subscribers in a given mailing list. You may filter the list by setting a date to fetch those subscribed since then and/or by their status. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list where the subscribers belong. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param status Specifies what type of subscriber statistics results will be returned. (required)
     * @param page Specifies the page of subscriber statistics results will be returned. (optional)
     * @param pageSize Specifies the page size of subscriber statistics results will be returned. (optional)
     * @return ApiResponse&lt;GettingSubscribersResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GettingSubscribersResponse> gettingSubscribersWithHttpInfo(String format, String mailingListID, String apikey, String status, Double page, Double pageSize) throws ApiException {
        com.squareup.okhttp.Call call = gettingSubscribersValidateBeforeCall(format, mailingListID, apikey, status, page, pageSize, null, null);
        Type localVarReturnType = new TypeToken<GettingSubscribersResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Getting subscribers (asynchronously)
     * Gets a list of all subscribers in a given mailing list. You may filter the list by setting a date to fetch those subscribed since then and/or by their status. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list where the subscribers belong. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param status Specifies what type of subscriber statistics results will be returned. (required)
     * @param page Specifies the page of subscriber statistics results will be returned. (optional)
     * @param pageSize Specifies the page size of subscriber statistics results will be returned. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call gettingSubscribersAsync(String format, String mailingListID, String apikey, String status, Double page, Double pageSize, final ApiCallback<GettingSubscribersResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = gettingSubscribersValidateBeforeCall(format, mailingListID, apikey, status, page, pageSize, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingSubscribersResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for removingASubscriber
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to remove the subscriber from. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call removingASubscriberCall(String format, String apikey, String mailingListID, RemovingASubscriberRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/subscribers/{MailingListID}/remove.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call removingASubscriberValidateBeforeCall(String format, String apikey, String mailingListID, RemovingASubscriberRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling removingASubscriber(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling removingASubscriber(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling removingASubscriber(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling removingASubscriber(Async)");
        }
        
        
        com.squareup.okhttp.Call call = removingASubscriberCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Removing a subscriber
     * Removes a subscriber from the specified mailing list permanently (without moving to the suppression list).
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to remove the subscriber from. (required)
     * @param body  (required)
     * @return RemovingASubscriberResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RemovingASubscriberResponse removingASubscriber(String format, String apikey, String mailingListID, RemovingASubscriberRequest body) throws ApiException {
        ApiResponse<RemovingASubscriberResponse> resp = removingASubscriberWithHttpInfo(format, apikey, mailingListID, body);
        return resp.getData();
    }

    /**
     * Removing a subscriber
     * Removes a subscriber from the specified mailing list permanently (without moving to the suppression list).
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to remove the subscriber from. (required)
     * @param body  (required)
     * @return ApiResponse&lt;RemovingASubscriberResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RemovingASubscriberResponse> removingASubscriberWithHttpInfo(String format, String apikey, String mailingListID, RemovingASubscriberRequest body) throws ApiException {
        com.squareup.okhttp.Call call = removingASubscriberValidateBeforeCall(format, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<RemovingASubscriberResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Removing a subscriber (asynchronously)
     * Removes a subscriber from the specified mailing list permanently (without moving to the suppression list).
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to remove the subscriber from. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call removingASubscriberAsync(String format, String apikey, String mailingListID, RemovingASubscriberRequest body, final ApiCallback<RemovingASubscriberResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = removingASubscriberValidateBeforeCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RemovingASubscriberResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for removingMultipleSubscribers
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to remove the subscribers from. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call removingMultipleSubscribersCall(String format, String apikey, String mailingListID, RemovingMultipleSubscribersRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/subscribers/{MailingListID}/remove_many.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call removingMultipleSubscribersValidateBeforeCall(String format, String apikey, String mailingListID, RemovingMultipleSubscribersRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling removingMultipleSubscribers(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling removingMultipleSubscribers(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling removingMultipleSubscribers(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling removingMultipleSubscribers(Async)");
        }
        
        
        com.squareup.okhttp.Call call = removingMultipleSubscribersCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Removing multiple subscribers
     * Removes a list of subscribers from the specified mailing list permanently (without putting them in the suppression list). Any invalid email addresses specified will be ignored.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to remove the subscribers from. (required)
     * @param body  (required)
     * @return RemovingMultipleSubscribersResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RemovingMultipleSubscribersResponse removingMultipleSubscribers(String format, String apikey, String mailingListID, RemovingMultipleSubscribersRequest body) throws ApiException {
        ApiResponse<RemovingMultipleSubscribersResponse> resp = removingMultipleSubscribersWithHttpInfo(format, apikey, mailingListID, body);
        return resp.getData();
    }

    /**
     * Removing multiple subscribers
     * Removes a list of subscribers from the specified mailing list permanently (without putting them in the suppression list). Any invalid email addresses specified will be ignored.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to remove the subscribers from. (required)
     * @param body  (required)
     * @return ApiResponse&lt;RemovingMultipleSubscribersResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RemovingMultipleSubscribersResponse> removingMultipleSubscribersWithHttpInfo(String format, String apikey, String mailingListID, RemovingMultipleSubscribersRequest body) throws ApiException {
        com.squareup.okhttp.Call call = removingMultipleSubscribersValidateBeforeCall(format, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<RemovingMultipleSubscribersResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Removing multiple subscribers (asynchronously)
     * Removes a list of subscribers from the specified mailing list permanently (without putting them in the suppression list). Any invalid email addresses specified will be ignored.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to remove the subscribers from. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call removingMultipleSubscribersAsync(String format, String apikey, String mailingListID, RemovingMultipleSubscribersRequest body, final ApiCallback<RemovingMultipleSubscribersResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = removingMultipleSubscribersValidateBeforeCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RemovingMultipleSubscribersResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for unsubscribingSubscribersFromAccount
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call unsubscribingSubscribersFromAccountCall(String format, String apikey, UnsubscribingSubscribersFromAccountRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/subscribers/unsubscribe.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call unsubscribingSubscribersFromAccountValidateBeforeCall(String format, String apikey, UnsubscribingSubscribersFromAccountRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling unsubscribingSubscribersFromAccount(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling unsubscribingSubscribersFromAccount(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling unsubscribingSubscribersFromAccount(Async)");
        }
        
        
        com.squareup.okhttp.Call call = unsubscribingSubscribersFromAccountCall(format, apikey, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Unsubscribing subscribers from account
     * Unsubscribes a subscriber from the account.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @return UnsubscribingSubscribersFromAccountResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UnsubscribingSubscribersFromAccountResponse unsubscribingSubscribersFromAccount(String format, String apikey, UnsubscribingSubscribersFromAccountRequest body) throws ApiException {
        ApiResponse<UnsubscribingSubscribersFromAccountResponse> resp = unsubscribingSubscribersFromAccountWithHttpInfo(format, apikey, body);
        return resp.getData();
    }

    /**
     * Unsubscribing subscribers from account
     * Unsubscribes a subscriber from the account.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @return ApiResponse&lt;UnsubscribingSubscribersFromAccountResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UnsubscribingSubscribersFromAccountResponse> unsubscribingSubscribersFromAccountWithHttpInfo(String format, String apikey, UnsubscribingSubscribersFromAccountRequest body) throws ApiException {
        com.squareup.okhttp.Call call = unsubscribingSubscribersFromAccountValidateBeforeCall(format, apikey, body, null, null);
        Type localVarReturnType = new TypeToken<UnsubscribingSubscribersFromAccountResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Unsubscribing subscribers from account (asynchronously)
     * Unsubscribes a subscriber from the account.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call unsubscribingSubscribersFromAccountAsync(String format, String apikey, UnsubscribingSubscribersFromAccountRequest body, final ApiCallback<UnsubscribingSubscribersFromAccountResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = unsubscribingSubscribersFromAccountValidateBeforeCall(format, apikey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UnsubscribingSubscribersFromAccountResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for unsubscribingSubscribersFromMailingList
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to add subscribers to. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call unsubscribingSubscribersFromMailingListCall(String format, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/subscribers/{MailingListID}/unsubscribe.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call unsubscribingSubscribersFromMailingListValidateBeforeCall(String format, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling unsubscribingSubscribersFromMailingList(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling unsubscribingSubscribersFromMailingList(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling unsubscribingSubscribersFromMailingList(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling unsubscribingSubscribersFromMailingList(Async)");
        }
        
        
        com.squareup.okhttp.Call call = unsubscribingSubscribersFromMailingListCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Unsubscribing subscribers from mailing list
     * Unsubscribes a subscriber from the specified mailing list. The subscriber is not deleted, but moved to the suppression list.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to add subscribers to. (required)
     * @param body  (required)
     * @return UnsubscribingSubscribersFromMailingListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UnsubscribingSubscribersFromMailingListResponse unsubscribingSubscribersFromMailingList(String format, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListRequest body) throws ApiException {
        ApiResponse<UnsubscribingSubscribersFromMailingListResponse> resp = unsubscribingSubscribersFromMailingListWithHttpInfo(format, apikey, mailingListID, body);
        return resp.getData();
    }

    /**
     * Unsubscribing subscribers from mailing list
     * Unsubscribes a subscriber from the specified mailing list. The subscriber is not deleted, but moved to the suppression list.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to add subscribers to. (required)
     * @param body  (required)
     * @return ApiResponse&lt;UnsubscribingSubscribersFromMailingListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UnsubscribingSubscribersFromMailingListResponse> unsubscribingSubscribersFromMailingListWithHttpInfo(String format, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListRequest body) throws ApiException {
        com.squareup.okhttp.Call call = unsubscribingSubscribersFromMailingListValidateBeforeCall(format, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<UnsubscribingSubscribersFromMailingListResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Unsubscribing subscribers from mailing list (asynchronously)
     * Unsubscribes a subscriber from the specified mailing list. The subscriber is not deleted, but moved to the suppression list.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to add subscribers to. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call unsubscribingSubscribersFromMailingListAsync(String format, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListRequest body, final ApiCallback<UnsubscribingSubscribersFromMailingListResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = unsubscribingSubscribersFromMailingListValidateBeforeCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UnsubscribingSubscribersFromMailingListResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for unsubscribingSubscribersFromMailingListAndASpecifiedCampaign
     * @param format  (required)
     * @param campaignID The ID of the campaign that was sent to the specific mailing list. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to remove the subscriber from. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call unsubscribingSubscribersFromMailingListAndASpecifiedCampaignCall(String format, String campaignID, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/subscribers/{MailingListID}/{CampaignID}/unsubscribe.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call unsubscribingSubscribersFromMailingListAndASpecifiedCampaignValidateBeforeCall(String format, String campaignID, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign(Async)");
        }
        
        
        com.squareup.okhttp.Call call = unsubscribingSubscribersFromMailingListAndASpecifiedCampaignCall(format, campaignID, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Unsubscribing subscribers from mailing list and a specified campaign
     * Unsubscribes a subscriber from the specified mailing list and the specified campaign. The subscriber is not deleted, but moved to the suppression list.  This call will take into account the setting you have in \&quot;suppression list and unsubscribe settings\&quot; and will remove the subscriber from all other mailing lists or not accordingly.
     * @param format  (required)
     * @param campaignID The ID of the campaign that was sent to the specific mailing list. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to remove the subscriber from. (required)
     * @param body  (required)
     * @return UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse unsubscribingSubscribersFromMailingListAndASpecifiedCampaign(String format, String campaignID, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest body) throws ApiException {
        ApiResponse<UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse> resp = unsubscribingSubscribersFromMailingListAndASpecifiedCampaignWithHttpInfo(format, campaignID, apikey, mailingListID, body);
        return resp.getData();
    }

    /**
     * Unsubscribing subscribers from mailing list and a specified campaign
     * Unsubscribes a subscriber from the specified mailing list and the specified campaign. The subscriber is not deleted, but moved to the suppression list.  This call will take into account the setting you have in \&quot;suppression list and unsubscribe settings\&quot; and will remove the subscriber from all other mailing lists or not accordingly.
     * @param format  (required)
     * @param campaignID The ID of the campaign that was sent to the specific mailing list. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to remove the subscriber from. (required)
     * @param body  (required)
     * @return ApiResponse&lt;UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse> unsubscribingSubscribersFromMailingListAndASpecifiedCampaignWithHttpInfo(String format, String campaignID, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest body) throws ApiException {
        com.squareup.okhttp.Call call = unsubscribingSubscribersFromMailingListAndASpecifiedCampaignValidateBeforeCall(format, campaignID, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Unsubscribing subscribers from mailing list and a specified campaign (asynchronously)
     * Unsubscribes a subscriber from the specified mailing list and the specified campaign. The subscriber is not deleted, but moved to the suppression list.  This call will take into account the setting you have in \&quot;suppression list and unsubscribe settings\&quot; and will remove the subscriber from all other mailing lists or not accordingly.
     * @param format  (required)
     * @param campaignID The ID of the campaign that was sent to the specific mailing list. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to remove the subscriber from. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call unsubscribingSubscribersFromMailingListAndASpecifiedCampaignAsync(String format, String campaignID, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest body, final ApiCallback<UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = unsubscribingSubscribersFromMailingListAndASpecifiedCampaignValidateBeforeCall(format, campaignID, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updatingASubscriber
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list that contains the subscriber (required)
     * @param subscriberID The id of the subscriber to be updated (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updatingASubscriberCall(String format, String apikey, String mailingListID, String subscriberID, UpdatingASubscriberRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/subscribers/{MailingListID}/update/{SubscriberID}.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()))
            .replaceAll("\\{" + "SubscriberID" + "\\}", apiClient.escapeString(subscriberID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updatingASubscriberValidateBeforeCall(String format, String apikey, String mailingListID, String subscriberID, UpdatingASubscriberRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling updatingASubscriber(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling updatingASubscriber(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling updatingASubscriber(Async)");
        }
        
        // verify the required parameter 'subscriberID' is set
        if (subscriberID == null) {
            throw new ApiException("Missing the required parameter 'subscriberID' when calling updatingASubscriber(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatingASubscriber(Async)");
        }
        
        
        com.squareup.okhttp.Call call = updatingASubscriberCall(format, apikey, mailingListID, subscriberID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Updating a subscriber
     * Updates a subscriber in the specified mailing list. You can even update the subscribers email, if he has not unsubscribed.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list that contains the subscriber (required)
     * @param subscriberID The id of the subscriber to be updated (required)
     * @param body  (required)
     * @return UpdatingASubscriberResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UpdatingASubscriberResponse updatingASubscriber(String format, String apikey, String mailingListID, String subscriberID, UpdatingASubscriberRequest body) throws ApiException {
        ApiResponse<UpdatingASubscriberResponse> resp = updatingASubscriberWithHttpInfo(format, apikey, mailingListID, subscriberID, body);
        return resp.getData();
    }

    /**
     * Updating a subscriber
     * Updates a subscriber in the specified mailing list. You can even update the subscribers email, if he has not unsubscribed.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list that contains the subscriber (required)
     * @param subscriberID The id of the subscriber to be updated (required)
     * @param body  (required)
     * @return ApiResponse&lt;UpdatingASubscriberResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UpdatingASubscriberResponse> updatingASubscriberWithHttpInfo(String format, String apikey, String mailingListID, String subscriberID, UpdatingASubscriberRequest body) throws ApiException {
        com.squareup.okhttp.Call call = updatingASubscriberValidateBeforeCall(format, apikey, mailingListID, subscriberID, body, null, null);
        Type localVarReturnType = new TypeToken<UpdatingASubscriberResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Updating a subscriber (asynchronously)
     * Updates a subscriber in the specified mailing list. You can even update the subscribers email, if he has not unsubscribed.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list that contains the subscriber (required)
     * @param subscriberID The id of the subscriber to be updated (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updatingASubscriberAsync(String format, String apikey, String mailingListID, String subscriberID, UpdatingASubscriberRequest body, final ApiCallback<UpdatingASubscriberResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updatingASubscriberValidateBeforeCall(format, apikey, mailingListID, subscriberID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdatingASubscriberResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
