/*
 * Moosend API
 * TODO: Add a description
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.CreatingACustomFieldRequest;
import io.swagger.client.model.CreatingACustomFieldResponse;
import io.swagger.client.model.CreatingAMailingListRequest;
import io.swagger.client.model.CreatingAMailingListResponse;
import io.swagger.client.model.DeletingAMailingListResponse;
import io.swagger.client.model.GettingAllActiveMailingListsResponse;
import io.swagger.client.model.GettingAllActiveMailingListsWithPagingResponse;
import io.swagger.client.model.GettingMailingListDetailsResponse;
import io.swagger.client.model.RemovingACustomFieldResponse;
import io.swagger.client.model.UpdatingACustomFieldRequest;
import io.swagger.client.model.UpdatingACustomFieldResponse;
import io.swagger.client.model.UpdatingAMailingListRequest;
import io.swagger.client.model.UpdatingAMailingListResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MailingListsApi {
    private ApiClient apiClient;

    public MailingListsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MailingListsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for creatingACustomField
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the custom field will belong. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call creatingACustomFieldCall(String format, String apikey, String mailingListID, CreatingACustomFieldRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/customfields/create.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call creatingACustomFieldValidateBeforeCall(String format, String apikey, String mailingListID, CreatingACustomFieldRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling creatingACustomField(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling creatingACustomField(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling creatingACustomField(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling creatingACustomField(Async)");
        }
        
        
        com.squareup.okhttp.Call call = creatingACustomFieldCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Creating a custom field
     * Creates a new custom field in the specified mailing list.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the custom field will belong. (required)
     * @param body  (required)
     * @return CreatingACustomFieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CreatingACustomFieldResponse creatingACustomField(String format, String apikey, String mailingListID, CreatingACustomFieldRequest body) throws ApiException {
        ApiResponse<CreatingACustomFieldResponse> resp = creatingACustomFieldWithHttpInfo(format, apikey, mailingListID, body);
        return resp.getData();
    }

    /**
     * Creating a custom field
     * Creates a new custom field in the specified mailing list.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the custom field will belong. (required)
     * @param body  (required)
     * @return ApiResponse&lt;CreatingACustomFieldResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CreatingACustomFieldResponse> creatingACustomFieldWithHttpInfo(String format, String apikey, String mailingListID, CreatingACustomFieldRequest body) throws ApiException {
        com.squareup.okhttp.Call call = creatingACustomFieldValidateBeforeCall(format, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<CreatingACustomFieldResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Creating a custom field (asynchronously)
     * Creates a new custom field in the specified mailing list.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the custom field will belong. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call creatingACustomFieldAsync(String format, String apikey, String mailingListID, CreatingACustomFieldRequest body, final ApiCallback<CreatingACustomFieldResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = creatingACustomFieldValidateBeforeCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreatingACustomFieldResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for creatingAMailingList
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call creatingAMailingListCall(String format, String apikey, CreatingAMailingListRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/lists/create.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call creatingAMailingListValidateBeforeCall(String format, String apikey, CreatingAMailingListRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling creatingAMailingList(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling creatingAMailingList(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling creatingAMailingList(Async)");
        }
        
        
        com.squareup.okhttp.Call call = creatingAMailingListCall(format, apikey, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Creating a mailing list
     * Creates a new empty mailing list in your account.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @return CreatingAMailingListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CreatingAMailingListResponse creatingAMailingList(String format, String apikey, CreatingAMailingListRequest body) throws ApiException {
        ApiResponse<CreatingAMailingListResponse> resp = creatingAMailingListWithHttpInfo(format, apikey, body);
        return resp.getData();
    }

    /**
     * Creating a mailing list
     * Creates a new empty mailing list in your account.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @return ApiResponse&lt;CreatingAMailingListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CreatingAMailingListResponse> creatingAMailingListWithHttpInfo(String format, String apikey, CreatingAMailingListRequest body) throws ApiException {
        com.squareup.okhttp.Call call = creatingAMailingListValidateBeforeCall(format, apikey, body, null, null);
        Type localVarReturnType = new TypeToken<CreatingAMailingListResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Creating a mailing list (asynchronously)
     * Creates a new empty mailing list in your account.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call creatingAMailingListAsync(String format, String apikey, CreatingAMailingListRequest body, final ApiCallback<CreatingAMailingListResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = creatingAMailingListValidateBeforeCall(format, apikey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreatingAMailingListResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deletingAMailingList
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to be deleted. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deletingAMailingListCall(String format, String apikey, String mailingListID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/delete.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deletingAMailingListValidateBeforeCall(String format, String apikey, String mailingListID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling deletingAMailingList(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling deletingAMailingList(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling deletingAMailingList(Async)");
        }
        
        
        com.squareup.okhttp.Call call = deletingAMailingListCall(format, apikey, mailingListID, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Deleting a mailing list
     * Deletes a mailing list from your account.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to be deleted. (required)
     * @return DeletingAMailingListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeletingAMailingListResponse deletingAMailingList(String format, String apikey, String mailingListID) throws ApiException {
        ApiResponse<DeletingAMailingListResponse> resp = deletingAMailingListWithHttpInfo(format, apikey, mailingListID);
        return resp.getData();
    }

    /**
     * Deleting a mailing list
     * Deletes a mailing list from your account.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to be deleted. (required)
     * @return ApiResponse&lt;DeletingAMailingListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeletingAMailingListResponse> deletingAMailingListWithHttpInfo(String format, String apikey, String mailingListID) throws ApiException {
        com.squareup.okhttp.Call call = deletingAMailingListValidateBeforeCall(format, apikey, mailingListID, null, null);
        Type localVarReturnType = new TypeToken<DeletingAMailingListResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Deleting a mailing list (asynchronously)
     * Deletes a mailing list from your account.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to be deleted. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deletingAMailingListAsync(String format, String apikey, String mailingListID, final ApiCallback<DeletingAMailingListResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deletingAMailingListValidateBeforeCall(format, apikey, mailingListID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeletingAMailingListResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for gettingAllActiveMailingLists
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param withStatistics Specifies whether to fetch statistics for the subscribers or not. If omitted, results will be returned with statistics by default. (optional)
     * @param shortBy The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param sortMethod The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call gettingAllActiveMailingListsCall(String format, String apikey, String withStatistics, String shortBy, String sortMethod, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/lists.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));
        if (withStatistics != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "WithStatistics", withStatistics));
        if (shortBy != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "ShortBy", shortBy));
        if (sortMethod != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "SortMethod", sortMethod));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call gettingAllActiveMailingListsValidateBeforeCall(String format, String apikey, String withStatistics, String shortBy, String sortMethod, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingAllActiveMailingLists(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingAllActiveMailingLists(Async)");
        }
        
        
        com.squareup.okhttp.Call call = gettingAllActiveMailingListsCall(format, apikey, withStatistics, shortBy, sortMethod, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Getting all active mailing lists
     * Gets a list of your active mailing lists in your account.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param withStatistics Specifies whether to fetch statistics for the subscribers or not. If omitted, results will be returned with statistics by default. (optional)
     * @param shortBy The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param sortMethod The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @return GettingAllActiveMailingListsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GettingAllActiveMailingListsResponse gettingAllActiveMailingLists(String format, String apikey, String withStatistics, String shortBy, String sortMethod) throws ApiException {
        ApiResponse<GettingAllActiveMailingListsResponse> resp = gettingAllActiveMailingListsWithHttpInfo(format, apikey, withStatistics, shortBy, sortMethod);
        return resp.getData();
    }

    /**
     * Getting all active mailing lists
     * Gets a list of your active mailing lists in your account.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param withStatistics Specifies whether to fetch statistics for the subscribers or not. If omitted, results will be returned with statistics by default. (optional)
     * @param shortBy The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param sortMethod The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @return ApiResponse&lt;GettingAllActiveMailingListsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GettingAllActiveMailingListsResponse> gettingAllActiveMailingListsWithHttpInfo(String format, String apikey, String withStatistics, String shortBy, String sortMethod) throws ApiException {
        com.squareup.okhttp.Call call = gettingAllActiveMailingListsValidateBeforeCall(format, apikey, withStatistics, shortBy, sortMethod, null, null);
        Type localVarReturnType = new TypeToken<GettingAllActiveMailingListsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Getting all active mailing lists (asynchronously)
     * Gets a list of your active mailing lists in your account.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param withStatistics Specifies whether to fetch statistics for the subscribers or not. If omitted, results will be returned with statistics by default. (optional)
     * @param shortBy The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param sortMethod The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call gettingAllActiveMailingListsAsync(String format, String apikey, String withStatistics, String shortBy, String sortMethod, final ApiCallback<GettingAllActiveMailingListsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = gettingAllActiveMailingListsValidateBeforeCall(format, apikey, withStatistics, shortBy, sortMethod, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingAllActiveMailingListsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for gettingAllActiveMailingListsWithPaging
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param page The page that you want to get. (required)
     * @param pageSize Lists Per Page. (required)
     * @param shortBy The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param sortMethod The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call gettingAllActiveMailingListsWithPagingCall(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/lists/{Page}/{PageSize}.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "Page" + "\\}", apiClient.escapeString(page.toString()))
            .replaceAll("\\{" + "PageSize" + "\\}", apiClient.escapeString(pageSize.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));
        if (shortBy != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "ShortBy", shortBy));
        if (sortMethod != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "SortMethod", sortMethod));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call gettingAllActiveMailingListsWithPagingValidateBeforeCall(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingAllActiveMailingListsWithPaging(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingAllActiveMailingListsWithPaging(Async)");
        }
        
        // verify the required parameter 'page' is set
        if (page == null) {
            throw new ApiException("Missing the required parameter 'page' when calling gettingAllActiveMailingListsWithPaging(Async)");
        }
        
        // verify the required parameter 'pageSize' is set
        if (pageSize == null) {
            throw new ApiException("Missing the required parameter 'pageSize' when calling gettingAllActiveMailingListsWithPaging(Async)");
        }
        
        
        com.squareup.okhttp.Call call = gettingAllActiveMailingListsWithPagingCall(format, apikey, page, pageSize, shortBy, sortMethod, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Getting all active mailing lists with paging
     * Gets a list of your active mailing lists in your account. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param page The page that you want to get. (required)
     * @param pageSize Lists Per Page. (required)
     * @param shortBy The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param sortMethod The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @return GettingAllActiveMailingListsWithPagingResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GettingAllActiveMailingListsWithPagingResponse gettingAllActiveMailingListsWithPaging(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod) throws ApiException {
        ApiResponse<GettingAllActiveMailingListsWithPagingResponse> resp = gettingAllActiveMailingListsWithPagingWithHttpInfo(format, apikey, page, pageSize, shortBy, sortMethod);
        return resp.getData();
    }

    /**
     * Getting all active mailing lists with paging
     * Gets a list of your active mailing lists in your account. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param page The page that you want to get. (required)
     * @param pageSize Lists Per Page. (required)
     * @param shortBy The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param sortMethod The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @return ApiResponse&lt;GettingAllActiveMailingListsWithPagingResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GettingAllActiveMailingListsWithPagingResponse> gettingAllActiveMailingListsWithPagingWithHttpInfo(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod) throws ApiException {
        com.squareup.okhttp.Call call = gettingAllActiveMailingListsWithPagingValidateBeforeCall(format, apikey, page, pageSize, shortBy, sortMethod, null, null);
        Type localVarReturnType = new TypeToken<GettingAllActiveMailingListsWithPagingResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Getting all active mailing lists with paging (asynchronously)
     * Gets a list of your active mailing lists in your account. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param page The page that you want to get. (required)
     * @param pageSize Lists Per Page. (required)
     * @param shortBy The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param sortMethod The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call gettingAllActiveMailingListsWithPagingAsync(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod, final ApiCallback<GettingAllActiveMailingListsWithPagingResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = gettingAllActiveMailingListsWithPagingValidateBeforeCall(format, apikey, page, pageSize, shortBy, sortMethod, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingAllActiveMailingListsWithPagingResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for gettingMailingListDetails
     * @param format  (required)
     * @param mailingListID The ID of the mailing list to be returned. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param withStatistics Specifies whether to fetch statistics for the subscribers or not. If omitted, results will be returned with statistics by default. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call gettingMailingListDetailsCall(String format, String mailingListID, String apikey, String withStatistics, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/details.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));
        if (withStatistics != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "WithStatistics", withStatistics));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call gettingMailingListDetailsValidateBeforeCall(String format, String mailingListID, String apikey, String withStatistics, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingMailingListDetails(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling gettingMailingListDetails(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingMailingListDetails(Async)");
        }
        
        
        com.squareup.okhttp.Call call = gettingMailingListDetailsCall(format, mailingListID, apikey, withStatistics, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Getting mailing list details
     * Gets details for a given mailing list. You may include subscriber statistics in your results or not. Any segments existing for the requested mailing list will not be included in the results.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list to be returned. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param withStatistics Specifies whether to fetch statistics for the subscribers or not. If omitted, results will be returned with statistics by default. (optional)
     * @return GettingMailingListDetailsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GettingMailingListDetailsResponse gettingMailingListDetails(String format, String mailingListID, String apikey, String withStatistics) throws ApiException {
        ApiResponse<GettingMailingListDetailsResponse> resp = gettingMailingListDetailsWithHttpInfo(format, mailingListID, apikey, withStatistics);
        return resp.getData();
    }

    /**
     * Getting mailing list details
     * Gets details for a given mailing list. You may include subscriber statistics in your results or not. Any segments existing for the requested mailing list will not be included in the results.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list to be returned. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param withStatistics Specifies whether to fetch statistics for the subscribers or not. If omitted, results will be returned with statistics by default. (optional)
     * @return ApiResponse&lt;GettingMailingListDetailsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GettingMailingListDetailsResponse> gettingMailingListDetailsWithHttpInfo(String format, String mailingListID, String apikey, String withStatistics) throws ApiException {
        com.squareup.okhttp.Call call = gettingMailingListDetailsValidateBeforeCall(format, mailingListID, apikey, withStatistics, null, null);
        Type localVarReturnType = new TypeToken<GettingMailingListDetailsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Getting mailing list details (asynchronously)
     * Gets details for a given mailing list. You may include subscriber statistics in your results or not. Any segments existing for the requested mailing list will not be included in the results.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list to be returned. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param withStatistics Specifies whether to fetch statistics for the subscribers or not. If omitted, results will be returned with statistics by default. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call gettingMailingListDetailsAsync(String format, String mailingListID, String apikey, String withStatistics, final ApiCallback<GettingMailingListDetailsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = gettingMailingListDetailsValidateBeforeCall(format, mailingListID, apikey, withStatistics, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingMailingListDetailsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for removingACustomField
     * @param format  (required)
     * @param customFieldID The ID of the custom field to be deleted. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the custom field belongs. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call removingACustomFieldCall(String format, String customFieldID, String apikey, String mailingListID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/customfields/{CustomFieldID}/delete.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CustomFieldID" + "\\}", apiClient.escapeString(customFieldID.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call removingACustomFieldValidateBeforeCall(String format, String customFieldID, String apikey, String mailingListID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling removingACustomField(Async)");
        }
        
        // verify the required parameter 'customFieldID' is set
        if (customFieldID == null) {
            throw new ApiException("Missing the required parameter 'customFieldID' when calling removingACustomField(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling removingACustomField(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling removingACustomField(Async)");
        }
        
        
        com.squareup.okhttp.Call call = removingACustomFieldCall(format, customFieldID, apikey, mailingListID, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Removing a custom field
     * Removes a custom field definition from the specified mailing list.
     * @param format  (required)
     * @param customFieldID The ID of the custom field to be deleted. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the custom field belongs. (required)
     * @return RemovingACustomFieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RemovingACustomFieldResponse removingACustomField(String format, String customFieldID, String apikey, String mailingListID) throws ApiException {
        ApiResponse<RemovingACustomFieldResponse> resp = removingACustomFieldWithHttpInfo(format, customFieldID, apikey, mailingListID);
        return resp.getData();
    }

    /**
     * Removing a custom field
     * Removes a custom field definition from the specified mailing list.
     * @param format  (required)
     * @param customFieldID The ID of the custom field to be deleted. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the custom field belongs. (required)
     * @return ApiResponse&lt;RemovingACustomFieldResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RemovingACustomFieldResponse> removingACustomFieldWithHttpInfo(String format, String customFieldID, String apikey, String mailingListID) throws ApiException {
        com.squareup.okhttp.Call call = removingACustomFieldValidateBeforeCall(format, customFieldID, apikey, mailingListID, null, null);
        Type localVarReturnType = new TypeToken<RemovingACustomFieldResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Removing a custom field (asynchronously)
     * Removes a custom field definition from the specified mailing list.
     * @param format  (required)
     * @param customFieldID The ID of the custom field to be deleted. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the custom field belongs. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call removingACustomFieldAsync(String format, String customFieldID, String apikey, String mailingListID, final ApiCallback<RemovingACustomFieldResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = removingACustomFieldValidateBeforeCall(format, customFieldID, apikey, mailingListID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RemovingACustomFieldResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updatingACustomField
     * @param format  (required)
     * @param customFieldID The ID of the custom field to be updated. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the custom field belongs. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updatingACustomFieldCall(String format, String customFieldID, String apikey, String mailingListID, UpdatingACustomFieldRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/customfields/{CustomFieldID}/update.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CustomFieldID" + "\\}", apiClient.escapeString(customFieldID.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updatingACustomFieldValidateBeforeCall(String format, String customFieldID, String apikey, String mailingListID, UpdatingACustomFieldRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling updatingACustomField(Async)");
        }
        
        // verify the required parameter 'customFieldID' is set
        if (customFieldID == null) {
            throw new ApiException("Missing the required parameter 'customFieldID' when calling updatingACustomField(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling updatingACustomField(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling updatingACustomField(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatingACustomField(Async)");
        }
        
        
        com.squareup.okhttp.Call call = updatingACustomFieldCall(format, customFieldID, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Updating a custom field
     * Updates the properties of an existing custom field in the specified mailing list.
     * @param format  (required)
     * @param customFieldID The ID of the custom field to be updated. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the custom field belongs. (required)
     * @param body  (required)
     * @return UpdatingACustomFieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UpdatingACustomFieldResponse updatingACustomField(String format, String customFieldID, String apikey, String mailingListID, UpdatingACustomFieldRequest body) throws ApiException {
        ApiResponse<UpdatingACustomFieldResponse> resp = updatingACustomFieldWithHttpInfo(format, customFieldID, apikey, mailingListID, body);
        return resp.getData();
    }

    /**
     * Updating a custom field
     * Updates the properties of an existing custom field in the specified mailing list.
     * @param format  (required)
     * @param customFieldID The ID of the custom field to be updated. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the custom field belongs. (required)
     * @param body  (required)
     * @return ApiResponse&lt;UpdatingACustomFieldResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UpdatingACustomFieldResponse> updatingACustomFieldWithHttpInfo(String format, String customFieldID, String apikey, String mailingListID, UpdatingACustomFieldRequest body) throws ApiException {
        com.squareup.okhttp.Call call = updatingACustomFieldValidateBeforeCall(format, customFieldID, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<UpdatingACustomFieldResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Updating a custom field (asynchronously)
     * Updates the properties of an existing custom field in the specified mailing list.
     * @param format  (required)
     * @param customFieldID The ID of the custom field to be updated. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list where the custom field belongs. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updatingACustomFieldAsync(String format, String customFieldID, String apikey, String mailingListID, UpdatingACustomFieldRequest body, final ApiCallback<UpdatingACustomFieldResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updatingACustomFieldValidateBeforeCall(format, customFieldID, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdatingACustomFieldResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updatingAMailingList
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to be updated. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updatingAMailingListCall(String format, String apikey, String mailingListID, UpdatingAMailingListRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/update.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updatingAMailingListValidateBeforeCall(String format, String apikey, String mailingListID, UpdatingAMailingListRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling updatingAMailingList(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling updatingAMailingList(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling updatingAMailingList(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatingAMailingList(Async)");
        }
        
        
        com.squareup.okhttp.Call call = updatingAMailingListCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Updating a mailing list
     * Updates the properties of an existing mailing list.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to be updated. (required)
     * @param body  (required)
     * @return UpdatingAMailingListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UpdatingAMailingListResponse updatingAMailingList(String format, String apikey, String mailingListID, UpdatingAMailingListRequest body) throws ApiException {
        ApiResponse<UpdatingAMailingListResponse> resp = updatingAMailingListWithHttpInfo(format, apikey, mailingListID, body);
        return resp.getData();
    }

    /**
     * Updating a mailing list
     * Updates the properties of an existing mailing list.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to be updated. (required)
     * @param body  (required)
     * @return ApiResponse&lt;UpdatingAMailingListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UpdatingAMailingListResponse> updatingAMailingListWithHttpInfo(String format, String apikey, String mailingListID, UpdatingAMailingListRequest body) throws ApiException {
        com.squareup.okhttp.Call call = updatingAMailingListValidateBeforeCall(format, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<UpdatingAMailingListResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Updating a mailing list (asynchronously)
     * Updates the properties of an existing mailing list.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param mailingListID The ID of the mailing list to be updated. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updatingAMailingListAsync(String format, String apikey, String mailingListID, UpdatingAMailingListRequest body, final ApiCallback<UpdatingAMailingListResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updatingAMailingListValidateBeforeCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdatingAMailingListResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
