/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.wrapper.sticky;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.cz.widget.recyclerview.adapter.wrapper.header.HeaderWrapperAdapter;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.StickyCallback;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.StickyGroupingStrategy;

public class StickyWrapperAdapter<A extends RecyclerView.Adapter>
extends HeaderWrapperAdapter {
    private static final int STICKY_HEADER_ITEM = -128;
    private A adapter;

    public StickyWrapperAdapter(@NonNull A adapter) {
        super((RecyclerView.Adapter)adapter);
        this.adapter = adapter;
    }

    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        StickyGroupingStrategy groupingStrategy = ((StickyCallback)this.adapter).getGroupingStrategy();
        groupingStrategy.setOnAdapterGroupingListener(new StickyGroupingStrategy.OnAdapterGroupingListener(){

            @Override
            public int onAdapterGroup(int position) {
                int extraViewCount = StickyWrapperAdapter.this.getExtraViewCount(position);
                return position + extraViewCount;
            }
        });
        groupingStrategy.updateAdapterGroup();
    }

    @Override
    public void setAdapter(@NonNull RecyclerView.Adapter adapter) {
        super.setAdapter(adapter);
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType <= -128) {
            return new RecyclerView.ViewHolder(((StickyCallback)this.adapter).onCreateStickyView(parent, -128 - viewType)){};
        }
        return super.onCreateViewHolder(parent, viewType);
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        int viewType = this.getItemViewType(position);
        if (viewType <= -128) {
            int stickyViewType = ((StickyCallback)this.adapter).getStickyViewType(position);
            ((StickyCallback)this.adapter).onBindStickyView(holder.itemView, stickyViewType, position);
        } else {
            super.onBindViewHolder(holder, position);
        }
    }

    @Override
    public int getItemCount() {
        int itemCount = super.getItemCount();
        StickyGroupingStrategy groupingStrategy = ((StickyCallback)this.adapter).getGroupingStrategy();
        return itemCount + groupingStrategy.getGroupCount();
    }

    @Override
    public int getItemViewType(int position) {
        StickyGroupingStrategy groupingStrategy = ((StickyCallback)this.adapter).getGroupingStrategy();
        if (groupingStrategy.isGroupPosition(position)) {
            int stickyViewType = ((StickyCallback)this.adapter).getStickyViewType(position);
            return -128 - stickyViewType;
        }
        return super.getItemViewType(position);
    }

    @Override
    public int getExtraViewCount(int position) {
        int extraViewCount = super.getExtraViewCount(position);
        StickyGroupingStrategy groupingStrategy = ((StickyCallback)this.adapter).getGroupingStrategy();
        int groupCount = groupingStrategy.getGroupCount(position);
        return extraViewCount + groupCount;
    }

    @Override
    public int getOffsetPosition(int position) {
        int extraViewCount = this.getExtraViewCount(position);
        return position + extraViewCount;
    }
}

