/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.wrapper.sticky;

import android.annotation.SuppressLint;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.StickyCallback;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.StickyGroupingStrategy;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.StickyOverlayViewGroup;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.StickyScrollable;
import java.util.LinkedList;

public class StickyRecyclerViewScrollListener<A extends RecyclerView.Adapter>
implements StickyScrollable<RecyclerView> {
    private static final String TAG = "StickyRecyclerViewScrollListener";
    private StickyRecyclerBin recyclerBin = new StickyRecyclerBin();
    private StickyOverlayViewGroup stickyOverlay;
    private OrientationHelper orientationHelper;
    private int lastStickyItemPosition = -1;
    private int orientation;
    private A adapter;

    public StickyRecyclerViewScrollListener(RecyclerView recyclerView, @NonNull A adapter, @NonNull StickyOverlayViewGroup stickyOverlay) {
        this.adapter = adapter;
        this.stickyOverlay = stickyOverlay;
        this.orientation = this.getOrientation(recyclerView);
        this.orientationHelper = OrientationHelper.createOrientationHelper((RecyclerView.LayoutManager)recyclerView.getLayoutManager(), (int)this.orientation);
    }

    private int getOrientation(RecyclerView recyclerView) {
        int orientation = 1;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            orientation = linearLayoutManager.getOrientation();
        }
        return orientation;
    }

    private int findFirstVisibleItemPosition(@NonNull RecyclerView recyclerView) {
        int firstVisibleItemPosition = -1;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
            firstVisibleItemPosition = gridLayoutManager.findFirstVisibleItemPosition();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
            int[] spanArray = new int[]{staggeredGridLayoutManager.getSpanCount()};
            staggeredGridLayoutManager.findFirstVisibleItemPositions(spanArray);
            for (int i = 0; i < spanArray.length; ++i) {
                if (firstVisibleItemPosition >= spanArray[i]) continue;
                firstVisibleItemPosition = spanArray[i];
            }
        } else if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            firstVisibleItemPosition = linearLayoutManager.findFirstVisibleItemPosition();
        }
        return firstVisibleItemPosition;
    }

    private int findLastVisibleItemPosition(@NonNull RecyclerView recyclerView) {
        int lastVisibleItemPosition = -1;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
            lastVisibleItemPosition = gridLayoutManager.findLastVisibleItemPosition();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
            int[] spanArray = new int[]{staggeredGridLayoutManager.getSpanCount()};
            staggeredGridLayoutManager.findFirstVisibleItemPositions(spanArray);
            for (int i = 0; i < spanArray.length; ++i) {
                if (lastVisibleItemPosition >= spanArray[i]) continue;
                lastVisibleItemPosition = spanArray[i];
            }
        } else if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            lastVisibleItemPosition = linearLayoutManager.findLastVisibleItemPosition();
        }
        return lastVisibleItemPosition;
    }

    private int getLayoutSpanCount(RecyclerView recyclerView) {
        int spanCount = 1;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
            spanCount = gridLayoutManager.getSpanCount();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
            spanCount = staggeredGridLayoutManager.getSpanCount();
        }
        return spanCount;
    }

    @Override
    @SuppressLint(value={"Range"})
    public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
        int toPosition;
        int fromPosition;
        int layoutSpanCount = this.getLayoutSpanCount(recyclerView);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        StickyGroupingStrategy groupingStrategy = ((StickyCallback)this.adapter).getGroupingStrategy();
        int firstVisibleItemPosition = this.findFirstVisibleItemPosition(recyclerView);
        View stickyHeaderView = this.stickyOverlay.findStickyView(this.lastStickyItemPosition);
        if (this.lastStickyItemPosition < firstVisibleItemPosition + 1) {
            fromPosition = this.lastStickyItemPosition;
            toPosition = firstVisibleItemPosition + layoutSpanCount;
        } else {
            fromPosition = groupingStrategy.getGroupStartPosition(this.lastStickyItemPosition - 1);
            toPosition = this.lastStickyItemPosition;
        }
        if (fromPosition == toPosition || !groupingStrategy.isGroupPosition(this.lastStickyItemPosition)) {
            View lastStickyView = this.stickyOverlay.findStickyView(this.lastStickyItemPosition);
            if (null != lastStickyView) {
                int stickyViewType = ((StickyCallback)this.adapter).getStickyViewType(this.lastStickyItemPosition);
                this.recyclerBin.recycler(stickyViewType, lastStickyView);
            }
            this.lastStickyItemPosition = -1;
        }
        for (int position = fromPosition; position <= toPosition; ++position) {
            int decoratedEnd;
            if (this.lastStickyItemPosition == position || !groupingStrategy.isGroupPosition(position)) continue;
            int startPosition = groupingStrategy.getGroupStartPosition(position);
            View stickAdapterView = layoutManager.findViewByPosition(startPosition);
            if (null != stickAdapterView) {
                int decoratedStart = this.orientationHelper.getDecoratedStart(stickAdapterView);
                if (0 < decoratedStart) break;
                View lastStickyView = this.stickyOverlay.findStickyView(this.lastStickyItemPosition);
                if (null != lastStickyView) {
                    int stickyViewType = ((StickyCallback)this.adapter).getStickyViewType(this.lastStickyItemPosition);
                    this.recyclerBin.recycler(stickyViewType, lastStickyView);
                }
                Log.i((String)TAG, (String)("move forward firstVisibleItemPosition:" + firstVisibleItemPosition + " lastStickyItemPosition:" + this.lastStickyItemPosition + " newPosition:" + position));
                stickyHeaderView = this.createStickyView(layoutManager, startPosition);
                this.lastStickyItemPosition = startPosition;
                break;
            }
            View firstVisibleAdapterView = layoutManager.findViewByPosition(firstVisibleItemPosition);
            if (null == firstVisibleAdapterView || 0 > (decoratedEnd = this.orientationHelper.getDecoratedEnd(firstVisibleAdapterView))) break;
            View lastStickyView = this.stickyOverlay.findStickyView(this.lastStickyItemPosition);
            if (null != lastStickyView) {
                int stickyViewType = ((StickyCallback)this.adapter).getStickyViewType(this.lastStickyItemPosition);
                this.recyclerBin.recycler(stickyViewType, lastStickyView);
            }
            Log.i((String)TAG, (String)("move backward firstVisibleItemPosition:" + firstVisibleItemPosition + " lastStickyItemPosition:" + this.lastStickyItemPosition + " newPosition:" + position));
            stickyHeaderView = this.createStickyView(layoutManager, startPosition);
            this.lastStickyItemPosition = startPosition;
            break;
        }
        if (null != stickyHeaderView) {
            View nextAdapterView;
            int lastVisibleItemPosition;
            int nextStickyPosition;
            stickyHeaderView.setTranslationY(0.0f);
            if (0 != stickyHeaderView.getTop()) {
                stickyHeaderView.offsetTopAndBottom(-stickyHeaderView.getTop());
            }
            if (-1 != (nextStickyPosition = this.findGroupPosition(groupingStrategy, firstVisibleItemPosition + 1, lastVisibleItemPosition = this.findLastVisibleItemPosition(recyclerView))) && null != (nextAdapterView = layoutManager.findViewByPosition(nextStickyPosition)) && nextAdapterView.getTop() < stickyHeaderView.getHeight()) {
                stickyHeaderView.setTranslationY((float)(nextAdapterView.getTop() - stickyHeaderView.getHeight()));
            }
        }
    }

    @SuppressLint(value={"Range"})
    private View createStickyView(RecyclerView.LayoutManager layoutManager, int position) {
        View stickyView = this.stickyOverlay.findStickyView(position);
        int stickyViewType = ((StickyCallback)this.adapter).getStickyViewType(position);
        if (null != stickyView) {
            ((StickyCallback)this.adapter).onBindStickyView(stickyView, stickyViewType, position);
        } else {
            stickyView = this.recyclerBin.getViewFromScrap(position, stickyViewType);
            if (null != stickyView) {
                ((StickyCallback)this.adapter).onBindStickyView(stickyView, stickyViewType, position);
                this.stickyOverlay.addView(stickyView);
            } else {
                View stickAdapterView = layoutManager.findViewByPosition(position);
                if (null != stickAdapterView) {
                    ViewGroup overlayView = this.stickyOverlay.getOverlayView();
                    int viewType = ((StickyCallback)this.adapter).getStickyViewType(position);
                    stickyView = this.recyclerBin.getView(overlayView, position, viewType);
                    int decoratedMeasurementInOther = this.orientationHelper.getDecoratedMeasurementInOther(stickAdapterView);
                    if (0 == this.orientation) {
                        this.stickyOverlay.measureChild(stickyView, View.MeasureSpec.makeMeasureSpec((int)-2, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)decoratedMeasurementInOther, (int)0x40000000));
                        stickyView.layout(stickAdapterView.getLeft(), stickAdapterView.getTop(), stickAdapterView.getLeft() + stickyView.getMeasuredWidth(), stickAdapterView.getBottom());
                    } else {
                        this.stickyOverlay.measureChild(stickyView, View.MeasureSpec.makeMeasureSpec((int)decoratedMeasurementInOther, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)-2, (int)Integer.MIN_VALUE));
                        stickyView.layout(stickAdapterView.getLeft(), stickAdapterView.getTop(), stickAdapterView.getRight(), stickAdapterView.getTop() + stickyView.getMeasuredHeight());
                    }
                    ((StickyCallback)this.adapter).onBindStickyView(stickyView, stickyViewType, position);
                    this.stickyOverlay.addView(stickyView);
                }
            }
        }
        return stickyView;
    }

    private int findGroupPosition(StickyGroupingStrategy groupingStrategy, int position, int lastVisibleItemPosition) {
        int findPosition = -1;
        for (int i = position; i <= lastVisibleItemPosition; ++i) {
            if (!groupingStrategy.isGroupPosition(i)) continue;
            findPosition = i;
            break;
        }
        return findPosition;
    }

    public class StickyRecyclerBin {
        public SparseArray<LinkedList<View>> scrapArray = new SparseArray();

        public void clear() {
            this.scrapArray.clear();
        }

        public void addScrapView(int stickyViewType, @NonNull View view) {
            LinkedList<View> viewList = (LinkedList<View>)this.scrapArray.get(stickyViewType);
            if (null == viewList) {
                viewList = new LinkedList<View>();
                this.scrapArray.put(stickyViewType, viewList);
            }
            viewList.add(view);
        }

        public void recycler(int viewType, View view) {
            StickyRecyclerViewScrollListener.this.stickyOverlay.remove(view);
            StickyRecyclerViewScrollListener.this.recyclerBin.addScrapView(viewType, view);
        }

        @Nullable
        private View getViewFromScrap(int position, int stickyViewType) {
            View stickyView = null;
            LinkedList viewList = (LinkedList)this.scrapArray.get(stickyViewType);
            if (null != viewList && !viewList.isEmpty()) {
                stickyView = (View)viewList.pollFirst();
            }
            if (null != stickyView) {
                StickyOverlayViewGroup.LayoutParams layoutParams = (StickyOverlayViewGroup.LayoutParams)stickyView.getLayoutParams();
                layoutParams.position = position;
            }
            return stickyView;
        }

        @NonNull
        public View getView(ViewGroup parent, int position, int stickyViewType) {
            if (null == StickyRecyclerViewScrollListener.this.adapter) {
                throw new NullPointerException("The adapter was null, Make sure you set up the adapter!");
            }
            LinkedList viewList = (LinkedList)this.scrapArray.get(stickyViewType);
            View stickyView = null == viewList || viewList.isEmpty() ? ((StickyCallback)StickyRecyclerViewScrollListener.this.adapter).onCreateStickyView(parent, stickyViewType) : (View)viewList.pollFirst();
            StickyOverlayViewGroup.LayoutParams layoutParams = (StickyOverlayViewGroup.LayoutParams)stickyView.getLayoutParams();
            layoutParams.position = position;
            return stickyView;
        }
    }
}

